//--------------------------------------------------------------------------------------
// 21.3.2010 GW
#include "Constant.fx"
#include "ConstantBuffer.fx"

//--------------------------------------------------------------------------------------
struct VSIn
{
    float4 Pos		: POSITION;
    float4 Col		: TEXCOORD;
};

struct VSOut
{ 
	float4 Pos			: SV_POSITION;
	float4 Col			: TEXCOORD0; 
};

struct PSOut
{
	float4 c0 : SV_TARGET0;	// worldpos.xyz, length(eyeVector)
	float4 c1 : SV_TARGET1;	// worldnorm.xyz, 1
	float4 c2 : SV_TARGET2;	// diffuse.rgba
	float4 c3 : SV_TARGET3;	// specular.rgb, glossiness
	float4 c4 : SV_TARGET4;	// selfillum.rgb, 1
	float4 c5 : SV_TARGET5;	// motion.xyz, 1
};

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	float w = IN.Pos.w;

	if (w > 0)
	{
		// Position in world space, need to be transformed to view space then to screnspace.
		float4 WorldPos		= float4(IN.Pos.xyz, 1.0f);
		float4 ViewPos		= mul(WorldPos, View);
		float4 ProjPos		= mul(ViewPos, Proj);
		OUT.Pos				= ProjPos;
	}
	else
	{
		// Pretransformed Position, simply output it and put .w to 1 to cancel the dection hack.
		OUT.Pos = float4(IN.Pos.xyz, 1.0f);
	}

    OUT.Col = IN.Col;

	return OUT;
}

//--------------------------------------------------------------------------------------
PSOut PS(VSOut IN)
{
	PSOut OUT;
	OUT.c0 = 0;
	OUT.c1 = 0;
	OUT.c2 = 0;
	OUT.c3 = 0;
	OUT.c4 = IN.Col;
	OUT.c5 = 0;
	return OUT;
}

//--------------------------------------------------------------------------------------
technique11 tWireframe
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(AlphaBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(Wireframe);
    }
}

technique11 tWireframeNoDepthTest
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetDepthStencilState(DisableDepth, 0);
		SetBlendState(AlphaBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(Wireframe);
    }
}

technique11 tFilled
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(AlphaBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(CullBack);
    }
}

technique11 tFilledNoDepthTest
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetDepthStencilState(DisableDepth, 0);
		SetBlendState(AlphaBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(CullBack);
    }
}
