#include "HDR.fx"

cbuffer CSConstants : register(b0)
{
	float g_Exposure : packoffset(c0.x);
};

Texture2D<float4>	g_HDRTextureInput	: register(t0);
RWTexture2D<float4>	g_LDRTextureOutput	: register(u0);

[numthreads(16, 16, 1)]
void CSTonemap(uint3 DispatchThreadID : SV_DispatchThreadID, uint3 GroupID : SV_GroupID)
{
 	int3 coords = int3(DispatchThreadID.xy,0);
 	float3 rgb = g_HDRTextureInput.Load(coords).rgb;
//	rgb = Tonemap(rgb, g_Exposure);
	g_LDRTextureOutput[DispatchThreadID.xy] = float4(rgb, 1.0f);
}

technique11
{
	pass p0
	{
		SetComputeShader(CompileShader(cs_5_0, CSTonemap())); 
	}
}