// 24/10/2010 Guillaume

#error should be unused

#include "Constant.fx"
#include "Deferred.fx"

RWTexture3D<float4> g_volumeXN : register (u0);
RWTexture3D<float4> g_volumeXP : register (u1);
RWTexture3D<float4> g_volumeYN : register (u2);
RWTexture3D<float4> g_volumeYP : register (u3);
RWTexture3D<float4> g_volumeZN : register (u4);
RWTexture3D<float4> g_volumeZP : register (u5);

float4 g_min;
float4 g_size;

struct BVHNode
{
	float3 a;
	float3 b;
	float3 c;
	float2 uva;
	float2 uvb;
	float2 uvc;
	int isTriangle;
	int next;
	int escape;
};

struct Output
{
	float4 xn;
	float4 xp;
	float4 yn;
	float4 yp;
	float4 zn;
	float4 zp;
};

StructuredBuffer<BVHNode>	g_nodes;
StructuredBuffer<float3>	g_directions;
RWStructuredBuffer<float4>	g_output : register (u6);
Texture2D<float4>			g_unwrap;

struct Hit
{
	float2	uv;
	float	dist;
};

Hit Intersects(BVHNode node, float3 o, float3 d, float minT, Hit lastHit)
{	
	float3 a	= node.a;
	float3 b	= node.b;
	float3 c	= node.c;
	float2 uva	= node.uva;
	float2 uvb	= node.uvb;
	float2 uvc	= node.uvc;

	// uses intersection test from
	//"a fast minimum-storage triangle intersection test"
	//lastHit contains information of the previous hit -
	float3 e1 = b - a;
	float3 e2 = c - a;
	float3 p = cross(d, e2);
	float det = dot(p, e1);
	bool isHit = det > 0.00001f; //the triangle is nearly edge-on
	float invdet = 1.0f / det;
	float3 tvec = o - a;
	float u = dot(p, tvec) * invdet;
	float3 q = cross(tvec, e1);
	float v = dot(q, d) * invdet;
	float t = dot(q, e2) * invdet;
	
	isHit = (u >= 0.0f) && (v >= 0.0f)
	&& (u + v <= 1.0f) 
	&& (t >= 0.0f)
	&& (t < lastHit.dist)
	&& (t > minT);

	Hit newHit;
	newHit.uv	= uva + u * (uvb-uva) + v * (uvc-uva);
	newHit.dist	= t;
	if (isHit)
		return newHit;
	else
		return lastHit;
}


[numthreads(1, 1, 1)]
void CSMain(uint3 dtid : SV_DispatchThreadID, uint groupIndex : SV_GroupIndex)
{
	float farAway = 10e+38;

// 	BVHNode n = g_nodes[0];
// 	float3 o = float3(0.5,0.5,-1);
// 	float3 d = float3(0,0,1);
// 	float4 ret = float4(0,0,999999999,0);
// 	ret = Intersects(n.a, n.b, n.c, o, d, 0, 0, ret);
// 	g_output[0] = ret;
	
 	uint width, height, depth;
 	g_volumeXN.GetDimensions(width, height, depth);
 
 	float3 coeffs =  float3( 
	(float)dtid.x / (float)width,
	(float)dtid.y / (float)height,
	(float)dtid.z / (float)depth );
 
 	float3 pos		= g_min.xyz + g_size.xyz * coeffs;
 		
 	Output o;
 	o.xn = float4(0,0,0,0);
 	o.xp = float4(0,0,0,0);
 	o.yn = float4(0,0,0,0);
 	o.yp = float4(0,0,0,0);
 	o.zn = float4(0,0,0,0);
 	o.zp = float4(0,0,0,0);

	uint nodeCount, nodeStride;
	g_nodes.GetDimensions(nodeCount, nodeStride);

	uint dirCount, dirStride;
	g_directions.GetDimensions(dirCount, dirStride);

	for (uint idir=0; idir<dirCount; idir++)
	{
		float3 dir = g_directions[idir];

		Hit h;
		h.uv	= float2(0,0);
		h.dist	= farAway;

		for (uint inode=0; inode<nodeCount; inode++)
		{
			h = Intersects(g_nodes[inode], pos, dir, 0.0f, h);
		}

		float4 color = g_unwrap.SampleLevel(SamplerLinearClamp, h.uv, 0) / (float) dirCount ;

		if (h.dist < farAway)
		{
			o.xn += saturate( dot( float3(-1,0,0), dir ) ) * color;
			o.xp += saturate( dot( float3(+1,0,0), dir ) ) * color;
			o.yn += saturate( dot( float3(0,-1,0), dir ) ) * color;
			o.yp += saturate( dot( float3(0,+1,0), dir ) ) * color;
			o.zn += saturate( dot( float3(0,0,-1), dir ) ) * color;
			o.zp += saturate( dot( float3(0,0,+1), dir ) ) * color;
		}
	}
 
 	g_volumeXN[dtid] = o.xn;
 	g_volumeXP[dtid] = o.xp;
 	g_volumeYN[dtid] = o.yn;
 	g_volumeYP[dtid] = o.yp;
 	g_volumeZN[dtid] = o.zn;
 	g_volumeZP[dtid] = o.zp;
}

technique11 t0 
{ 
	pass p0
	{
		SetComputeShader(CompileShader(cs_5_0, CSMain())); 
	}
}	