
#include "Constant.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float2 Tex			: TEXCOORD0;
};

Texture2D	g_texInput;

float4 g_sampleOffset0;
float4 g_sampleOffset1;
float4 g_sampleOffset2;
float4 g_sampleOffset3;
float g_BloomThreshold;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xy;

	return OUT;
}

//--------------------------------------------------------------------------------------
float4 PSDownscale(VSOut IN) : SV_TARGET0
{
	float2 uv = IN.Tex.xy;

	float2 coords[4] = 
	{ 
		uv + g_sampleOffset0.xy, 
		uv + g_sampleOffset1.xy, 
		uv + g_sampleOffset2.xy, 
		uv + g_sampleOffset3.xy 
	} ;

	float3 rgb = 0;
	for (int i=0; i<4; i++)
	{
		float3 s = g_texInput.Sample(SamplerLinearClamp, coords[i] ).rgb;
		rgb += saturate( s - g_BloomThreshold.xxx );
	}

	return float4(rgb * 0.25f,1);
}

//--------------------------------------------------------------------------------------
float4 PSGaussian(VSOut IN) : SV_TARGET0
{
	float weights [] = { 0.234375f, 0.09375f, 0.015625f };

	float2 uv = IN.Tex.xy;

	float2 coords[3] = 
	{ 
		g_sampleOffset0.xy, 
		g_sampleOffset1.xy, 
		g_sampleOffset2.xy
	} ;

	float3 rgb = g_texInput.Sample(SamplerLinearClamp, uv ).rgb * 0.3125f;

	for (int i=0; i<3; i++)
	{
		rgb += g_texInput.Sample(SamplerLinearClamp, uv + coords[i] ).rgb * weights[i];
		rgb += g_texInput.Sample(SamplerLinearClamp, uv - coords[i] ).rgb * weights[i];
	}

	return float4(rgb,1);
}

//--------------------------------------------------------------------------------------
technique11 BloomDownscale
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSDownscale() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}

//--------------------------------------------------------------------------------------
technique11 BloomGaussian
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSGaussian() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}