// mog
/*jslint devel: true, browser: true */
var Drive = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _canvas,
        _ctx,
        MAX_SEGMENT = 12,//53,
        MAX_Z = 100,
        particle = [];

    function init(duration, model) {

        console.log("Drive - init()");

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');
        _canvas = document.createElement('canvas');
        _ctx = _canvas.getContext('2d');
        _canvas.width = _width;
        _canvas.height = _height;

        _canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(_canvas);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--

        initFlyThrough();
        
        var overlay = document.createElement('div');
        if(Demo.isOutlineVersion)
        	overlay.style.backgroundImage = "url(" + Meat.over3His.src +")";
        else
        	overlay.style.backgroundImage = "url(" + Meat.over3Her.src +")";
        
        overlay.setAttribute('class', 'overlay');
        		
        overlay.style.width = _width +'px';
        overlay.style.height = _height +'px';	
        _holder.appendChild(overlay);
    }

    var _parallax = [];

    function render(sceneTime, floatBeat, frameDelta) {

	if(Demo.isOutlineVersion) {
        if (_parallax.length === 0) {
            for (var c = 0; c < 3; c++) {
                _parallax.push({
                    offset  :0,
                    duration:(4 - c + 1) * 1000,
                    endTime :sceneTime + (4 - c + 1) * 1000
                });
            }
        }

        var scaledWidth = (3840 * 2) / 1920 * _width;

        for (var a = 0; a < _parallax.length; a++) {

            _parallax[a].offset = scaledWidth -
                (scaledWidth / _parallax[a].duration * ( _parallax[a].endTime - sceneTime));

            if (_parallax[a].offset >= (scaledWidth / 2)) {
                _parallax[a].offset = 0;
                _parallax[a].endTime = sceneTime + (4 - a + 1) * 1000;
            }

            _ctx.drawImage(Meat['train' + a], (1046 / 1920 * _width) + -_parallax[a].offset, 180 / 1080 *
                _height, scaledWidth, 745 /
                1080 * _height);
        }

        _ctx.drawImage(Meat.journey, 0, 0, _width, _height);
    } else {
    	 _ctx.drawImage(Meat.journey, 0, 0, _width, _height);
        flyThrough(.5);
        _ctx.drawImage(Meat.car, 0, Math.sin(sceneTime / 100) * 2, _width, _height);

        //gah
        _ctx.drawImage(Meat.journeyFix, 0, 0, _width, _height);
    }
    }

	function para(){
		
	}

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {

        if (integerBeat % 8 === 0) {

        }
    }

    function initFlyThrough() {

        var zDistance = 0;

        for (var i = 0; i < MAX_SEGMENT; i += 1) {

            particle.push({
                "x":_width / 2,//150 / 1920 * _height,
                "y":_height / 2,
                "z":MAX_Z - zDistance
            });

            zDistance += 34;
        }
    }

    function flyThrough(speed) {

        particle = particle.sort(function (a, b){
                  return ((a.z > b.z) ? -1 : ((a.z < b.z) ? 1 : 0));
                });

        var shadowParticle = [],
            halfWidth = 600 / 1920 * _height,//_height / 2, //_ctx.canvas.width / 2,
            halfHeight = _height / 2,
            vpY = 200 / 1080 * _height;//Math.sin((new Date()).getTime() / 2000) * 23;

        for (var i = 0; i < MAX_SEGMENT; i += 1) {

            var drawX = halfWidth - (particle[i].x / particle[i].z * 8),
                drawY = halfHeight - (particle[i].y / particle[i].z * 8),
                drawWidth = (halfWidth - drawX) * 2,
                drawHeight = (halfHeight - drawY) * 2;

            particle[i].z -= speed;

            if ((particle[i].z > -110) && (drawX > -2100) && (drawY > -2100)) {

                shadowParticle.push(particle[i]);

                _ctx.save();
                _ctx.translate(0, vpY);
                //_ctx.rotate(vpY * Math.PI / 180);

                if(drawWidth > 150 )
                    plot(drawX, drawY, drawWidth, drawHeight);
                _ctx.restore();

            } else {

                shadowParticle.push({"x":_width / 2,
                    "y"                 :_height / 2,
                    "z"                 :MAX_Z});
            }
        }

        particle = shadowParticle;


    }

    function plot(x, y, width, height) {


        //_ctx.globalAlpha = (100 / _ctx.canvas.width * width) / 100;
        _ctx.drawImage(Meat.streetlamp, x, y, width, height);
        //_ctx.globalAlpha = 1;
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());