uniform float t;
uniform float t_scene;
uniform float beats;
uniform float bounce;
uniform float kick;
uniform float saw;

uniform float syncdistort;

uniform vec3 lightpos;
uniform float lightradius;
uniform float falloff;
uniform vec3 fog_color;

uniform float cliffside;
uniform float cliff_stripes;
uniform float distort;
uniform float saturation;

uniform mat4 matrix;

#ifdef vertexcompile

layout (location=0) in vec3 pos;
layout (location=1) in vec3 nor;
smooth out vec3 ppos, pnor;
smooth out vec3 lightdir;
smooth out vec4 eyespace_pos;
smooth out vec4 vcolor;
smooth out vec3 lightpos_world;

void rY(inout vec3 p, float a) {
	float c,s;vec3 q=p;
	c = cos(a); s = sin(a);
	p.x = c * q.x + s * q.z;
	p.z = -s * q.x + c * q.z;
}

void main()
{

	float wavespeed = (t_scene-20.0)/32.0;
	float saw_distort = syncdistort * 1.8;	// beats with the kick drum
	
	float mayhem = distort;
	
	ppos = pos;
	vec3 newpos = pos;
	newpos.x += sin(newpos.z * 4.0 + t_scene * 3.0) * (1.0 + saw * 0.5) * (1.0 - distort);
	//newpos.x += -150.0/length(newpos.yz) * distort ;
	//newpos.x += -50.0/length(newpos.yz) * distort ;
	newpos.y += pow(length(newpos.xz)/40.0, 2.0); // reunojen kohotus
	ppos = newpos;
	pnor = -nor;
	
	lightpos_world = (matrix*vec4(lightpos, 1.0)).xyz;
	lightdir = lightpos - pos.xyz;
	eyespace_pos = matrix*vec4(newpos, 1.0);
	vcolor = vec4(1.0, 1.0, 1.0, 1.0);
	gl_Position = eyespace_pos;
}

#endif

#ifdef fragmentcompile

smooth in vec3 pnor, ppos, lightdir;
smooth in vec4 eyespace_pos;
smooth in vec4 vcolor;
smooth in vec3 lightpos_world;	// currently not used
layout (location=0) out vec4 outcol;

uniform sampler2D tex, moss, sand;

void main()
{
	float ambient = 0.05;
	float l = dot(normalize(pnor),normalize(lightdir))*.5+.5;
	float specular = pow(dot(normalize(pnor*pnor),normalize(lightdir))*.5+.5, 3.0);
	float dist = distance(lightpos, ppos);
	vec4 mossen = texture2D(moss, ppos.xz*.1);
	vec4 ys = l*pnor.y*texture2D(sand, ppos.xz*.1);
	//if(pnor.y<.0)
		//ys = -l*pnor.y*mossen;
	
	ys = mix(ys, l*pnor.y*mossen, min(1.0, max(0.0, (pnor.y-40.0)/1.0)));
		
	outcol = l*abs(pnor.x)*texture2D(sand, ppos.yz*.1)+ys+l*abs(pnor.z)*texture2D(sand, ppos.xy*.1)+vec4(vec3(.0),1.0);
	outcol.rgb *= ambient + specular*0.1 +(lightradius/pow(dist, falloff));
	
	outcol.rgb += min(0,ppos.y)/2.0; // pohjalla on pime
	
	
	float stripe_size_minus = 0.5 + saw*0.2;
	float stripes = max(0.0,  sin(eyespace_pos.z/5.0 + t_scene * 4.0) - stripe_size_minus) * 1.8 * cliff_stripes;
	outcol.rgb+= stripes;
	outcol.g -= stripes * 0.4;
	outcol.b -= stripes * 0.3;
	
	float fogFalloff = 1.9; // smaller is thicker
	float fogScale = 1.99; // bigger is thicker
	float fogAmount = pow(abs((eyespace_pos.z * fogScale)/eyespace_pos.w) , fogFalloff); 

	outcol.rgb = mix(outcol.rgb, fog_color, fogAmount);

}
#endif
