
uniform sampler2D tex;
uniform float t;
uniform float t_scene;
uniform vec2 screen;
uniform vec4 ipos;

uniform float fadeout;
uniform float beat;
uniform float saw;
uniform float bounce;
uniform float kick;

#define PI 3.1415926536

#ifdef vertexcompile

smooth out vec2 coord;
layout (location=0) in vec2 pos;

void main()
{
	coord = pos;
	vec4 fpos = ipos;
	fpos.y -= abs(bounce)*0.05+saw*0.05;
	fpos.w += abs(bounce)*0.05+saw*0.05;
	//fpos.zw += pow(bounce, 1.5)*0.1;
	fpos.yw = -fpos.yw;
	gl_Position = vec4(pos*fpos.zw+fpos.xy*2.0-vec2(1.0,-1.0), .0, 1.0);
}
#endif

#ifdef fragmentcompile

smooth in vec2 coord;
layout (location=0) out vec4 outcol;

void main()
{
	vec4 col = texture2D(tex, coord);
	outcol = col;
	vec4 glow = vec4(1.0, 1.0, 1.0, 1.0);
	outcol.rgb += 0.5 + sin(((gl_FragCoord.x/screen.x) * 10.0 + t_scene * 15.0));
	//outcol.rgb *= (1.0+sin(t_scene * 2.0 * PI * 4.0))*0.8;
	outcol.a -= fadeout*6.0;
}
#endif
