uniform sampler2D tex;
uniform float t;
uniform float t_scene;
uniform vec2 screen;
uniform vec4 ipos;
uniform float saw;
uniform float blink_factor;

#define PI 3.1415926536

#ifdef vertexcompile

smooth out vec2 coord;
layout (location=0) in vec2 pos;

void main()
{
	//float scaling = 1.0f + 0.1*sin(t);
	float scaling = 1.0;
	
	float zoom = 0.0;
	scaling += zoom;
	
	coord = pos * 1.0;
	//coord *= 1.0;
	
	vec4 fpos = ipos;
	fpos.zw *= scaling;
	fpos.yw = -fpos.yw;
	fpos.y += zoom*0.0;
	fpos.x -= zoom*0.0;
	gl_Position = vec4(pos*fpos.zw*2.0+fpos.xy*2.0-vec2(1.0,-1.0), .0, 1.0);
}
#endif

#ifdef fragmentcompile

smooth in vec2 coord;
layout (location=0) out vec4 outcol;

void main()
{
	vec4 col = texture2D(tex, coord);
	
	float fadein = min(1.0, t_scene/5.0 - 0.5); 
	float alpha = fadein;
	float timemult = 12.0;
	float blink = (t_scene*timemult - floor(t_scene*timemult));
	float screeny = gl_FragCoord.y/screen.y;
	alpha = (1.0 + sin(gl_FragCoord.y * 1.5 + t_scene * 2.0) * 0.5) * 0.5;
	
		float add = saw * 0.2 * col.r;
		col.rgb += vec3(add);
		
		vec4 glow = vec4(0.0, 0.0, 0.0, 0.0);
		int samples = 10;
		float e = 0.003;
		float glowoffset = sin(t_scene) * 0.001;

		for (int i=0;i<samples;i++) {
			vec4 sampl = texture2D(tex, coord + vec2(e * float(i) * 1.0 + glowoffset - e * float(i) * 0.8, e * float(i) * 0.0));
			glow += sampl;
		}
		
		glow.rgb *= 1.0/float(samples);
		glow.rgb *= 1.0;
		//glow.a = length(glow.rgb * 0.5);
		col.rgba += glow.rgba;
	
	alpha += blink_factor * sign(sin(t_scene * 8.0))*0.1;
	
	alpha *= 0.1;
	outcol = col;
	outcol.a *= alpha;
	
}
#endif
