
uniform sampler2D tex;
uniform float t;
uniform float t_scene;
uniform vec2 screen;
uniform vec4 ipos;

uniform float scroll_direction;
uniform float saw;


#ifdef vertexcompile

smooth out vec2 coord;
layout (location=0) in vec2 pos;

void main()
{
	coord = pos;
	vec4 fpos = ipos;
	fpos.yw = -fpos.yw * 2.0;
	fpos.z *= 2.0;
	vec4 outpos = vec4(pos*fpos.zw+fpos.xy*2.0-vec2(1.0,-1.0), .0, 1.0);
	gl_Position = outpos;
}
#endif

#ifdef fragmentcompile

smooth in vec2 coord;
layout (location=0) out vec4 outcol;

void main()
{
	vec2 realcoord = coord;
	realcoord.x *= 2.0 ;
	realcoord.x += (t_scene) * 0.5 * scroll_direction;
	realcoord.y += (saw - 1.0)*0.1*scroll_direction;
	vec4 col = texture2D(tex, realcoord);
	outcol = col;
	if (outcol.a < 0.1) {
		outcol.a = 0.5;
	}	
	//outcol.a = 0.5;
}
#endif
