uniform float t;
uniform float t_scene;
uniform float beats;
uniform float bounce;
uniform float kick;
uniform float saw;

uniform float syncdistort;

uniform vec3 lightpos;
uniform float lightradius;
uniform float falloff;
uniform vec3 fog_color;

uniform float cliffside;
uniform float cliff_stripes;
uniform float distort;

uniform float fog_falloff;
uniform float fog_scale;

uniform mat4 matrix;


#define PI 3.141592653589

#ifdef vertexcompile

layout (location=0) in vec3 pos;
layout (location=1) in vec3 nor;
smooth out vec3 ppos, pnor;
smooth out vec3 origpos;
smooth out vec3 lightdir;
smooth out vec4 eyespace_pos;
smooth out vec4 vcolor;

//function by las
void rZ(inout vec3 p, float a) {
	float c,s;vec3 q=p;
	c = cos(a); s = sin(a);
	p.x = c * q.x - s * q.y;
	p.y = s * q.x + c * q.y;
}

void rY(inout vec3 p, float a) {
	float c,s;vec3 q=p;
	c = cos(a); s = sin(a);
	p.x = c * q.x + s * q.z;
	p.z = -s * q.x + c * q.z;
}

void main()
{
	//float syncdistort = 1.0;
	//vec3 lightpos = vec3(0.0, 0.0, 0.0);
	//float distort = 0.0;
	float wavespeed = (t_scene-20.0)/32.0;
	float saw_distort = syncdistort * 1.8;	// beats with the kick drum
	
	float mayhem = 1.0;
	
	float tunnelize = 1.0/90.0 ;
		
	//distort += syncdistort * 0.4;	
	
	origpos = pos;
	ppos = pos;
	vec3 newpos = pos;
	newpos.x += 120.0;
	newpos.z *= 5.0;
	
	rZ(newpos, (newpos.y) * tunnelize);
		pnor = -nor;
	rZ(pnor, (newpos.y) * tunnelize);
	
	rY(newpos, (newpos.z) * (1.0/820.0));
	
	newpos.x += (sin(newpos.y) * 10.0 + sin(newpos.z) * 9.0) * distort;
	newpos.z = newpos.z - mod(t_scene, 1.8) * 160.0;
	newpos.xy *= 0.5 +saw*0.08 * sin(ppos.z*0.2);
	
	//newpos.x += sin(newpos.z * 4.0 + t_scene * 3.0) * (1.0 + saw * 0.5) * (1.0 - distort);
	//newpos.x += -150.0/length(newpos.yz) * distort ;
	//newpos.x += -50.0/length(newpos.yz) * distort ;
	//newpos.y += sin(0.1f*newpos.x + 0.1f*newpos.y + 0.1f*newpos.z + t) * 3.0f;
	//newpos = pos * mix(1.0, saw, 0.1f);
	//float dist = sin(0.5f * length(pos) - t*wavespeed + saw*0.2*saw_distort) * distort + saw*0.4*saw_distort;
	//newpos.y += dist * distort;
	ppos = newpos;
	//pnor = -nor * mix(1.0, dist, distort);

	//lightdir = lightpos - pos.xyz;
	lightdir = normalize(vec3(0.2, 0.3, 0.4));
	eyespace_pos = matrix*vec4(newpos, 1.0);
	vcolor = vec4(0.0, 0.0, 0.0, 1.0);
	vcolor.r +=  0.9 * max(0.0, sin(origpos.z*0.1) - 0.6) - 0.2;
	//vcolor *= sin(newpos.y * 0.1f + t_scene) * sin(newpos.z * 0.05f)  * 4.0 * (0.0 + saw*0.5);
	//vcolor.gb *= normalize(vec2(length(vcolor.rgba), vcolor.rgba));
	//vcolor.r = max(vcolor.r, 0.0);
	//vcolor.g = max(0.0, vcolor.g) * 0.2;
	//vcolor.b = max(0.0, vcolor.b) * 0.8;
	gl_Position = eyespace_pos;
}

#endif

#ifdef fragmentcompile

smooth in vec3 pnor, ppos, lightdir;
smooth in vec4 eyespace_pos;
smooth in vec3 origpos;
smooth in vec4 vcolor;
layout (location=0) out vec4 outcol;

uniform sampler2D tex, moss;

void main()
{
	//float l = dot(normalize(pnor),normalize(vec3(1.0,1.0,.5)))*.5+.5;
	float ambient = 0.05;
	float l = dot(normalize(pnor),normalize(lightdir))*.5+.5;
	float specular = pow(dot(normalize(pnor*pnor),normalize(lightdir))*.5+.5, 3.0);
	float dist = distance(lightpos, ppos);
	vec4 mossen = texture2D(moss, origpos.xz*.1);
	vec4 ys = l*pnor.y*texture2D(tex, origpos.xz*.1);
	if(pnor.y<.0)
		ys = -l*pnor.y*mossen;
	outcol = l*abs(pnor.x)*texture2D(tex, origpos.yz*.1)+ys+l*abs(pnor.z)*texture2D(tex, origpos.xy*.1)+vec4(vec3(.0),1.0);
	//outcol.rgb *= ambient + specular*0.1 +(lightradius/pow(dist, falloff));
	
		outcol.r *= 0.3;
	outcol.b *= 0.5;
	outcol.g *= 0.3 ;
	
	//outcol.rgb *= (1.0 + sin(eyespace_pos.z  + t_scene * 2.0 + saw))*0.4 + 0.6;
	float stripeadd = pow(sin((origpos.z / 10.0 + t_scene * 10.0) ), 2.0) * distort;
	stripeadd *= 0.3;
	outcol.r += stripeadd;
	outcol.g += stripeadd*0.5;
	//outcol *= stripeadd*0.5 * sin(origpos.z / 20.0 + t_scene * 10.0) ;
	
	float fogFalloff = fog_falloff; // smaller is thicker
	float fogScale = fog_scale; // bigger is thicker
	//float fogAmount = pow(abs((eyespace_pos.z * fogScale)/eyespace_pos.w) , fogFalloff); 
	float fogAmount = abs(pow(eyespace_pos.z, 1.00)/eyespace_pos.w);
	
	outcol.rgb = mix(outcol.rgb, fog_color, fogAmount);
	///outcol += vcolor;
}
#endif
