uniform float t;
uniform float t_scene;
uniform float beats;
uniform float bounce;
uniform float kick;
uniform float saw;

uniform float syncdistort;

uniform vec2 screen;

uniform vec3 lightpos;
uniform float lightradius;
uniform float falloff;
uniform vec3 fog_color;

uniform float cliffside;
uniform float cliff_stripes;
uniform float distort;


uniform float fog_falloff;
uniform float fog_scale;

uniform mat4 matrix;

#define PI 3.141592653589

#ifdef vertexcompile

layout (location=0) in vec3 pos;
layout (location=1) in vec3 nor;
smooth out vec3 origpos;
smooth out vec3 ppos;
smooth out vec3 pnor;
smooth out vec3 lightdir;
smooth out vec4 eyespace_pos;
smooth out vec4 vcolor;

void rY(inout vec3 p, float a) {
	float c,s;vec3 q=p;
	c = cos(a); s = sin(a);
	p.x = c * q.x + s * q.z;
	p.z = -s * q.x + c * q.z;
}

void main()
{
	//float distort = 5.0;
	float wavespeed = (t_scene-20.0)/32.0;
	float saw_distort = syncdistort * 1.8;	// beats with the kick drum

	origpos = pos;
	
	ppos = pos;
	vec3 newpos = pos;
	newpos.z *= 1.0 + 0.5 * ( distort + bounce *0.1);
	float scaled_time = t_scene * 2.0;
	float rotate_nykiminen =  sin(fract(scaled_time)*PI*0.5+PI*1.5)+floor(scaled_time);
	rY(newpos, 0.2*sin(newpos.y * 0.5 + sin(rotate_nykiminen * 2.0)));
	
	
	float len = length(newpos.xyz);
	newpos.xyz *= 1.5 + 0.3 * sin(len + t_scene * 4.0 );

	ppos = newpos;
	//pnor = -nor * mix(1.0, dist, distort);
	pnor = -nor;
	lightdir = lightpos - pos.xyz;
	eyespace_pos = matrix*vec4(newpos, 1.0);
	vcolor = vec4(1.0, 1.0, 1.0, 1.0);

	gl_Position = eyespace_pos;
}

#endif

#ifdef fragmentcompile

smooth in vec3 ppos, lightdir;
smooth in vec3 origpos;
smooth in vec3 pnor;
smooth in vec4 eyespace_pos;
smooth in vec4 vcolor;
layout (location=0) out vec4 outcol;

uniform sampler2D tex, moss;

void main()
{
	//float l = dot(normalize(pnor),normalize(vec3(1.0,1.0,.5)))*.5+.5;
	//vec2 texture_scroll = vec2(t_scene * 0.1, sin(ppos.x) * 0.1);
	vec2 texture_scroll = vec2(0.0, 0.0);
	float aspect_ratio = screen.x/screen.y;
	float ambient = 0.02;
	float dist_from_center = length(ppos);
	float l = dot(normalize(pnor),normalize(lightdir))*.5+.5;
	//float specular = pow(dot(normalize(pnor),normalize(lightdir))*.5+.5, 30.0);
	vec3 eyespace = eyespace_pos.xyz;
	eyespace.x *= aspect_ratio;
	float rimlight = pow(dot(normalize(pnor),normalize(gl_FragCoord.xyz))*.5+.5, 2.0);
	float dist = distance(lightpos, ppos);
	vec4 mossen = texture2D(moss, origpos.xz*.1);
	vec4 ys = l*pnor.y*texture2D(tex, origpos.xz*.1 + texture_scroll);
	if(pnor.y>.0)
		ys = -l*pnor.y*mossen;
		
	//vec4 albedo = l*abs(pnor.x)*texture2D(tex, ppos.yz*.1)+ys+l*abs(pnor.z)*texture2D(tex, ppos.xy*.1)+vec4(vec3(.0),1.0);
	vec4 albedo = l*abs(pnor.x)*texture2D(tex, origpos.yz*.1 + texture_scroll)+ys+l*abs(pnor.z)*texture2D(tex, origpos.xy*.1 + texture_scroll)+vec4(vec3(.0),1.0);
	outcol = albedo * 0.1;
	float distanceratio = min(0.03, pow(dist_from_center, 2.0)/1500.0);
	outcol += distanceratio ;
	//outcol.b += (pow(dist_from_center, 2.0)/1500.0)*0.4;
	outcol.rgb *= max(0.0, 
		ambient+(lightradius/pow(dist, falloff))
		);
		
	outcol.rgb -= saw * 1.0 * pow(distanceratio * 10.8, 2.0) ;
	//outcol.b += saw * 0.1;
	// contrast boost
	outcol.rgb *= pow(length(outcol.rgb * 3.05), 2.0);
	
	float fogFalloff = fog_falloff; // smaller is thicker
	float fogScale = fog_scale; // bigger is thicker
	float fogAmount = pow(abs((eyespace_pos.z * fogScale)/eyespace_pos.w) , fogFalloff); 
	
	outcol.rgb = mix(outcol.rgb, fog_color, fogAmount);
	

}
#endif
