;source code of LORENZ 1k intro

;written for ALASM assembler (80symb ZX-Evo edition)

;any asm applicable provided you know (and fix if needed)
; that .LABEL is lower byte of LABEL and 'LABEL -- higher byte.

;code written by lvd^mhm, music written by n1k-o^skrju, then hand-converted
; for custom player


;release was packed using MEGALZ packer (on PC) and DEC40 depacker


;code assumes that it is run from BASIC
; with interrupts set to IM1 and enabled.
;stack must be either lower than code or in #FFxx area

;also code uses 48K ROM extensively, so major ROM patches can break it.



        ORG     #8400

FBITS   EQU     10 ;fractional bits

MIDX    EQU     128 ;middle of screen for DRAW routine
MIDY    EQU     88



C4_FREQ EQU     #1A2 ;frequency for AY

        ;int table
INT_TBL EQU     #BE00



        ;48k ROM related
COORDS  EQU     23677 ;X,Y

TIMEL   EQU     #5C78

LINE            EQU     9402
CLS             EQU     #D6B
PR_STRING       EQU     #203C


ATTR_T  EQU     #5C8F
ATTR_P  EQU     #5C8D
BORDCR  EQU     #5C48



START   ;code starts here


NewFig
        LD      HL,INT_TBL
        LD      A,H
MUS_PLAY
        LD      I,A
FILL_INT
        LD      (HL),A ;fill IM2 table
        INC     (HL)
        INC     HL
        JR      NZ,FILL_INT

        LD      SP,#BFC2    ;set jump
        LD      HL,INT_PROC
        PUSH    HL
        LD      H,#C3
        PUSH    HL

        LD      IX,COUNTS
        IM      2

        RES     4,(IY+1) ;disable 128'S 48K ROM from messing up AY


;;;;;;;;SET     0,(IY+#57) ;set over 1 in P-FLAG


        LD      HL,#B845
        LD      (ATTR_P),HL
        LD      (BORDCR),HL







MAINLOOP
        CALL    CLS ;copies BORDCR to ATTR_T for DRAW routine

        LD      DE,PRINT_ME
        LD      BC,PRINT_END-PRINT_ME
        CALL    PR_STRING ;hopefully after CLS will print in lower line


        CALL    GET_XYZ

        LD      A,C
        ADD     A,MIDX
        LD      L,A
        CALL    Ybounds
        ADD     A,MIDY
        LD      H,A
        LD      (COORDS),HL





MAINLOOP2

        LD      A,(TIMEL)
        OR      A
        LD      HL,X0
        JR      NZ,noRNDmod

        LD      A,#0B
        ADD     A,(HL)
        LD      (HL),A

noRNDmod


        ;calculate lorenz curve by continuosly solving ODE with
        ;Euler 2nd order method, which gives perfect results (in comparison with
        ;1st order calculation) with rather big steps

        ;XYZ0->XYZt
;;;;;;;;LD      HL,X0
        LD      DE,Xt
        LD      BC,6
        LDIR 

        CALL    Fcalc

        ;mul F by h/2, where h=1/128.
        ;divide F by 256, then convert to single precision by
        ;SHRing 10 bits, total 18 bits right

        LD      L,.Fx+3
        CALL    SHR2L2
        EXD 
        LD      L,.Xt
        CALL    ADDEL2

        LD      L,.Fy+3
        CALL    SHR2L2
        EXD 
        LD      L,.Yt
        CALL    ADDEL2

        LD      L,.Fz+3
        CALL    SHR2L2
        EXD 
        LD      L,.Zt
        CALL    ADDEL2


        CALL    Fcalc

        ;mul by h=1/128 then SHR 10 -> SHR 17
        LD      L,.Fx+3
        CALL    SHR1L2
        EXD 
        LD      L,.X0
        CALL    ADDEL2

        LD      L,.Fy+3
        CALL    SHR1L2
        EXD 
        LD      L,.Y0
        CALL    ADDEL2

        LD      L,.Fz+3
        CALL    SHR1L2
        EXD 
        LD      L,.Z0
        CALL    ADDEL2

        ;new XYZ0 done


        ;BC = XY, ZX or ZY

        CALL    GET_XYZ





        LD      DE,#0101
        LD      HL,(COORDS)

        CALL    Ybounds

        ADD     A,MIDY
        SUB     H
        JP      P,$+7
        NEG 
        LD      D,#FF
        LD      B,A

        LD      A,C
        ADD     A,MIDX
        SUB     L
        JP      P,$+7
        NEG 
        LD      E,#FF
        LD      C,A


        CALL    LINE    ;BC=abs(YX)
                        ;DE=sgn(YX)

        LD      HL,NewFig
        LD      A,(HL)
        OR      A
        JP      NZ,MAINLOOP2
        LD      (HL),H

        LD      HL,BORDCR ;BORDCR will be finally copied to ATTR_T by CLS
        INC     (HL)
        BIT     3,(HL)
        RES     3,(HL)
        JR      NZ,$-5

        LD      HL,FigType
        BIT     1,(HL)
        JR      Z,$+4
        LD      (HL),#FF
        INC     (HL)

        JP      MAINLOOP



Ybounds ;Y must be bounded for DRAW not to fail
        LD      A,B
        OR      A
        JP      M,YcpNEG
        CP      MIDY
        RET     C
        LD      A,MIDY-1
        RET 

YcpNEG
        CP      0-MIDY
        RET     NC
        LD      A,0-MIDY
        RET 



GET_XYZ
        LD      A,(X0+1)
        LD      B,A ;scr Y coord
        LD      A,(Y0+1)
        LD      C,A ;scr X coord
        LD      A,(Z0+1)
        LD      D,A

FigType EQU     $+1
        LD      A,0
        DEC     A
        RET     M

        LD      E,B
        LD      B,D
        RET     Z

        LD      C,E
        RET 




Fcalc   ;calcs F(x,y,z):
        ;
        ;Fx = sigma(y-x)
        ;Fy = x*z-y
        ;Fz = ro*beta-x*y-beta*z
        ;
        ;where sigma=10,ro=28,beta=8/3
        ;
        ;uses 6.10 fixed point for xyz, F is stored
        ;as 12.20
        ;
        ;xyz taken from Xt,Yt,Zt
        ;F placed into Fx,Fy,Fz

Fsigma  EQU     #2800 ;10*1024
Fbeta   EQU     2731  ;8/3 * 1024
FrobeL  EQU     #AAAB
FrobeH  EQU     #04AA ;8/3*28 * 2^20

        ; Fx

        LD      HL,(Yt)
        LD      DE,(Xt)
        OR      A
        SBC     HL,DE
        LD      BC,Fsigma
        CALL    SMUL32

        LD      E,.Fx
        CALL    MUL2E



        ; Fy

        LD      HL,0
        LD      (Fy),HL
        LD      HL,(Yt)
        LD      (Fy+2),HL

        LD      L,.Fy+3
        LD      C,6
        CALL    SHRL


        LD      BC,(Xt)
        LD      HL,(Zt)
        CALL    SMUL32

        LD      L,.Fy
        LD      E,.MULLO
        CALL    RSUBEL


        ; Fz
        ;first x*y + beta*z

        LD      BC,(Xt)
        LD      HL,(Yt)
        CALL    SMUL32

        LD      E,.Fz
        CALL    MUL2E

        LD      HL,(Zt)
        LD      BC,Fbeta
        CALL    SMUL32

        LD      E,.MULLO
        LD      L,.Fz
        CALL    ADDEL

        ;then ro*beta - sum
        LD      L,.Fz
        LD      E,.RoBe




RSUBEL  ;(L)<=(E)-(L)
        LD      H,'REGS
        LD      D,H

        LD      B,4
        OR      A
RSUBEL_l
        LD      A,(DE)
        SBC     A,(HL)
        LD      (HL),A
        INC     E
        INC     L
        DJNZ    RSUBEL_l

        RET 




ADDEL2
        LD      B,2
        JR      ADDALL

ADDEL
        LD      B,4
ADDALL
        ;(L)<=(E)+(L)
        LD      H,'REGS
        LD      D,H

        OR      A
ADDEL_l
        LD      A,(DE)
        ADC     A,(HL)
        LD      (HL),A
        INC     E
        INC     L
        DJNZ    ADDEL_l

        RET 






SHRL    LD      H,'REGS

SHRL_l
        PUSH    HL

        LD      A,(HL)
        RLA 

        LD      B,4
        RR      (HL)
        DEC     L
        DJNZ    $-3

        POP     HL
        DEC     C
        JR      NZ,SHRL_l
        RET 


SHR2L2
        SRA     (HL)
        DEC     L
        RR      (HL)
        INC     L
SHR1L2
        SRA     (HL)
        DEC     L
        RR      (HL)
        RET 




MUL2E   LD      L,.MULLO


L2E     LD      H,'REGS
        LD      D,H
        LD      BC,4
        LDIR 
        RET 



SMUL32  ;signed multiplication
        ;BC*HL->MULHI,MULLO

        LD      A,B
        XOR     H
        PUSH    AF

        BIT     7,B
        JR      Z,$+9
        LD      A,B
        CPL 
        LD      B,A
        LD      A,C
        CPL 
        LD      C,A
        INC     BC

        XOR     A
        OUT     (#FE),A
        BIT     7,H
        EXD 
        JR      Z,$+7
        LD      H,A
        LD      L,A
        SBC     HL,DE
        EXD 


        ;BC,DE - ins
        XOR     A
        LD      H,A
        LD      L,A
        LD      A,17
UMUL32l
        JR      NC,$+3
        ADD     HL,DE
        RR      H
        RR      L
        RR      B
        RR      C
        DEC     A
        JR      NZ,UMUL32l

        ;HLBC - out

        LD      (MULLO),BC
        LD      (MULHI),HL
        POP     AF
        RET     P

        EXD 
        XOR     A
        LD      H,A
        LD      L,A
        SBC     HL,BC
        LD      (MULLO),HL
        LD      H,A
        LD      L,A
        SBC     HL,DE
        LD      (MULHI),HL
        RET 



INT_PROC
        PUSH    AF
        PUSH    HL
        PUSH    BC
        PUSH    DE





        LD      HL,MUS_PLAY
        DEC     (HL)
        JP      P,SAMPLE
        LD      (HL),2



        DEC     (IX+C0_CTR)
        JR      NZ,ENVELOPE


        ;here we play tone
        LD      HL,C0_BASE
        CALL    FETCH_NEXT
        CP      #FF
        CALL    Z,FETCH_NEW

        LD      B,A
        AND     #0F
        ADD     A,.N1K0_NOTES
        LD      L,A
;;;;;;;;LD      H,'N1K0_NOTES

        LD      A,(HL)
        LD      L,.ATONE
        RRCA 
        LD      (HL),A
        INC     HL
        SBC     A,A
        INC     A
        LD      (HL),A


        LD      A,B
        CALL    HI_NIBBLE
        OR      1
        LD      (AVOL),A

        INC     B
        DEC     B
        LD      A,#40
        JR      Z,LD_NOTE_CTR
        BIT     4,B
        LD      A,2
        JR      Z,LD_NOTE_CTR
        ADD     A,A
LD_NOTE_CTR
        LD      (IX+C0_CTR),A






ENVELOPE
        DEC     (IX+C2_CTR)
        JR      NZ,BASS


        LD      HL,C2_BASE
        CALL    FETCH_NEXT
        CP      #FF
        CALL    Z,FETCH_NEW

        LD      B,A

        RLCA 
        RLCA 
        AND     3
        INC     A
        LD      (IX+C2_CTR),A

        LD      A,B
        AND     #3F

        LD      L,.CVOL
        LD      (HL),#1F
        JR      NZ,$+3
        LD      (HL),A

        ADD     A,#26
        INC     HL
        LD      (HL),A



BASS
        DEC     (IX+C1_CTR)
        JR      NZ,SAMPLE


        LD      HL,C1_BASE
        CALL    FETCH_NEXT
        OR      A
        LD      (NewFig),A
        CALL    Z,FETCH_NEW

BASS_NOTE
        LD      B,A

        INC     A
        LD      A,#40
        JR      Z,ST_BASS_CTR

        LD      A,B
        AND     #0F
        LD      (BVOL),A

        LD      A,B
        CALL    HI_NIBBLE
        RRA 
        LD      L,.SMP0
        JR      NC,$+4
        LD      L,.SMP1
        LD      (SMPL),HL

        LD      L,.BTONE+1
        LD      (HL),'C4_FREQ

        ADD     A,A
ST_BASS_CTR
        LD      (IX+C1_CTR),A







SAMPLE
        ;play samples (only channel 1)
SMPL    EQU     $+1
        LD      HL,SMP_END


        LD      A,(HL)
        INC     HL
        LD      (MIXER),A

        LD      A,(HL)
        CALL    HI_NIBBLE
        RRA 
        LD      (NOISE),A

        LD      A,(HL)
        OR      A
        DEC     HL
        JR      Z,$+4
        INC     HL
        INC     HL
        LD      (SMPL),HL

        LD      L,.BTONE+1
        INC     (HL)

        LD      L,.BVOL
        ADD     A,(HL)
        AND     #0F
        LD      (HL),A







AY_OUT
        LD      L,.AYS
        LD      DE,#FFC0
        LD      C,#FD
        XOR     A
AY_LOOP
        LD      B,D
        OUT     (C),A
        LD      B,E
        OUTI 
        INC     A
CPREG   EQU     $+1
        CP      #0E
        JR      NZ,AY_LOOP
        LD      (IX-CPDISP),#0D ;out ENV TYPE only once


        RST     #38
        JP      #004D


COUNTS  DB      1,1,1

CPDISP  EQU     COUNTS-CPREG

C0_CTR  EQU     0
C1_CTR  EQU     1
C2_CTR  EQU     2




        ;universal pattern data fetcher


FETCH_NEW
        DEC     HL
        LD      D,(HL)
        DEC     HL
        LD      E,(HL) ;get pointer to pattern list

        EXD 
        LD      C,(HL)
        INC     HL
;;;;;;;;LD      B,(HL) ;fetch next pattern address
       LD      B,H
;;;;;;;;INC     HL

;;;;;;;;LD      A,B  ;see if we need to loop patterns
;;;;;;;;OR      C
       INC     C
       DEC     C
        JR      NZ,FETCH_CONT

        LD      C,(HL) ;we need to loop - fetch next word (loop pointer)
;;;;;;;;INC     HL
;;;;;;;;LD      B,(HL)
       LD      B,H
        EXD 
        LD      (HL),C ;store new position in pattern list
        INC     HL
        LD      (HL),B
        INC     HL
        JR      FETCH_NEW

FETCH_CONT
        EXD             ;no loop - store back updated pattern list pointer
        LD      (HL),E
        INC     HL
        LD      (HL),D
        INC     HL
        LD      (HL),C ;store address of new pattern data
        INC     HL
        LD      (HL),B
        DEC     HL

FETCH_NEXT
        LD      E,(HL) ;get note pointer
        INC     HL
        LD      D,(HL)

        LD      A,(DE) ;get note
        INC     DE

        LD      (HL),D ;store back updated pointer
        DEC     HL
        LD      (HL),E
        RET 

HI_NIBBLE
        RRA 
        RRA 
        RRA 
        RRA 
        AND     #0F
        RET 




        DISPLAY "====================="

        DISPLAY /H,"N1KO_NOTES = ",$

N1K0_NOTES      ;only 6 used notes -- RLCed 1 bit
        DB      #72;#39 add    #100
        DB      #0E;#07    here
        DB      #D7;#EB
        DB      #A3;#D1
        DB      #61;#B0
        DB      #3B;#9D



;samples; first byte is mixer value
        ; second: %nnnx vvvv
        ;         nnn - noise freq (0-7),
        ;         vvvv - add to volume,
        ;         0 - end sample

SMP0    DB      #2C,#F0
        DB      #3C,#10
        DB      #3C,#10
        DB      #3C,#1D
SMP_END DB      #3E,0

SMP1    DB      #2E,#0E
        DB      #2E,#10
        DB      #3E,0

AYS ; initial AY registers setup
ATONE   DW      0
BTONE   DW      .C4_FREQ
CTONE   DW      0
NOISE   DB      0
MIXER   DB      0
AVOL    DB      0
BVOL    DB      0
CVOL    DB      0
ENVFRQ  DW      0
ENVTYPE DB      #0E





C0_BEGIN
        DW      C0_PATS
C0_BASE
        DW      PNO_TONE


C0_PATS
        DB     .PNO_TONE
        DB     .PNO_TONE
        DB     .PNO_TONE
C0_LOOP
        DB     .P0_TONE
        DB     .P0_TONE
        DB     .P1_TONE
        DB     .P0_TONE
        DB     .P0_TONE
        DB     .P1_TONE
        DB     .P0_TONE
        DB     .PNO_TONE
        DB     .PNO_TONE
        DB      0
        DB     .C0_LOOP

P0_TONE
        ; note format: vvvp_0nnn, vvv - volume (high 3 bits)
        ;              p - pause (0-2,1-4), nnn - note (0-5)
        DB      %11110101
        DB      %01100101
        DB      %11100101
        DB      %00000101
        DB      %01110101
        DB      %00100101
        DB      %01100101
        DB      %00000101
        DB      %00110101
        DB      %00000101
        DB      %11100101
        DB      %01100101
        DB      %11100101
        DB      %11110100
        DB      %01100101
        DB      %11100100
        DB      %01100100
        DB      %11100100
        DB      %11110011
        DB      %01100100
        DB      %11100011
        DB      %01100011
        DB      %11100011
        DB      %11100010
        DB      %11100001
        DB      %11110000
        DB      #FF
P1_TONE
        DB      %11110010
        DB      %01100010
        DB      %11100010
        DB      %00000010
        DB      %01100010
        DB      %11110011
        DB      %01100010
        DB      %11100011
        DB      %00000011
        DB      %01100011
        DB      %11100100
        DB      %11100101
        DB      %00000101
        DB      %01100101
        DB      %11110010
        DB      %01100010
        DB      %11100010
        DB      %00000010
        DB      %11100011
        DB      %11110100
        DB      %11100101
        DB      %01100100
        DB      %11100000
        DB      %11100100
        DB      %01100000
        DB      %11110010
        DB      %01100010
        DB      #FF
PNO_TONE
        DB      0
        DB      #FF

        DISPLAY /H,"C0_BEGIN=",C0_BEGIN
        DISPLAY /H,"C0_PATS =",C0_PATS
        DISPLAY /H,"P0_TONE =",P0_TONE
        DISPLAY /H,"P1_TONE =",P1_TONE
        DISPLAY /H,"PNO_TONE=",PNO_TONE
        DISPLAY "====================="



C2_BEGIN
        DW      C2_PATS
C2_BASE
        DW      PNO_ENV



C2_PATS
        DB     .PNO_ENV
        DB     .P0_ENV
        DB     .P0_ENV
C2_LOOP
        DB     .P0_ENV
        DB     .P0_ENV
        DB     .P1_ENV
        DB     .P0_ENV
        DB     .P0_ENV
        DB     .P1_ENV
        DB     .P0_ENV
        DB     .P0_ENV
        DB     .P0_ENV
        DB      0
        DB     .C2_LOOP


P0_ENV
        ; hi bits: pause %11 - 4, %10 - 3, %01 - 2, %00 - 1
        ; low 6 bits - env freq minus #26 or 0 if silence
        ; #FF - end of pattern
        DB      #C0,#68,#40,#C6
        DB      #40,#41,#C0,#C6
        DB      #40,#4E,#55,#1C
        DB      #00,#F2,#68,#40
        DB      #C6,#40,#41,#40
        DB      #46,#40,#46,#4E
        DB      #40,#E0,#FF

PNO_ENV
        DB      #C0,#C0,#C0,#C0
        DB      #C0,#C0,#C0,#C0
        DB      #C0,#C0,#C0,#C0
        DB      #C0,#C0,#C0,#C0
        DB      #FF

P1_ENV
        DB      #C0,#68,#40,#D5
        DB      #40,#55,#C0,#CE
        DB      #40,#4E,#40,#4E
        DB      #55,#5C,#68,#40
        DB      #D5,#40,#55,#40
        DB      #4E,#40,#46,#4E
        DB      #40,#46,#41,#FF

        DISPLAY /H,"C2_BEGIN=",C2_BEGIN
        DISPLAY /H,"C2_PATS =",C2_PATS
        DISPLAY /H,"P0_ENV  =",P0_ENV
        DISPLAY /H,"P1_ENV  =",P1_ENV
        DISPLAY /H,"PNO_ENV =",PNO_ENV
        DISPLAY "====================="







C1_BEGIN
        DW      C1_PATS
C1_BASE
        DW      P0_BASS


C1_PATS
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .P0_BASS
C1_LOOP
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .P0_BASS
        DB     .PNO_BASS
        DB      0
        DB     .C1_LOOP



PNO_BASS
        DB      #FF
        DB      0

P0_BASS ;%aaab vvvv: aaa*2 - pause, b - sample, vvvv - volume
        ;#00 - end pattern
        ;#FF - no sample, set #40 to counter
        DB      #2F
        DB      #5F
        DB      #3F
        DB      #2F
        DB      #36
        DB      #5F
        DB      #4F
        DB      #5F
        DB      #2F
        DB      #7F
        DB      #2F
        DB      #5F
        DB      #3F
        DB      #2F
        DB      #35
        DB      #5F
        DB      #2F
        DB      #36
        DB      #3D
        DB      #3F
        DB      #2F
        DB      #36
        DB      #5F
        DB      #00

        DISPLAY /H,"C1_BEGIN=",C1_BEGIN
        DISPLAY /H,"C1_PATS =",C1_PATS
        DISPLAY /H,"P0_BASS =",P0_BASS
        DISPLAY /H,"PNO_BASS=",PNO_BASS
        DISPLAY "====================="















PRINT_ME
        DB      "lorenz1k   lvd n1k-o"
PRINT_END










;;;;;;;;ORG     $+255&#FF00


REGS    DISPLAY /H,"REGS=",REGS

X0      DW      1024
Y0      DW      1024
Z0      DW      -2048

RoBe    DW      FrobeL
        DW      FrobeH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
END ;of code

        DISPLAY /A,"size: ",END-START

MULLO   DW      0
MULHI   DW      0

Xt      DW      0
Yt      DW      0
Zt      DW      0

Fx      DS      4
Fy      DS      4
Fz      DS      4






        ORG     START
