display.setStatusBar( display.HiddenStatusBar )
local physics = require("physics")
local socket = require("socket")
local host, port = "192.168.10.1", 9909
	
local udp = assert(socket.udp())

physics.start()
physics.setDrawMode("hybrid")
system.activate( "multitouch" )

for i = 1, 4 do
	for j = 0, 8 do
		if i == 1 then
			local block = display.newRect(0,j*85, 5,85)
			block.mid = j
			physics.addBody(block, "static")
		end
		if i == 2 then
			local block = display.newRect(j*113,0,113,5)
			block.mid = 9+j
			physics.addBody(block, "static")
		end
		if i == 3 then
			local block = display.newRect(1019,j*85, 5,85)
			block.mid = 18+j
			physics.addBody(block, "static")
		end
		if i == 4 then
			local block = display.newRect(j*113,763, 113, 5)
			block.mid = 27+j
			physics.addBody(block, "static")
		end
	end
end

physics.setGravity(0,9.8)
local sendUdpRgb = function(id,r,g,b)
	local packet = string.char(1,0)
	packet = packet .. "karalaine"
	packet = packet .. string.char(0)
	packet = packet .. string.char(1,id,0,r,g,b)
	assert(udp:sendto(packet, host, port))
end
local onBallCollision = function(self, event)
	if event.other.mid ~= nil then
		event.other:setFillColor(self.r, self.g, self.b)	
		--sendUdpRgb(event.other.mid, self.r, self.g, self.b)
	end
end

local function ballTouch(event)
	local t = event.target
    local phase = event.phase
    if "began" == phase then
    	display.getCurrentStage():setFocus( t )
      t.isFocus = true
     t.x0 = event.x - t.x
    t.y0 = event.y - t.y
   --[[ t.bodyType = "kinematic"
		-- Stop current motion, if any
		t:setLinearVelocity( 0, 0 )
		t.angularVelocity = 0 --]]
    elseif t.isFocus then
      if "moved" == phase then
        t.x = event.x - t.x0
        t.y = event.y - t.y0
		elseif "ended" == phase  or "cancelled" == phase then
	 		display.getCurrentStage():setFocus( nil )
        	t.isFocus = false
        --	t.bodyType = "dynamic"
		end
	end
end
for i = 0, 38 do
	local ball = display.newCircle(i*31,100,30)
	ball.r = math.random(0,255)	
	ball.g = math.random(0,255)
	ball.b = math.random(0,255)
	ball:setFillColor(ball.r, ball.g, ball.b)
	physics.addBody(ball, "dynamic", {radius=30})
	ball.collision = onBallCollision
	ball:addEventListener( "collision", ball )   
	ball:addEventListener("touch", ballTouch)
end

local iter = 1
local function rotatelights()
	local packet = string.char(1,0)
	packet = packet .. "karalaine"
	packet = packet .. string.char(0)
	packet = packet .. string.char(1,iter-1,0,0,0,0)
	packet = packet .. string.char(1,iter,0,32,98,89)
	assert(udp:sendto(packet, host, port))
	iter = iter + 1
--for i = 0, 38 do
--packet = packet .. string.char(1,i,0,255,0,0)
--ende
	
end
--timer.performWithDelay(33,rotatelights, 39)
local function onTilt(event)
	physics.setGravity(-10 * event.yGravity, -10 * event.xGravity)
end
Runtime:addEventListener("accelerometer", onTilt)	