/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.procs;

import com.threed.jpct.FrameBuffer;
import com.threed.jpct.IPostProcessor;
import com.threed.jpct.Logger;
import com.threed.jpct.procs.ProcsHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class BloomGLProcessor
implements IPostProcessor {
    private int screenTexture = 0;
    private int blurTexture = 0;
    private int w = 0;
    private int h = 0;
    private int wq = 0;
    private int hq = 0;
    private int steps = 4;
    private int blurSteps = 4;
    private int strength = 2;
    private int quality = 1;
    private boolean hasGL = false;
    private boolean disposed = false;
    private boolean isInitialized = false;
    private boolean message = false;
    private boolean comb = true;

    public BloomGLProcessor() {
    }

    public BloomGLProcessor(int n, int n2, int n3, int n4) {
        this.steps = Math.max(0, n);
        this.blurSteps = Math.max(0, n2);
        this.strength = Math.max(0, n3);
        this.quality = Math.max(0, n4);
    }

    public void init(FrameBuffer frameBuffer) {
        if (!this.isInitialized) {
            try {
                boolean bl = this.hasGL = frameBuffer.usesRenderer(2) && (this.supports("EXT_texture_rectangle") || this.supports("NV_texture_rectangle"));
                if (this.hasGL) {
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
                    GL11.glGetInteger(34040, intBuffer);
                    int n = intBuffer.get(0);
                    intBuffer = null;
                    this.disposed = false;
                    this.w = frameBuffer.getOutputWidth();
                    this.h = frameBuffer.getOutputHeight();
                    if (this.w <= n && this.h <= n) {
                        this.wq = this.w >> this.quality;
                        this.hq = this.h >> this.quality;
                        int n2 = this.w * this.h;
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 << 2);
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        IntBuffer intBuffer2 = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
                        GL11.glGenTextures(intBuffer2);
                        this.screenTexture = intBuffer2.get(0);
                        GL11.glBindTexture(34037, this.screenTexture);
                        GL11.glTexParameteri(34037, 10241, 9729);
                        GL11.glTexParameteri(34037, 10240, 9729);
                        GL11.glTexImage2D(34037, 0, 32849, this.w, this.h, 0, 6407, 5121, byteBuffer);
                        GL11.glGenTextures(intBuffer2);
                        this.blurTexture = intBuffer2.get(0);
                        GL11.glBindTexture(34037, this.blurTexture);
                        GL11.glTexParameteri(34037, 10241, 9729);
                        GL11.glTexParameteri(34037, 10240, 9729);
                        GL11.glTexImage2D(34037, 0, 32849, this.wq, this.hq, 0, 6407, 5121, byteBuffer);
                        Logger.log("Post processing textures created!", 2);
                        this.isInitialized = true;
                    } else {
                        Logger.log("Framebuffer dimensions exceed maximum resolution for arbitrary textures (" + n + ")", 1);
                    }
                } else if (!this.message) {
                    if (frameBuffer.usesRenderer(2)) {
                        Logger.log("This graphics card doesn't support arbitrary textures!", 1);
                    } else {
                        Logger.log("There's no bloom processor for the software renderer available!", 1);
                    }
                    this.message = true;
                }
            }
            catch (Exception exception) {
                Logger.log("Unable to initialize post processing textures due to: " + exception.getMessage(), 1);
                exception.printStackTrace();
            }
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setCombining(boolean bl) {
        this.comb = bl;
    }

    public void process() {
        if (this.hasGL) {
            int n;
            GL11.glEnable(34037);
            GL11.glColor3f(1.0f, 1.0f, 1.0f);
            GL11.glDisable(2929);
            GL11.glBindTexture(34037, this.screenTexture);
            GL11.glCopyTexImage2D(34037, 0, 6407, 0, 0, this.w, this.h, 0);
            ProcsHelper.toOrtho();
            GL11.glViewport(0, 0, this.wq, this.hq);
            GL11.glBindTexture(34037, this.screenTexture);
            GL11.glBlendFunc(774, 0);
            GL11.glDisable(3042);
            GL11.glBegin(7);
            this.drawQuad(this.w, this.h, 0, 0);
            GL11.glEnd();
            GL11.glEnable(3042);
            GL11.glBegin(7);
            for (int i = 0; i < this.steps; ++i) {
                this.drawQuad(this.w, this.h, 0, 0);
            }
            GL11.glEnd();
            GL11.glBindTexture(34037, this.blurTexture);
            GL11.glCopyTexImage2D(34037, 0, 6407, 0, 0, this.wq, this.hq, 0);
            float f = 1.0f / ((float)this.blurSteps * 2.0f + 1.0f);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, f);
            GL11.glBlendFunc(770, 0);
            GL11.glBegin(7);
            this.drawQuad(this.wq, this.hq, 0, 0);
            GL11.glEnd();
            GL11.glBlendFunc(770, 1);
            GL11.glBegin(7);
            for (n = 0; n < this.blurSteps; ++n) {
                this.drawQuad(this.wq, this.hq, -n, 0);
                this.drawQuad(this.wq, this.hq, n, 0);
            }
            GL11.glEnd();
            GL11.glCopyTexImage2D(34037, 0, 6407, 0, 0, this.wq, this.hq, 0);
            GL11.glBlendFunc(770, 0);
            GL11.glBegin(7);
            this.drawQuad(this.wq, this.hq, 0, 0);
            GL11.glEnd();
            GL11.glBlendFunc(770, 1);
            GL11.glBegin(7);
            for (n = 0; n < this.blurSteps; ++n) {
                this.drawQuad(this.wq, this.hq, 0, -n);
                this.drawQuad(this.wq, this.hq, 0, n);
            }
            GL11.glEnd();
            GL11.glCopyTexImage2D(34037, 0, 6407, 0, 0, this.wq, this.hq, 0);
            GL11.glViewport(0, 0, this.w, this.h);
            GL11.glDisable(3042);
            GL11.glBegin(7);
            this.drawQuad(this.wq, this.hq, 0, 0);
            GL11.glEnd();
            GL11.glEnable(3042);
            GL11.glBlendFunc(1, 1);
            GL11.glBegin(7);
            for (n = 0; n < this.strength; ++n) {
                this.drawQuad(this.wq, this.hq, 0, 0);
            }
            GL11.glEnd();
            if (this.comb) {
                GL11.glBindTexture(34037, this.screenTexture);
                GL11.glBegin(7);
                this.drawQuad(this.w, this.h, 0, 0);
                GL11.glEnd();
            }
            ProcsHelper.restoreProjection();
            GL11.glDisable(34037);
            GL11.glEnable(2929);
            GL11.glDisable(3042);
        }
    }

    private boolean supports(String string) {
        String string2 = GL11.glGetString(7939);
        return string2.toLowerCase().indexOf(string.toLowerCase()) != -1;
    }

    private void drawQuad(int n, int n2, int n3, int n4) {
        GL11.glTexCoord2f(n3, n4);
        GL11.glVertex3f(0.0f, 1.0f, -1.0f);
        GL11.glTexCoord2f(n3, n2 + n4);
        GL11.glVertex3f(0.0f, 0.0f, -1.0f);
        GL11.glTexCoord2f(n + n3, n2 + n4);
        GL11.glVertex3f(1.0f, 0.0f, -1.0f);
        GL11.glTexCoord2f(n + n3, n4);
        GL11.glVertex3f(1.0f, 1.0f, -1.0f);
    }

    public void dispose() {
        if (!this.disposed && this.isInitialized) {
            try {
                if (Display.isCreated()) {
                    Logger.log("Unloading post processing textures!", 2);
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
                    intBuffer.put(this.screenTexture);
                    ((Buffer)intBuffer).flip();
                    GL11.glDeleteTextures(intBuffer);
                    intBuffer.put(this.blurTexture);
                    ((Buffer)intBuffer).flip();
                    GL11.glDeleteTextures(intBuffer);
                }
            }
            catch (Exception exception) {
                Logger.log("Unable to unload post processing textures - already done?", 1);
            }
            this.isInitialized = false;
            this.message = false;
            this.disposed = true;
        }
    }

    protected void finalize() {
        if (this.hasGL) {
            this.dispose();
        }
    }
}

