//RageMegaSuper 2012 Prototype Demo
//for Instanssi 2012
//by Rage Manifesto

#include<gl/freeglut.h>
#include <IL/il.h>
#include <IL/ilu.h>
#include <IL/ilut.h>
#include<fmod.hpp>
#include<iostream>
#include<string>
#include<Windows.h>
#include<Mmsystem.h>
#include<stdlib.h>
#include <iostream>
#include <fstream> 

using namespace std;

int WINDOW_WIDTH = 1280;
int WINDOW_HEIGHT = 720;
int WINDOW_WIDTH_HALVED = 640;
int WINDOW_HEIGHT_HALVED = 360;

//The skip must not be made backwards!
const int SKIPPOSITION_MS = 89777;

//some useful stuff
static const float PI = 3.141592654f;
static const float PI_TIMES_TWO = 6.28318531f;
static const float FPS = 60.0f; //The target FPS
static const float FRAME_LENGTH = 1/FPS;
unsigned long FRAME_NO = 0;

//Some material and lightning settings
GLfloat RED[] = {1.0f, 0.0f, 0.0f, 1.0f}; 
GLfloat YELLOW[] = {1.0f, 1.0f, 0.0f, 1.0f};
GLfloat WHITE[] = {1.0f, 1.0f, 1.0f, 1.0f};
GLfloat OBJ_POS[] = {0.0f, 0.0f, 0.0f};
GLfloat OBJ_ROT[] = {0.0f, 0.0f, 0.0f, 0.0f};
GLfloat OBJ_ROT2[] = {120.0f, 35.0f, 5.0f, 200.0f};
GLfloat OBJ_ROT3[] = {68.0f, 23.0f, 100.0f, 330.0f};
GLfloat OBJ_ROT4[] = {35.0f, 95.0f, 3.0f, 158.0f};
GLfloat ROT_CHG = 0.7f;

//Texture handles
GLuint TitleTexture[100];

//For sound system
FMOD_RESULT fmodResult;
FMOD::System *fmodSystem;
FMOD::Sound *fmodSound;
FMOD::Channel *fmodChannel;

//for windows API timer
LARGE_INTEGER timerFreq_;
LARGE_INTEGER counterAtStart_;

//For syncing and timing
static int lastDemoPos = 0;
static int previousDemoPos = 0;
static float cumulativeTime = 0.0f;
static const float FRAME_LENGTH_MS = 1000.0f / FPS;
static const unsigned int SYNC_TOLERANCE_MS = 10;
static int deltaTime = 0;
static float dtModifier = 0.0f;
unsigned int syncCorrectionCount = 0;
//For audio engine
unsigned int lastAudioPos = 0;
unsigned int * ref_lastAudioPos = &lastAudioPos;

static const unsigned int MAX_UPDATEITERATIONS = 10;

bool introIsSkipped = false;
unsigned int skipAmount = 0;

//function prototypes
void close(int);
void display();
void drawTeapot();
void drawTextPlane(GLuint);
void idle();
void keyPressed(unsigned char, int, int);
void setRedMaterial();
void setWhiteLighting();
unsigned int timer_calculateElapsedTime();
void timer_start();
void update();
int myAbs(int);
void loadTextures();
void drawTexPlaneSequence();

void orthogonalStart();
void orthogonalEnd();

//==============================AND SO IT BEGINS...=======================================

void close(int errorLevel){

	fmodSystem->release();
	glutLeaveGameMode();

	exit(errorLevel);
}


int myAbs(int value){
	if (value >= 0) return value;
	else return value * (-1);
}


void timer_start(){
    QueryPerformanceFrequency(&timerFreq_);
    QueryPerformanceCounter(&counterAtStart_);
    cout<<"timerFreq_ = "<<timerFreq_.QuadPart<<endl;
    cout<<"counterAtStart_ = "<<counterAtStart_.QuadPart<<endl;
    TIMECAPS ptc;
    UINT cbtc = 8;
    MMRESULT result = timeGetDevCaps(&ptc, cbtc);
    if (result == TIMERR_NOERROR){
        cout<<"Minimum resolution = "<<ptc.wPeriodMin<<endl;
        cout<<"Maximum resolution = "<<ptc.wPeriodMax<<endl;
    }else{
        cout<<"result = TIMER ERROR"<<endl;
    }
}

unsigned int timer_calculateElapsedTime(){
    if (timerFreq_.QuadPart == 0){
        return -1;
    }else{
        LARGE_INTEGER c;
        QueryPerformanceCounter(&c);
        return static_cast<unsigned int>( (c.QuadPart - counterAtStart_.QuadPart) * 1000 / timerFreq_.QuadPart );
    }
}

void update(){
	deltaTime = lastDemoPos - previousDemoPos;
        cumulativeTime += deltaTime * 0.001f;
        previousDemoPos = lastDemoPos;
		int updateIterations = 0;
        while (cumulativeTime > FRAME_LENGTH ) {

			for(int i=0;i<4;i++){OBJ_ROT[i] += ROT_CHG;}
			for(int i=0;i<4;i++){OBJ_ROT2[i] += ROT_CHG;}
			for(int i=0;i<4;i++){OBJ_ROT3[i] += ROT_CHG;}
			for(int i=0;i<4;i++){OBJ_ROT4[i] += ROT_CHG;}
			//generalModifier_01 += generalSpeed_01;
			//generalModifier_02 += generalSpeed_02;
			//generalModifier_03 += generalSpeed_03;
			//sinInput += 0.01f;

			//if (backgroundColorBlink_isActive)
			//{
			//    backgroundColor[0] -= backgroundColorSpeed_r;
			//    backgroundColor[1] -= backgroundColorSpeed_g;
			//    backgroundColor[2] -= backgroundColorSpeed_b;
			//}

			
            //object.position += objectspeed;
            cumulativeTime -= FRAME_LENGTH ;
			updateIterations++;
			if (updateIterations > MAX_UPDATEITERATIONS) break;

        }

		//sinOutput = sin(sinInput);
		//if ( generalModifier_01 > 360.0f ) generalModifier_01 -= 360.0f;
        //if ( generalModifier_02 > 360.0f ) generalModifier_02 -= 360.0f;
        //if ( generalModifier_03 < -360.0f ) generalModifier_03 += 360.0f;


		//timeSinceLastBeat = lastDemoPos - lastBeatTime;

		//if (timeSinceLastBeat > MUSICBEATTIME_MS){
			
			//if (backgroundColorBlink_isActive)
			//{
			//    backgroundColor[0] = giveRandomFloat(0.3f, 1.0f);
			//    backgroundColor[1] = giveRandomFloat(0.3f, 1.0f);
			//    backgroundColor[2] = giveRandomFloat(0.3f, 1.0f);

			//    backgroundColorSpeed_r = giveRandomFloat(0.001f, 0.2f);
			//    backgroundColorSpeed_g = giveRandomFloat(0.001f, 0.2f);
			//    backgroundColorSpeed_b = giveRandomFloat(0.001f, 0.2f);
			//}

			//if (backgroundCubeBlink_isActive)
			//{
			//    pCubescene01->updatePositions();
			//}


			//backgroundColor[3] += 0.5f;
			//lastBeatTime = lastDemoPos;
			//cout << "background flash stuff at time " << lastDemoPos << endl;
}

void drawOrthoTexPlane(GLuint Texture){

	//glMatrixMode (GL_PROJECTION);
    //glLoadIdentity ();
	//gluOrtho2D (0, WINDOW_WIDTH, 0, WINDOW_HEIGHT);
	//glMatrixMode (GL_MODELVIEW);
    //glLoadIdentity ();
	//glTranslatef (0.375, 0.375, 0.);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, Texture);
	glBegin(GL_QUADS);
	glColor3f(5.0f, 5.0f, 1.0f);
    glTexCoord2i(0, 0); glVertex2i(-WINDOW_WIDTH_HALVED,   -WINDOW_HEIGHT_HALVED);
    glTexCoord2i(0, 1); glVertex2i(-WINDOW_WIDTH_HALVED,   WINDOW_HEIGHT_HALVED);
    glTexCoord2i(1, 1); glVertex2i(WINDOW_WIDTH_HALVED, WINDOW_HEIGHT_HALVED);
    glTexCoord2i(1, 0); glVertex2i(WINDOW_WIDTH_HALVED, -WINDOW_HEIGHT_HALVED);
    glEnd();

	//glMatrixMode (GL_PROJECTION);
	//glPopMatrix();
	//glMatrixMode (GL_MODELVIEW);
	//glPopMatrix();
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
}

void drawOrthoSubtitlePlane(GLuint Texture){

	//glMatrixMode (GL_PROJECTION);
    //glLoadIdentity ();
	//gluOrtho2D (0, WINDOW_WIDTH, 0, WINDOW_HEIGHT);
	//glMatrixMode (GL_MODELVIEW);
    //glLoadIdentity ();
	//glTranslatef (0.375, 0.375, 0.);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, Texture);
	glBegin(GL_QUADS);
	glColor3f(5.0f, 5.0f, 1.0f);
	
	//TODO: vs t paska kuntoon
	glTexCoord2i(0, 0); glVertex2i(-WINDOW_WIDTH_HALVED+(WINDOW_WIDTH_HALVED/6), -WINDOW_HEIGHT_HALVED+((WINDOW_WIDTH_HALVED/10)));
    glTexCoord2i(0, 1); glVertex2i(-WINDOW_WIDTH_HALVED+(WINDOW_WIDTH_HALVED/6), -WINDOW_HEIGHT_HALVED+(WINDOW_WIDTH_HALVED/6));
    glTexCoord2i(1, 1); glVertex2i(WINDOW_WIDTH_HALVED-(WINDOW_WIDTH_HALVED/6),  -WINDOW_HEIGHT_HALVED+(WINDOW_WIDTH_HALVED/6));
    glTexCoord2i(1, 0); glVertex2i(WINDOW_WIDTH_HALVED-(WINDOW_WIDTH_HALVED/6),  -WINDOW_HEIGHT_HALVED+(WINDOW_WIDTH_HALVED/10));
	glEnd();

	//glMatrixMode (GL_PROJECTION);
	//glPopMatrix();
	//glMatrixMode (GL_MODELVIEW);
	//glPopMatrix();
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
}


void idle(){
	update();
	glutPostRedisplay();
	//printf("postredisp");
}

void orthogonalStart () {

glViewport(0,0,WINDOW_WIDTH, WINDOW_HEIGHT);
glMatrixMode(GL_PROJECTION);
glLoadIdentity();
//glOrtho(0,1280,0,720,-100,100);
glOrtho(-WINDOW_WIDTH_HALVED, WINDOW_WIDTH_HALVED, -WINDOW_HEIGHT_HALVED, WINDOW_HEIGHT_HALVED, -200.0f, 200.0f);
glMatrixMode(GL_MODELVIEW);

 }

void orthogonalEnd () {
 //Switch back to our projection mode
glMatrixMode(GL_PROJECTION);
 //Finish our calls above
glPopMatrix();
 //Switch back to our model matrix to continue with out 3D scene
glMatrixMode(GL_MODELVIEW);
 }

void setWhiteLighting(){

	//Asetetaan valon diffuse-komponentti
    glLightfv(GL_LIGHT0, GL_DIFFUSE, WHITE); 
    //Asetetaan valon specular-komponentti
    glLightfv(GL_LIGHT0, GL_SPECULAR, WHITE); 
}


void setRedMaterial(){

	//Asetetaan materiaalin diffuse
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, RED); 
    //Asetetaan materiaalin specular
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, WHITE); 
    //Asetetaan materiaalin kiiltvyys
    glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 100.0f);
    //Siirretn piirtoa 5 yksikk poispin "kamerasta"
}

void setYellowMaterial(){
		//Asetetaan materiaalin diffuse
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, YELLOW); 
    //Asetetaan materiaalin specular
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, WHITE); 
    //Asetetaan materiaalin kiiltvyys
    glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 100.0f);
    //Siirretn piirtoa 5 yksikk poispin "kamerasta"

}


void drawRotatingTexPlane(GLuint Texture){

	glPushMatrix(); 
	glRotatef(OBJ_ROT[1]*10, OBJ_ROT[1]*10, OBJ_ROT[1]*10, OBJ_ROT[3]*10); 
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, Texture);
	glBegin(GL_QUADS);
	glColor3f(5.0f, 5.0f, 1.0f);
    glTexCoord2i(0, 0); glVertex2i(-WINDOW_WIDTH_HALVED,   -WINDOW_HEIGHT_HALVED);
    glTexCoord2i(0, 1); glVertex2i(-WINDOW_WIDTH_HALVED,   WINDOW_HEIGHT_HALVED);
    glTexCoord2i(1, 1); glVertex2i(WINDOW_WIDTH_HALVED, WINDOW_HEIGHT_HALVED);
    glTexCoord2i(1, 0); glVertex2i(WINDOW_WIDTH_HALVED, -WINDOW_HEIGHT_HALVED);
    glEnd();
	glPopMatrix(); 
}

void drawCubeWall(){
	int i, j;
	float k, l;

	for(i=0; i<9; i++)
	{
		l = i*30;
		glPushMatrix(); 
		glTranslatef(0.0f, (-WINDOW_HEIGHT_HALVED+i*WINDOW_HEIGHT/8), 0.0f);

	    for(j=0; j<16; j++)
		{
		    k = j*30;
	        glPushMatrix(); 
            glTranslatef(-WINDOW_WIDTH_HALVED+j*WINDOW_WIDTH/15, 0.0f, 0.0f); 
            glRotatef(OBJ_ROT[0]+k+l, OBJ_ROT[1]+k+l, OBJ_ROT[2]+k+l, OBJ_ROT[3]+k+l); 
            glutSolidCube(WINDOW_WIDTH/15); 
            glPopMatrix(); 
        }
		glPopMatrix(); 
	}
}

void drawTeapot(){

	glPushMatrix(); 
    glTranslatef(OBJ_POS[0], OBJ_POS[1], OBJ_POS[2]); 
    glRotatef(OBJ_ROT[0], OBJ_ROT[1], OBJ_ROT[2], OBJ_ROT[3]); 
    glutSolidTeapot(1.0f); 
    glPopMatrix(); 
}

void drawOrthoCornerShapes(){

	//lower left shape
	glPushMatrix(); 
    glTranslatef(-(WINDOW_WIDTH_HALVED-(WINDOW_WIDTH_HALVED/8)), -(WINDOW_HEIGHT_HALVED-(WINDOW_WIDTH_HALVED/8)), 0.0f); 
    glRotatef(OBJ_ROT[0], OBJ_ROT[1], OBJ_ROT[2], OBJ_ROT[3]); 
    glutSolidCube(WINDOW_WIDTH/15); 
    glPopMatrix(); 

	//upper left shape
	glPushMatrix(); 
    glTranslatef(-(WINDOW_WIDTH_HALVED-(WINDOW_WIDTH_HALVED/8)), WINDOW_HEIGHT_HALVED-(WINDOW_WIDTH_HALVED/8), 0.0f); 
    glRotatef(OBJ_ROT2[0], OBJ_ROT2[1], OBJ_ROT2[2], OBJ_ROT2[3]); 
    glutSolidCube(WINDOW_WIDTH/15); 
    glPopMatrix(); 

	//upper right shape
	glPushMatrix(); 
    glTranslatef(WINDOW_WIDTH_HALVED-(WINDOW_WIDTH_HALVED/8), WINDOW_HEIGHT_HALVED-(WINDOW_WIDTH_HALVED/8), 0.0f); 
    glRotatef(OBJ_ROT3[0], OBJ_ROT3[1], OBJ_ROT3[2], OBJ_ROT3[3]); 
    glutSolidCube(WINDOW_WIDTH/15); 
    glPopMatrix(); 

	//lower right shape
	glPushMatrix(); 
    glTranslatef(WINDOW_WIDTH_HALVED-(WINDOW_WIDTH_HALVED/8), -(WINDOW_HEIGHT_HALVED-(WINDOW_WIDTH_HALVED/8)), 0.0f); 
    glRotatef(OBJ_ROT4[0], OBJ_ROT4[1], OBJ_ROT4[2], OBJ_ROT4[3]); 
    glutSolidCube(WINDOW_WIDTH/15); 
    glPopMatrix(); 
}


void display(){

	glClearColor(0.0f, 0.0f, 0.3f, 0.0f);
		//=========================== POLL DEMO TIMER TIME & AUDIO POSITIONS ============================

	lastDemoPos = timer_calculateElapsedTime();
    fmodResult = fmodChannel->getPosition(&lastAudioPos, FMOD_TIMEUNIT_MS);
	if (fmodResult != FMOD_OK)
	{
		cout << "Error at polling song position" << endl;
		close(1);
	}

	if(introIsSkipped)
	{
		lastDemoPos += skipAmount;
	}

	//======================================== AV SYNC ==============================================
	
	if (myAbs(lastDemoPos - lastAudioPos) > (FRAME_LENGTH_MS + SYNC_TOLERANCE_MS)) 
	{
        lastDemoPos = lastAudioPos;
		syncCorrectionCount++;
		printf("sync correction n:o %d at frame %d\n", syncCorrectionCount, FRAME_NO);
    }

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ); 
    glLoadIdentity(); 

	//siirretn maailmaa 5 pykl pois kamerasta
    glTranslatef(0.0f, 0.0f, -5.0f); 
    
	setWhiteLighting();
	setYellowMaterial();


	//=================THE DEMO SEQUENCE==============================
	orthogonalStart();
	drawTexPlaneSequence();

	if (lastDemoPos < 2000)
	{
		
		drawOrthoTexPlane(TitleTexture[0]);
		//orthogonalEnd();
	}
	if (lastDemoPos < 8000)
	{
		//orthogonalStart();
		drawOrthoTexPlane(TitleTexture[1]);
		//orthogonalEnd();
	}

	if (lastDemoPos < 13854)
	{
		//orthogonalStart();
		drawOrthoTexPlane(TitleTexture[2]);
		//orthogonalEnd();
	}
	else if (lastDemoPos < 21401)
	{
		drawOrthoTexPlane(TitleTexture[3]);
		drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 38000)
	{
		drawOrthoTexPlane(TitleTexture[4]);
		drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 51122)
	{
		drawOrthoTexPlane(TitleTexture[5]);
		drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 66450)
	{
		drawOrthoTexPlane(TitleTexture[6]);
		drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 76200)
	{
		drawOrthoTexPlane(TitleTexture[7]);
		drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 77770)
	{
		drawOrthoTexPlane(TitleTexture[8]);
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 79130)
	{
		drawOrthoTexPlane(TitleTexture[9]);
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 81260)
	{
		drawOrthoTexPlane(TitleTexture[10]);
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 82353)
	{
		drawOrthoTexPlane(TitleTexture[11]);
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 84025)
	{
		drawOrthoTexPlane(TitleTexture[12]);
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 86269)
	{
		drawOrthoTexPlane(TitleTexture[13]);
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 89777)
	{
		drawOrthoTexPlane(TitleTexture[14]);
		//drawOrthoCornerShapes();
		//drawCubeWall();
		
	}
	//INTRO 89777-111111


	else if (lastDemoPos < 96990)
	{
		
	}
	//97000-10000
	else if (lastDemoPos < 100000)
	{
		drawOrthoSubtitlePlane(TitleTexture[16]); //etk oo koskaan
		drawOrthoCornerShapes();
		
	}
	//100000-103593
	else if (lastDemoPos < 103593)
	{
		//drawOrthoTexPlane(TitleTexture[31]); //introtausta
		drawOrthoSubtitlePlane(TitleTexture[17]); //se aate, ote
		drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 110000)
	{
		//drawOrthoTexPlane(TitleTexture[37]); //introtausta
		drawOrthoSubtitlePlane(TitleTexture[18]); //taas ote, ote vaan
		drawOrthoCornerShapes();
		
	}
		else if (lastDemoPos < 111111)
	{
		//empty
		
	}


	//111111-114815
	else if (lastDemoPos < 114815)
	{
		//drawOrthoTexPlane(TitleTexture[41]); //cubes01
		drawOrthoSubtitlePlane(TitleTexture[19]); //ei, ei ole eeeei
		//drawOrthoCornerShapes();
		
	}

	else if (lastDemoPos < 118320)
	{
		//drawOrthoTexPlane(TitleTexture[42]); //cubes02
		drawOrthoSubtitlePlane(TitleTexture[20]); //ei niin
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 120000)
	{
		//drawCubeWall();
		drawOrthoTexPlane(TitleTexture[46]); //cubes06
		drawOrthoSubtitlePlane(TitleTexture[21]); //s oot
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 125526)
	{
		//drawCubeWall();
		//drawOrthoTexPlane(TitleTexture[49]); //cubes09
		drawOrthoSubtitlePlane(TitleTexture[22]); //instanssis
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 139500)
	{
		drawOrthoSubtitlePlane(TitleTexture[23]); //huilusoolo
		drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 143200)
	{
		drawOrthoSubtitlePlane(TitleTexture[24]); //sotke sydmes
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 146683)
	{
		drawOrthoSubtitlePlane(TitleTexture[25]); //levisk ne sinun ansassa
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 150200)
	{
		drawOrthoSubtitlePlane(TitleTexture[26]); //soo soo vartija
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 152069)
	{
		drawOrthoSubtitlePlane(TitleTexture[27]); //"esittele sinun"
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 153000)
	{
		drawOrthoSubtitlePlane(TitleTexture[28]); //"ASD DKFEOJPORJPOHROH"
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 153875)
	{
		drawOrthoSubtitlePlane(TitleTexture[29]); //"ei ollu sipsipullo"
		//drawOrthoCornerShapes();
		
	}
	else if (lastDemoPos < 161157)
	{
		drawCubeWall();
		drawOrthoSubtitlePlane(TitleTexture[30]); //"et sy"
		
	}
	else if (lastDemoPos < 166000)
	{
		

		//drawCubeWall();
		
	}
	else
	{
		close(0);
	}


    glutSwapBuffers(); 
    //Pivitetn nkymn liittyvi arvoja
    update(); 
	FRAME_NO++;
}


void keyPressed(unsigned char key, int x, int y){
    switch(key){
        case 27: glutExit(); break;
		case 115:
		{
			if (lastDemoPos < 89000)
			{
			    printf("Skipped the opening sequence");//lastDemoPos = lastAudioPos;
			    skipAmount = SKIPPOSITION_MS - lastDemoPos;
			    introIsSkipped = true;
			    lastDemoPos = SKIPPOSITION_MS;
			    lastAudioPos = SKIPPOSITION_MS;
			    fmodResult = fmodChannel->setPosition(SKIPPOSITION_MS, FMOD_TIMEUNIT_MS);
			    //fmodResult = fmodChannel->getPosition(&lastAudioPos, FMOD_TIMEUNIT_MS);
	            if (fmodResult != FMOD_OK)
	            {
		            cout << "Error at changing song position" << endl;
		            close(1);
	            }
			}
		}


		default: break;

    }
}


void drawTexPlaneSequence(){

if(lastDemoPos<89777){}
else if(lastDemoPos<96990) drawOrthoTexPlane(TitleTexture[31]); //introtausta
else if(lastDemoPos<100000) drawOrthoTexPlane(TitleTexture[32]); //rage manifesto presents
else if(lastDemoPos<102000) drawOrthoTexPlane(TitleTexture[31]); //introtausta
else if(lastDemoPos<103000) drawOrthoTexPlane(TitleTexture[33]); //introtausta
else if(lastDemoPos<104000) drawOrthoTexPlane(TitleTexture[34]); //introtausta
else if(lastDemoPos<105000) drawOrthoTexPlane(TitleTexture[35]); //introtausta
else if(lastDemoPos<106500) drawOrthoTexPlane(TitleTexture[36]); //introtausta
else if(lastDemoPos<108000) drawOrthoTexPlane(TitleTexture[37]); //introtausta
else if(lastDemoPos<108500) drawOrthoTexPlane(TitleTexture[38]); //introtausta
else if(lastDemoPos<109000) drawOrthoTexPlane(TitleTexture[39]); //introtausta
else if(lastDemoPos<109500) drawOrthoTexPlane(TitleTexture[40]); //introtausta
else if(lastDemoPos<111111) drawOrthoTexPlane(TitleTexture[31]); //introtausta
//cubescene111111-125484, titletexturet 41-51
else if(lastDemoPos<113000) drawOrthoTexPlane(TitleTexture[41]); //introtausta
else if(lastDemoPos<114000) drawOrthoTexPlane(TitleTexture[42]); //introtausta
else if(lastDemoPos<115000) drawOrthoTexPlane(TitleTexture[43]); //introtausta
else if(lastDemoPos<116000) drawOrthoTexPlane(TitleTexture[44]); //introtausta
else if(lastDemoPos<117000) drawOrthoTexPlane(TitleTexture[45]); //introtausta
else if(lastDemoPos<118000) drawOrthoTexPlane(TitleTexture[46]); //introtausta
else if(lastDemoPos<125484) drawRotatingTexPlane(TitleTexture[47]);
//huilusoolo 125484-139538, titletexturet 62-67
else if(lastDemoPos<127000) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<127050) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<127100) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<127150) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<127200) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<127250) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<127300) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<127350) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<127400) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<127450) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<127500) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<127550) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<129000) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<129500) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<130000) drawOrthoTexPlane(TitleTexture[62]); //introtausta
else if(lastDemoPos<130500) drawOrthoTexPlane(TitleTexture[63]); //introtausta
else if(lastDemoPos<133000) drawOrthoTexPlane(TitleTexture[64]); //introtausta
else if(lastDemoPos<135000) drawOrthoTexPlane(TitleTexture[65]); //introtausta
else if(lastDemoPos<137000) drawOrthoTexPlane(TitleTexture[66]); //introtausta
else if(lastDemoPos<138500) drawOrthoTexPlane(TitleTexture[67]); //introtausta

else if(lastDemoPos<139538) drawOrthoTexPlane(TitleTexture[68]); //introtausta
//bumpmapping 139538-153864, titletexturet 52-61
else if(lastDemoPos<142000) drawOrthoTexPlane(TitleTexture[52]);
else if(lastDemoPos<145000) drawOrthoTexPlane(TitleTexture[53]);
else if(lastDemoPos<147000) drawOrthoTexPlane(TitleTexture[54]);
else if(lastDemoPos<149000) drawOrthoTexPlane(TitleTexture[55]);
else if(lastDemoPos<149400) drawOrthoTexPlane(TitleTexture[56]);
else if(lastDemoPos<149800) drawOrthoTexPlane(TitleTexture[57]);
else if(lastDemoPos<150200) drawOrthoTexPlane(TitleTexture[58]);
else if(lastDemoPos<150400) drawOrthoTexPlane(TitleTexture[59]);
else if(lastDemoPos<150800) drawOrthoTexPlane(TitleTexture[60]);
else if(lastDemoPos<151200) drawOrthoTexPlane(TitleTexture[61]);
else if(lastDemoPos<153864) drawOrthoTexPlane(TitleTexture[61]);
else if(lastDemoPos<161131) {}
else if(lastDemoPos<166000) drawOrthoTexPlane(TitleTexture[69]);
//else if(lastDemoPos<166250) drawOrthoTexPlane(TitleTexture[70]);
//else if(lastDemoPos<166500) drawOrthoTexPlane(TitleTexture[71]);
//else if(lastDemoPos<166750) drawOrthoTexPlane(TitleTexture[70]);
//else if(lastDemoPos<167000) drawOrthoTexPlane(TitleTexture[71]);

//161131 creditziruutu

}

void loadTextures(){

	//Today we're having a pile of copypaste shit, as the attempts on
	//loading texture files with dynamically created file path strings
	//resulted in empty fucking buffers. And the time was extremely scarce.

	    //int a = 1;
	    ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro00.png");
	    //GLuint Texture;
        TitleTexture[1] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro01.png");
	    //GLuint Texture;
        TitleTexture[2] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro02.png");
	    //GLuint Texture;
        TitleTexture[3] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro03.png");
	    //GLuint Texture;
        TitleTexture[4] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro04.png");
	    //GLuint Texture;
        TitleTexture[5] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro05.png");
	    //GLuint Texture;
        TitleTexture[6] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);
	
		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro06.png");
	    //GLuint Texture;
        TitleTexture[7] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro07.png");
	    //GLuint Texture;
        TitleTexture[8] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro08.png");
	    //GLuint Texture;
        TitleTexture[9] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro09.png");
	    //GLuint Texture;
        TitleTexture[10] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro10.png");
	    //GLuint Texture;
        TitleTexture[11] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro11.png");
	    //GLuint Texture;
        TitleTexture[12] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro12.png");
	    //GLuint Texture;
        TitleTexture[13] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro13.png");
	    //GLuint Texture;
        TitleTexture[14] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/intro13.png");
	    //GLuint Texture;
        TitleTexture[15] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//a on 15 tss

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub01.png");
	    //GLuint Texture;
        TitleTexture[16] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub02.png");
	    //GLuint Texture;
        TitleTexture[17] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub03.png");
	    //GLuint Texture;
        TitleTexture[18] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub04.png");
	    //GLuint Texture;
        TitleTexture[19] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub05.png");
	    //GLuint Texture;
        TitleTexture[20] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub06.png");
	    //GLuint Texture;
        TitleTexture[21] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub07.png");
	    //GLuint Texture;
        TitleTexture[22] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub08.png");
	    //GLuint Texture;
        TitleTexture[23] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub09.png");
	    //GLuint Texture;
        TitleTexture[24] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub10.png");
	    //GLuint Texture;
        TitleTexture[25] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub11.png");
	    //GLuint Texture;
        TitleTexture[26] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub12.png");
	    //GLuint Texture;
        TitleTexture[27] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub13.png");
	    //GLuint Texture;
        TitleTexture[28] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub14.png");
	    //GLuint Texture;
        TitleTexture[29] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/sub15.png");
	    //GLuint Texture;
        TitleTexture[30] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title00.png");
	    //GLuint Texture;
        TitleTexture[31] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title01.png");
	    //GLuint Texture;
        TitleTexture[32] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title02.png");
	    //GLuint Texture;
        TitleTexture[33] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title03.png");
	    //GLuint Texture;
        TitleTexture[34] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title04.png");
	    //GLuint Texture;
        TitleTexture[35] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title05.png");
	    //GLuint Texture;
        TitleTexture[36] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title06.png");
	    //GLuint Texture;
        TitleTexture[37] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title07.png");
	    //GLuint Texture;
        TitleTexture[38] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title08.png");
	    //GLuint Texture;
        TitleTexture[39] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/title09.png");
	    //GLuint Texture;
        TitleTexture[40] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes01.png");
	    //GLuint Texture;
        TitleTexture[41] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes02.png");
	    //GLuint Texture;
        TitleTexture[42] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes03.png");
	    //GLuint Texture;
        TitleTexture[43] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes04.png");
	    //GLuint Texture;
        TitleTexture[44] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes05.png");
	    //GLuint Texture;
        TitleTexture[45] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes06.png");
	    //GLuint Texture;
        TitleTexture[46] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes07.png");
	    //GLuint Texture;
        TitleTexture[47] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes08.png");
	    //GLuint Texture;
        TitleTexture[48] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes09.png");
	    //GLuint Texture;
        TitleTexture[49] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes10.png");
	    //GLuint Texture;
        TitleTexture[50] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/cubes11.png");
	    //GLuint Texture;
        TitleTexture[51] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump01.png");
	    //GLuint Texture;
        TitleTexture[52] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump02.png");
	    //GLuint Texture;
        TitleTexture[53] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump03.png");
	    //GLuint Texture;
        TitleTexture[54] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump04.png");
	    //GLuint Texture;
        TitleTexture[55] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump05.png");
	    //GLuint Texture;
        TitleTexture[56] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump06.png");
	    //GLuint Texture;
        TitleTexture[57] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump07.png");
	    //GLuint Texture;
        TitleTexture[58] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump08.png");
	    //GLuint Texture;
        TitleTexture[59] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump09.png");
	    //GLuint Texture;
        TitleTexture[60] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/bump10.png");
	    //GLuint Texture;
        TitleTexture[61] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/nokkis01.png");
	    //GLuint Texture;
        TitleTexture[62] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/nokkis02.png");
	    //GLuint Texture;
        TitleTexture[63] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/nokkis03.png");
	    //GLuint Texture;
        TitleTexture[64] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/nokkis04.png");
	    //GLuint Texture;
        TitleTexture[65] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/nokkis05.png");
	    //GLuint Texture;
        TitleTexture[66] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/nokkis06.png");
	    //GLuint Texture;
        TitleTexture[67] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/nokkis07.png");
	    //GLuint Texture;
        TitleTexture[68] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/endstuff01.png");
	    //GLuint Texture;
        TitleTexture[69] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		/*
		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/endstuff02.png");
	    //GLuint Texture;
        TitleTexture[70] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);

		//ILuint ImageName;
	    ilGenImages(1, &ImageName);
	    ilBindImage(ImageName);
	    ilLoadImage((const ILstring)"../data/endstuff03.png");
	    //GLuint Texture;
        TitleTexture[71] = ilutGLBindTexImage();
	    ilDeleteImages(1, &ImageName);
		*/

}

int main(int argc, char** argv){

	int windowed = 0;
	int resChoice = 0;
	WINDOW_WIDTH = 1280;
	WINDOW_HEIGHT = 720;
	WINDOW_WIDTH_HALVED = 640;
	WINDOW_HEIGHT_HALVED = 360;

std::cout << "===========================================================================" << endl;
std::cout << "Hello earthling! You have chosen to run RageMegaSuper 2012 Prototype Demo.=" << endl;
std::cout << "===========================================================================" << endl;
std::cout << "====================HERE'S THE 1ST EFFECT, HAR HAR HAR=====================" << endl;
std::cout << ".........................DDMMMMMDD........................................." << endl;
std::cout << "......................MM:MMMMMMD8888888OOMMMMMMMDDD........................" << endl;
std::cout << ".....................MM:     .  .  .. 8MMMMMMMMMMMMMMMMMMM,................" << endl;
std::cout << "....................MM+. .. .. .........MMM==========DMM,.................." << endl;
std::cout << ".................. MM$........ .. ... ~MM?=========MMM....................." << endl;
std::cout << "......................DDMMMM.........MMM=======+DMMM ......................" << endl;
std::cout << ".............................DDMMMMMMMMMMMDDDD............................." << endl;
std::cout << ".................................DDDD......................................" << endl;
std::cout << "===========================================================================" << endl;
	std::cout << "Please Choose! fullscreen [0] (default, 1280x720 only) OR windowed [1]" << endl; 
	std::cin >> windowed;
	if(windowed)
	{
	    std::cout << "Please choose resolution" << endl << "1 - 800x480" << endl << "2 - 1280x720 (default)" << endl << "3 - 1920x1080" << endl; 
	    std::cin >> resChoice;
	    switch(resChoice)
	    {
	        case 1: {WINDOW_WIDTH = 800; WINDOW_HEIGHT = 480; WINDOW_WIDTH_HALVED = 400; WINDOW_HEIGHT_HALVED = 240; break;}
		    //case 2: //1280x720 resolution is the default that's already been set
		    case 3: {WINDOW_WIDTH = 1920; WINDOW_HEIGHT = 1080; WINDOW_WIDTH_HALVED = 960; WINDOW_HEIGHT_HALVED = 540; break;}
	        default: {break;}
		}
    }

	printf("using resolution %d x %d\n", WINDOW_WIDTH, WINDOW_HEIGHT);
	
	printf("loading sound system..\n");
	//===============================FMOD INIT====================================
	fmodResult = FMOD::System_Create(&fmodSystem);		// Create the main system object.
	if (fmodResult != FMOD_OK)
	{

	    printf("Error at creating fmod system\n");
		close(1);
	}

	fmodResult = fmodSystem->init(100, FMOD_INIT_NORMAL, 0);	// Initialize FMOD.
	if (fmodResult != FMOD_OK)
	{
		printf("Error at initializing fmod\n");
		close(1);
	}

	//FMOD::Sound *fmodSound; // on jo esitelty globaalilla tasolla
	fmodResult = fmodSystem->createSound("../data/megarage2012_v02.mp3", FMOD_DEFAULT, 0, &fmodSound);

	//FMOD::Channel *fmodChannel; // on jo esitelty globaalilla tasolla

	//================================GLUT INIT==================================
	printf("initializing glut..\n");
    glutInit(&argc, argv); 

	if(windowed)
	{
        glutInitWindowPosition(100, 100); 
        glutInitWindowSize(WINDOW_WIDTH, WINDOW_HEIGHT); 
        glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH); 
        glutCreateWindow("RageMegaSuper 2012 Prototype");
	}
	else
	{
		glutGameModeString( "1280x720:32@60" ); //the settings for fullscreen mode
	    glutEnterGameMode(); //set glut to fullscreen using the settings in the line above
	    glutSetCursor(GLUT_CURSOR_NONE);
	}

	//register GLUT callback functions
    glutDisplayFunc(display); 
    glutIdleFunc(idle); 
    glutKeyboardFunc(keyPressed); 


    glEnable(GL_DEPTH_TEST); 
    glEnable(GL_LIGHTING); 
    glEnable(GL_LIGHT0); 
    glViewport(0, 0, (GLsizei)WINDOW_WIDTH, (GLsizei)WINDOW_HEIGHT); 
    glMatrixMode(GL_PROJECTION); 
    gluPerspective(85, (GLfloat)WINDOW_WIDTH / (GLfloat)WINDOW_HEIGHT, 1.0, 100.0); 
    glMatrixMode(GL_MODELVIEW); 

	printf("loading textures..\n");
	//IL IMAGE INITIALIZATION
	ilInit();
	iluInit();
	ilutRenderer(ILUT_OPENGL);
    loadTextures();

	printf("attempting kickstart..\n");
	//start playing sound with FMOD
	fmodResult = fmodSystem->playSound(FMOD_CHANNEL_FREE, fmodSound, false, &fmodChannel);
	if (fmodResult != FMOD_OK)
	{
		printf("Error at starting up channel for playback\n");
		close(1);
	}

	//start timer
	timer_start();

    //Siirrytn GLUTin psilmukkaan
    glutMainLoop(); 
    return(5);
}