import processing.core.*; 
import processing.xml.*; 

import ddf.minim.*; 
import processing.opengl.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class MisKittens extends PApplet {




/**
 * Mis Kittins
 *  a demo for Instanssi 2012
 *
 * by Juho J\u00e4rvinen 2010
 *  + Juho J\u00e4rvinen 2012
 *
 * extends "Cubic Grid by Ira Greenberg"
 *
 */

AudioPlayer player;
Minim minim;

/// ekaskene \\\
float boxSize = 256;
float depth = 10;
int boxFill = color(0, 64, 0, 255);
PImage img01,img02,img03,img04;
int imgx;
/// tokaskene \\\
PImage a, b, c, kuva;
int totalSlices=20;  // the number of slices the image will start with... should be divisable by 4
int thisX=0, thisY=0;    // coordinates
int previousX, previousY;  //store previous coordinates
int toka = 0;
/// kolmaskene \\\
float rot = 0.0f;
float sk = 1;
/// neljaskene \\\
float theta;

// yleist\u00e4
int songpos; // song position in ms
int songlen; // song length in ms
float ii = 0;   // no jossain skenes t\u00e4t\u00e4 k\u00e4ytet\u00e4\u00e4n

// KISSIT \\\
PImage kissa1, kissa2, kissa3, kissa4, kissa5, kissa6;
int kis = 1;

int SCREEN_WIDTH = 1280;
int SCREEN_HEIGHT = 720;

public void setup() {
  size(1280, 720, OPENGL);
  hint(DISABLE_DEPTH_TEST);
  hint(DISABLE_OPENGL_ERROR_REPORT);

  img01 = loadImage("juhoap.png");
  //img02 = loadImage("slowmowsown.gif");
  img03 = loadImage("inst2012.png");
  img04 = loadImage("juho.png");
  a = loadImage("psy.png");
  b = loadImage("psy4.png");
  c = loadImage("psy2.png");

  kissa1 = loadImage("tirpaa.png");
  kissa2 = loadImage("simhienopaa.png");
  kissa3 = loadImage("tirpaa2.png");
  kissa4 = loadImage("ritpaavih.png");
  kissa5 = loadImage("ritpaa3.png");
  kissa6 = loadImage("simpentupaa.png");

  // biisi latautumaan ja soimaan
  minim = new Minim(this);
  player = minim.loadFile("6six.mp3", 2048);
  songlen = player.length();
  player.play();

  //noFill();
  fill(0,255,0,64);
  stroke(boxFill);
  noCursor();
  smooth();
  background(0);
}

public void kissa(int kuka) {
  pushMatrix();
  noLights(); // ei anneta valojen vaikuttaa p\u00e4\u00e4lle piirrett\u00e4viin
  switch(kuka) {
    case 1: 
      image(kissa1,width/2.7f,height/3.3f-imgx);
      break;
    case 2:
      image(kissa2,width/3.5f,height/6);
      break;
    case 3:
      image(kissa3,64-imgx,-38-imgx/2);
      break;
    case 4:
      image(kissa4,0,-64);
      break;
    case 5:
      image(kissa5,width-435-imgx,height-384-imgx);
      break;
    case 6:
      image(kissa6,width/5,height/24);
      break;
  }
  popMatrix();
  if (imgx < 6) {
    imgx++;
  }
  else {
    imgx = 0;
  }
}

public void draw() {

  songpos = player.position();
  if (songpos >= songlen) {
    stop();
    exit();
  }
  if ( songpos < 1000 ) {
    background(0);
  }
  else if ( songpos < 7500 ) {
    background(ii+=0.3f);
  }
  else if ( songpos < 15000 ) {
    background(128);
    tekst();
  }
  else if ( songpos < 35000 ) {
    ekaskene();
    tekst();
  }
  else if ( songpos < 42000 ) {
    tokaskene(a);
  }
  else if ( songpos < 56000 ) {
    kolmaskene();
  }
  else if (songpos < 70000 ) {
    tokaskene(b);
  }
  else if (songpos < 83000 ) {
    tokaskene(c);
  }
  else if (songpos < 97000 ) {
    neljaskene();
  }
  else if (songpos < 105000 ) {
    // KISSASKENE T\u00c4H\u00c4N EH
    kissaskeneAlku();
  }
  else if (songpos < 121000 ) {
    kissaskeneMeno();
  }
  else if (songpos < 137000 ) {
    tokaskene(b);
    kissa(5);
  }
  else if (songpos < 150000 ) {
    tokaskene(a);
    kissa(6);
  }
  else if (songpos < 164000 ) {
    neljaskene();
    kissa(3);
  }
  else if (songpos < 170000 ) {
    kolmaskene();
    kissa(2);
  }
  else if (songpos < 177000 ) {
    tokaskene(c);
    kissa(5);
  }
  else if (songpos < 184000 ) {
    tokaskene(b);
    kissa(6);
  }
  else if (songpos < 198000 ) {
    tokaskene(a);
    kissa(2);
  }
  else if (songpos < 205000 ) {
    neljaskene();
    kissa(4);
  }
  else if (songpos < 212000 ) {
    fill(random(255),random(255),random(255),255);
    ekaskene();
    kissa(5);
  }
  else if (songpos < 225000 ) {
    tokaskene(a);
    kissa(6);
  }
  else if (songpos < 239000 ) {
    tokaskene(b);
    kissa(1);
  }
  else if (songpos < 248000 ) {
    neljaskene();
    kissa(2);
  }
  else if (songpos < 255000 ) {
    kissaskeneMeno();
  }
  else if (songpos < 300000 ) {
    stop();
    exit();
  }
}

public void kissaskeneAlku() {
  noLights();
  background(0);
  pushMatrix();
  // oujee, lines before cats..
  for (int x=0; x<width; x+=64) {
    for (int y=0; y<height; y+=64) {
      rotate(theta--);   // Rotate by theta
      translate(x,y,0-y+x);
      stroke(random(255),random(255),random(255));
      line(0,0,width,height);
      line(0,height,width,0);
      line(width/2,0,width/2,height);
      line(0,height/2,width,height/2);
      line(width/12,height/3,width/2,height/12);
      line(0,height/8,width/4,height/5);
      ellipse(width/2,height/2,128,128);
      ellipse(width/2,height/2,256,256);
      if (kis>6) kis=1;
    }
  }
  popMatrix();
}

public void kissaskeneMeno() {
  noLights();
  background(0);
  pushMatrix();
  // oujee, THE cats
  for (int x=0; x<width; x+=64) {
    for (int y=0; y<height; y+=32) {
      rotate(theta--);   // Rotate by theta
      //translate(x,y,0-y+x);
      translate(0,0,0-y+x);
      stroke(255,0,255);
      line(0,0,width-kis*3,height-kis*3);
      line(0,height-kis*3,width-kis*3,0);
      if (kis>6) kis=1;
      //kissa(kis++);
      kissa(1);
      if (songpos > 107000) kissa(2);
      if (songpos > 110000) kissa(4);
      if (songpos > 113000) kissa(3);
      if (songpos > 116000) kissa(5);
      if (songpos > 119000) kissa(6);
      // 105000 < 121000
    }
  }
  popMatrix();
}

public void neljaskene() {
  pushMatrix();    // Save the current state of transformation (i.e. where are we now)
  //background(0);
  background(255-rot);
  rot++;
  stroke(random(255),random(255),random(255));
  // Let's pick an angle 0 to 90 degrees based on the mouse position
  float a = (random(width/2) / (float) width) * 90f;
  // Convert it to radians
  theta = radians(a);
  // Start the tree from the bottom of the screen
  translate(width/2,height);
  // Draw a line 120 pixels
  line(0,0,0,-60);
  line(0,0,0,-60);
  line(0,0,0,-60);
  // Move to the end of that line
  translate(0,-60);
  // Start the recursive branching!
  branch(342);
  popMatrix();     // Whenever we get back here, we "pop" in order to restore the previous matrix state
}

// neljaskeneen liittyypi tama
public void branch(float h) {
  // Each branch will be 2/3rds the size of the previous one
  //h *= 0.66;
  h *= 0.66f;

  // All recursive functions must have an exit condition!!!!
  // Here, ours is when the length of the branch is 2 pixels or less
  if (h > 1) {
    pushMatrix();    // Save the current state of transformation (i.e. where are we now)
    rotate(theta);   // Rotate by theta
    line(0, 0, 0, -h);  // Draw the branch
    translate(0, -h); // Move to the end of the branch
    branch(h);       // Ok, now call myself to draw two new branches!!
    popMatrix();     // Whenever we get back here, we "pop" in order to restore the previous matrix state

    // Repeat the same thing, only branch off to the "left" this time!
    pushMatrix();
    rotate(-theta);
    line(0, 0, 0, -h);
    line(0, 3, 5, -h);
    translate(0, -h);
    branch(h);
    popMatrix();
  }
}

public void kolmaskene() {
  background(255-rot);

  pushMatrix();
  translate(width/2, height/2);
  scale(sk+=0.51f);
  if (sk>15) sk = 0;
  rotate(rot*TWO_PI/360);
  translate(-width/2, -height/2);
  //tint(255,225);
  //float rd = random(3);

  for (int i=0; i<32; ++i) {
    for (int l1=0; l1<32; ++l1) {
      stroke(0,0,255);
      line((width/2)-l1*4,0,(width/2)-l1*4,height+l1*4);
    }
    for (int l1=0; l1<32; ++l1) {
      stroke(255-l1*9,0,255-l1*9);
      line(0,(height/2)-l1*256,width,(height/2)+l1*256);
    }
    for (int l1=0; l1<32; ++l1) {
      stroke(255,255,0);
      line((width/2)+l1*2,0,(width/2)+l1*4,height+l1*4);
    }
    for (int l1=0; l1<32; ++l1) {
      stroke(0,255-l1*9,0);
      line(0,(height/2)+l1*256,width,(height/2)-l1*256);
    }
  }
  popMatrix();

  rot++;
}

public void tokaskene(PImage kuva) {
  //songpos = player.position();
  pushMatrix();
  if(totalSlices==0) {
    background(0,0,0);
    image(kuva,0,0);
  }
  else {
    if(previousX-thisX!=0 || previousY-thisY!=0) {
      background(0,0,0);

      //the width and height parameters for the mask
      //      int w = int(width/3.2); 
      //      int h = int(height/3.2);
      int w = PApplet.parseInt(width/3.2f);
      int h = PApplet.parseInt(height/3.2f);

      //create a mask of a slice of the original image.
      PGraphics selection_mask;
      selection_mask = createGraphics(w, h, JAVA2D);
      selection_mask.beginDraw();
      //      selection_mask.smooth();
      selection_mask.arc(0,0, 2*w, 2*h, 0, radians(360/totalSlices+.1f));   //using 369 to reduce lines on arc edges
      selection_mask.endDraw();

      float wRatio = PApplet.parseFloat(kuva.width-w)/PApplet.parseFloat(width);
      float hRatio = PApplet.parseFloat(kuva.height-h)/PApplet.parseFloat(height);

      //thisX = int(random(player.bufferSize()));
      thisY = PApplet.parseInt(height/2 + player.mix.get(thisX) * height/2);

      PImage slice = createImage(w, h, RGB);
      slice = kuva.get(PApplet.parseInt((thisX)*wRatio), PApplet.parseInt((thisY)*hRatio), w, h);  
      slice.mask(selection_mask);
      translate(width/2,height/2);
      float scaleAmt = 1.9f;
      scale(scaleAmt);

      for(int k = 0; k<=totalSlices ;k++) { 
        //        rotate(k*radians(360/(totalSlices/2))); 
        rotate(k*radians(360/(totalSlices)));
        image(slice, 0, 0);
        scale(-1.0f, 1.0f);
        image(slice,0,0);
      }
    }
    resetMatrix();
  }
  // thisX menee 0-SCREEN_WIDTH-1 ja sit taas alusta
  if (thisX >= width-1) {
    thisX = 0;
  } 
  else {
    thisX++;
  }
  popMatrix();
}

public void ekaskene() {
  pushMatrix(); // perusn\u00e4kym\u00e4 talteen
  background(255);
  //fill(random(255),random(255),random(255),255);
  // t\u00e4\u00e4 tekee kaikesta ufoa
  pointLight(255, 255, 255, width/2, height/2, depth/2);
  // Center and spin grid
  depth += 4;
  if (depth>700) depth = 10;
  translate(width/2, height/2, random(depth));
  rotateY(frameCount * -0.04f);
  rotateX(frameCount * 0.05f);
  rotateZ(frameCount * 0.05f);

  // Build grd using multiple translations 
  for (float i =- depth; i <= depth; i += boxSize) {
    //pushMatrix();
    for (float j =- depth; j <= depth; j += boxSize) {
      //pushMatrix();
      for (float k =- depth; k <= depth; k += boxSize) {
        pushMatrix();
        translate(k, j, i);
        box(boxSize);
        popMatrix();
      }
      //popMatrix();
    }
    //popMatrix();
  }

  popMatrix(); // perusn\u00e4kym\u00e4 k\u00e4ytt\u00f6\u00f6n
}

public void tekst() {
  pushMatrix(); // perusn\u00e4kym\u00e4 talteen
  noLights(); // ei anneta valojen vaikuttaa p\u00e4\u00e4lle piirrett\u00e4viin
  if ( songpos < 14500 ) {
    image(img01,width/2.5f,height/2.5f-imgx/2);
  }
  else if ( songpos < 28000 ) {
    background(96,0,96);
    scale(1.2f,2.1f);
    image(img03,96-imgx,height/9);
  }
  else if ( songpos < 35000 ) {
    image(img04,width-180-imgx,height-245);
  }
  if (imgx < 6) {
    imgx++;
  }
  else {
    imgx = 0;
  }
  popMatrix(); // perusn\u00e4kym\u00e4 k\u00e4ytt\u00f6\u00f6n
//  lights();
}

public void stop()
{
  player.close();
  minim.stop();
  super.stop();
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--present", "--bgcolor=#000000", "--hide-stop", "MisKittens" });
  }
}
