float4x4 objectToWorldMatrix;
float4x4 worldToCameraMatrix;
float4x4 projMatrix;
float4x4 textureMatrix;

Texture2D txDiffuse;
Texture2D txDepth;

float4x4 viewToWorld;
float4x4 previousWorldToView;

float widthToHeight;
float strength;
float clamp;
int numSamples;

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

struct VS_IN
{
    float4 pos : POSITION;
    float2 texCoord : TEXCOORD;
};

struct PS_IN
{
    float4 pos : SV_POSITION;
    float2 texCoord: TEXCOORD0;
};

PS_IN VS( VS_IN input )
{
    PS_IN output = (PS_IN)0;

    input.pos = mul(input.pos, objectToWorldMatrix); 
    output.pos = mul(input.pos, worldToCameraMatrix);
    output.pos = mul(output.pos, projMatrix);
    output.texCoord = input.texCoord;

    return output;
}

static const int NUMWT = 10;
static const float Gauss[NUMWT] = { 0.93, 0.86, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1 };

float4 PS( PS_IN input ) : SV_Target
{
    float depth = txDepth.Sample(samLinear, input.texCoord);
    float4 viewTFragPos = float4(-input.texCoord.x*2.0 + 1.0, input.texCoord.y*2.0 - 1.0, depth, 1.0);
    float4 worldTFragPos = mul(viewTFragPos, viewToWorld);
    worldTFragPos /= worldTFragPos.w;

    float4 viewTPreviousFragPos = mul(worldTFragPos, previousWorldToView);
    viewTPreviousFragPos /= viewTPreviousFragPos.w;
  
    float2 velocity = (viewTFragPos.xy - viewTPreviousFragPos.xy)*strength;
    velocity.x = -velocity.x;
    if (abs(velocity.x) < 0.0001)
        velocity.x = 0.0;
    if (abs(velocity.y) < 0.0001)
        velocity.y = 0.0;

    float l = length(velocity);
    if (l > 0 && l > clamp)
        velocity *= clamp/l;

    float2 dir = velocity*10.0/numSamples;
    float2 pos = dir;
    float4 c = txDiffuse.Sample(samLinear, input.texCoord);
    float totalWeight = 1;
    for (int i = 0; i < numSamples; ++i) {
        float index = (float)i*(NUMWT - 1)/numSamples;
        float weight = lerp(Gauss[(int)index], Gauss[(int)index + 1], frac(index));
        c += txDiffuse.Sample(samLinear, input.texCoord + pos)*weight;
        c += txDiffuse.Sample(samLinear, input.texCoord - pos)*weight;
        pos += dir;
        totalWeight += 2*weight;
    }
    c.rgb /= totalWeight;
    c.a = 1.0;

    return c;
}

technique10 Render
{
    pass P0
    {
        SetGeometryShader( 0 );
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
    }
}
