//>>> _common parameters
float4x4 objectToWorldMatrix;
float4x4 worldToCameraMatrix;
float4x4 projMatrix;
Texture2D txDiffuse;
//<<< _common parameters

//>>> _parameters
float Glow;
float Offset;
float Size;
float Angle;
float SampleCount;
//<<< _parameters

//>>> _setup
SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};
//<<< _setup

//>>> _declarations
struct VS_IN
{
    float4 pos : POSITION;
    float2 texCoord : TEXCOORD;
};

struct PS_IN
{
    float4 pos : SV_POSITION;
    float2 texCoord: TEXCOORD0;
};
//<<< _declarations



//>>> GS

//<<< GS

// VS 
PS_IN VS( VS_IN input )
{
    PS_IN output = (PS_IN)0;

    output.pos = mul(input.pos, worldToCameraMatrix);
    output.pos = mul(output.pos, projMatrix);
    output.texCoord = input.texCoord;

    return output;
}
//<<< VS

//>>> PS
static const int NUMWT = 10;
static const float Gauss[NUMWT] = { 0.93, 0.86, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1 };

float4 PS( PS_IN input ) : SV_Target
{
    float2 dir = float2(1,1);
    dir *= 0.01*Size/SampleCount;
    dir.y *= 1.0;

    float2 pos = dir;
    float4 c = txDiffuse.Sample(samLinear, input.texCoord);
    float totalWeight = 1;
    for (int i = 0; i < SampleCount; ++i) {
        float index = (float)i*(NUMWT - 1)/SampleCount;
        float weight = lerp(Gauss[(int)index], Gauss[(int)index + 1], frac(index));
        c += txDiffuse.Sample(samLinear, input.texCoord + pos)*weight;
        c += txDiffuse.Sample(samLinear, input.texCoord - pos)*weight;
        pos += dir;
        totalWeight += 2*weight;
    }

    c.rgb = float3(Offset, Offset, Offset) + c.rgb/totalWeight*Glow;
    c.a = 1.0;

    return c;
}
//<<< PS

// >>> _technique
technique10 Render
{
    pass P0
    {
        SetGeometryShader( 0 );
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
    }
}
// <<< _technique
