/*
 * Decompiled with CFR 0.152.
 */
package variables;

import java.io.Serializable;
import java.util.ArrayList;
import model.MyShaderProgram;
import opengl.Renderer;
import variables.MyLine;
import variables.Uniform;
import variables.Variable;

public class MyShaderVariable
implements Variable,
Serializable {
    private int ID = 0;
    private MyShaderProgram shaderprogram = null;
    private ArrayList<Uniform> uniforms = new ArrayList();

    public void generateUniforms(MyShaderProgram shaderprogram) {
        this.uniforms.clear();
        int i = 0;
        if (shaderprogram != null && shaderprogram.getUniforms() != null) {
            for (Uniform u : shaderprogram.getUniforms()) {
                Uniform current;
                if (i < this.uniforms.size()) {
                    current = this.uniforms.get(i);
                    current.name = u.name;
                    current.type = u.type;
                } else {
                    current = new Uniform();
                    current.name = u.name;
                    current.type = u.type;
                    current.line = new MyLine();
                    this.uniforms.add(current);
                }
                ++i;
            }
        }
        if (shaderprogram != null) {
            while (this.uniforms.size() > shaderprogram.getUniforms().size()) {
                this.uniforms.remove(this.uniforms.size() - 1);
            }
        }
    }

    public ArrayList<Uniform> getUniforms() {
        return this.uniforms;
    }

    public void setUniforms(ArrayList<Uniform> uniforms) {
        this.uniforms = uniforms;
    }

    public MyShaderProgram getShaderprogram() {
        this.getShaderProgramBYID();
        return this.shaderprogram;
    }

    private void getShaderProgramBYID() {
        if (this.shaderprogram == null) {
            for (MyShaderProgram sp : Renderer.getInstance().getShaders()) {
                if (this.ID != sp.getId()) continue;
                this.shaderprogram = sp;
                return;
            }
        }
        if (this.shaderprogram != null && this.ID != this.shaderprogram.getId()) {
            for (MyShaderProgram sp : Renderer.getInstance().getShaders()) {
                if (this.ID != sp.getId()) continue;
                this.shaderprogram = sp;
                return;
            }
        }
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int iD) {
        this.ID = iD;
        this.getShaderProgramBYID();
    }

    @Override
    public double getScaledValue(float poz) {
        return this.ID;
    }

    @Override
    public String getName() {
        return "Shader";
    }
}

