/*
 * Decompiled with CFR 0.152.
 */
package variables;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import variables.Variable;

public class MyLine
implements Variable,
Serializable {
    private double RAD = 57.29577951308232;
    public int type = 0;
    public float scale = 1.0f;
    public float playtimes = 1.0f;
    public ArrayList<Point2D> points = new ArrayList();
    public String name = "";

    @Override
    public String getName() {
        return this.name;
    }

    private void init() {
        Point2D.Double p = new Point2D.Double(250.0, 250.0);
        this.points.add(p);
    }

    public MyLine() {
        this.init();
    }

    public MyLine(String name) {
        this.name = name;
        this.init();
    }

    public MyLine(String name, double initialvalue, double scale) {
        this.name = name;
        Point2D.Double p = null;
        p = new Point2D.Double(250.0, 250.0 - initialvalue * 250.0 / scale);
        this.scale = (float)scale;
        this.points.add(p);
    }

    public MyLine(String name, double initialvalue) {
        this.name = name;
        Point2D.Double p = null;
        if (Math.abs(initialvalue) <= 1.0) {
            p = new Point2D.Double(250.0, 250.0 - initialvalue * 250.0);
        } else {
            p = new Point2D.Double(250.0, 0.0);
            this.scale = (float)initialvalue;
        }
        this.points.add(p);
    }

    public void sort() {
        boolean swapped = true;
        int j = 0;
        while (swapped) {
            swapped = false;
            ++j;
            int i = 0;
            while (i < this.points.size() - j) {
                if (this.points.get(i).getX() > this.points.get(i + 1).getX()) {
                    Point2D tmp = (Point2D)this.points.get(i).clone();
                    this.points.set(i, this.points.get(i + 1));
                    this.points.set(i + 1, tmp);
                    swapped = true;
                }
                ++i;
            }
        }
    }

    public void insertPoint(Point2D p) {
        if (this.points.size() == 0) {
            this.points.add(p);
            return;
        }
        if (p.getX() > this.points.get(this.points.size() - 1).getX()) {
            this.points.add(p);
        }
        int i = 0;
        for (Point2D p2 : this.points) {
            if (p2.getX() >= p.getX()) {
                this.points.add(i, p);
                return;
            }
            ++i;
        }
    }

    @Override
    public double getScaledValue(float poz) {
        poz = poz * this.playtimes % 500.0f;
        if (this.type == 0) {
            return (double)this.scale * (this.getValueLin(poz) - 250.0) / 250.0;
        }
        if (this.type == 1) {
            return (double)this.scale * (this.getValueLagrange(poz) - 250.0) / 250.0;
        }
        if (this.type == 2) {
            return (double)this.scale * (this.getValueCos(poz) - 250.0) / 250.0;
        }
        return 0.0;
    }

    public double getValueLagrange(float poz) {
        double pnx = 0.0;
        for (Point2D pk : this.points) {
            double lkx = 1.0;
            for (Point2D p : this.points) {
                if (p.equals(pk)) continue;
                lkx = lkx * ((double)poz - p.getX()) / (pk.getX() - p.getX());
            }
            pnx += pk.getY() * lkx;
        }
        return pnx;
    }

    public double getValueCos(float poz) {
        Point2D minL = this.points.get(0);
        Point2D minR = this.points.get(this.points.size() - 1);
        for (Point2D p : this.points) {
            double x = p.getX();
            if (x <= (double)poz && x > minL.getX()) {
                minL = p;
            }
            if (!(x >= (double)poz) || !(x < minR.getX())) continue;
            minR = p;
        }
        if (minL.getY() == minR.getY()) {
            return minL.getY();
        }
        if (minL.getX() == minR.getX()) {
            return minL.getY();
        }
        double xx = ((double)poz - minL.getX()) / (minR.getX() - minL.getX());
        double yy = minR.getY() - minL.getY();
        return minL.getY() + (-Math.cos(xx * Math.PI) + 1.0) / 2.0 * yy;
    }

    public double getValueLin(float poz) {
        if ((double)poz >= this.points.get(this.points.size() - 1).getX()) {
            return this.points.get(this.points.size() - 1).getY();
        }
        if (this.points == null) {
            return 0.0;
        }
        if (this.points.size() == 0) {
            return 0.0;
        }
        if (this.points.size() == 1) {
            return this.points.get(0).getY();
        }
        int minus = 0;
        int plus = this.points.size() - 1;
        int i = 0;
        while (i < this.points.size()) {
            if (this.points.get(i).getX() <= (double)poz && this.points.get(i).getX() > this.points.get(minus).getX()) {
                minus = i;
            }
            if (this.points.get(i).getX() >= (double)poz && this.points.get(i).getX() < this.points.get(plus).getX()) {
                plus = i;
            }
            ++i;
        }
        float ret = (float)(this.points.get(minus).getY() + (this.points.get(plus).getY() - this.points.get(minus).getY()) * ((double)poz - this.points.get(minus).getX()) / (this.points.get(plus).getX() - this.points.get(minus).getX()));
        if (plus == minus) {
            ret = (float)this.points.get(plus).getY();
        }
        return ret;
    }
}

