/*
 * Decompiled with CFR 0.152.
 */
package timeline;

import java.util.ArrayList;
import javax.media.opengl.GL2;
import model.MyShaderProgram;
import model.Resources;
import opengl.Renderer;
import timeline.TimeEntity;
import variables.MyShaderVariable;
import variables.MyTexMap;
import variables.Uniform;
import variables.Variable;

public class TimeEntityShaderEffect
extends TimeEntity {
    public MyShaderVariable shader = new MyShaderVariable();
    private MyTexMap outputMap = new MyTexMap();

    public TimeEntityShaderEffect() {
        this.name = "Shader Eff.";
        this.outputMap.setName("Output Map");
        this.outputMap.tex_type = 5;
    }

    private void setUniforms(GL2 gl, float poz, MyShaderProgram shaderprogram) {
        int sampler2DNum = 0;
        for (Uniform uni : this.shader.getUniforms()) {
            if (uni.type.equals("float")) {
                int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                gl.glUniform1f(uloc, (float)(-uni.line.getScaledValue(poz)));
                continue;
            }
            if (uni.type.equals("int")) {
                int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                gl.glUniform1i(uloc, (int)(-uni.line.getScaledValue(poz)));
                continue;
            }
            if (uni.type.equals("sampler2D")) {
                try {
                    int uniformvalue = (int)(-uni.line.getScaledValue(poz));
                    Object tex = null;
                    gl.glActiveTexture(33984 + sampler2DNum);
                    Resources.getInstance().bindNthTexture(uniformvalue);
                    gl.glTexParameteri(3553, 10242, 10497);
                    gl.glTexParameteri(3553, 10243, 10497);
                    int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                    gl.glUniform1i(uloc, sampler2DNum);
                }
                catch (Exception uniformvalue) {
                    // empty catch block
                }
                ++sampler2DNum;
                continue;
            }
            if (!uni.type.equals("bool")) continue;
            int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
            gl.glUniform1i(uloc, (int)(-uni.line.getScaledValue(poz)));
        }
    }

    private void screenQuad(GL2 gl) {
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl.glLoadIdentity();
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3d(-1.0, -1.0, 0.0);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3d(-1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3d(1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3d(1.0, -1.0, 0.0);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glPopMatrix();
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        if (this.shader != null && this.shader.getShaderprogram() != null) {
            float time2;
            poz = time2 = (float)(500.0 * ((double)poz - this.startTime) / (this.endTime - this.startTime));
            gl.glPushAttrib(1048575);
            gl.glClear(16384);
            gl.glDisable(2896);
            gl.glDisable(3042);
            gl.glEnable(3553);
            gl.glDisable(2929);
            gl.glClear(256);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.shader == null) {
                Renderer.getInstance().getGL2().getContext().makeCurrent();
            }
            this.shader.getShaderprogram().bind(true);
            this.setUniforms(gl, poz, this.shader.getShaderprogram());
            this.screenQuad(gl);
            this.shader.getShaderprogram().bind(false);
            this.outputMap.renderToTexture();
            gl.glPopAttrib();
        }
    }

    @Override
    public ArrayList<Variable> getAttributes() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.shader);
        var.add(this.outputMap);
        return var;
    }
}

