/*
 * Decompiled with CFR 0.152.
 */
package timeline;

import java.util.ArrayList;
import javax.media.opengl.GL2;
import opengl.Renderer;
import timeline.TimeEntity;
import variables.BlendType;
import variables.MyLine;
import variables.Variable;

public class TimeEntityBlur
extends TimeEntity {
    private MyLine red = new MyLine("Red", 0.2, 1.5);
    private MyLine green = new MyLine("Green", 0.2, 1.5);
    private MyLine blue = new MyLine("Blue", 0.2, 1.5);
    private MyLine alpha = new MyLine("Alpha", 0.2, 1.5);
    private MyLine max = new MyLine("max iter.", 10.0, 96.0);
    private MyLine zAdd = new MyLine("z.add", 0.1, 1.0);
    private MyLine toTex = new MyLine("To texture #", 1.0, 6.5);
    public BlendType srcBlendType = new BlendType("Src. blend", BlendType.TYPE.ONE);
    public BlendType dstBlendType = new BlendType("Dst. blend", BlendType.TYPE.SRC_ALPHA);

    public TimeEntityBlur() {
        this.name = "RadialBlur";
    }

    @Override
    public void glDraw(GL2 gl) {
        this.glDraw(gl, 0.0f);
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        float time2;
        int tex = (int)(-this.toTex.getScaledValue(poz));
        poz = time2 = (float)(500.0 * ((double)poz - this.startTime) / (this.endTime - this.startTime));
        gl.glDisable(2896);
        gl.glDisable(3042);
        gl.glDisable(2929);
        if (--tex != -1) {
            Renderer.getInstance().renderTetxures[tex].renderToTexture();
        }
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        if (tex != -1) {
            Renderer.getInstance().renderTetxures[tex].bind();
        }
        gl.glEnable(3553);
        int srcblend = this.srcBlendType.getGLBlendtype();
        int dstblend = this.dstBlendType.getGLBlendtype();
        if (srcblend == -1 || dstblend == -1) {
            gl.glDisable(3042);
        } else {
            gl.glEnable(3042);
            gl.glBlendFunc(this.srcBlendType.getGLBlendtype(), this.dstBlendType.getGLBlendtype());
        }
        double r = -this.red.getScaledValue(poz);
        double g = -this.green.getScaledValue(poz);
        double b = -this.blue.getScaledValue(poz);
        double a = -this.alpha.getScaledValue(poz);
        double maxi = (int)(-this.max.getScaledValue(poz)) / 2;
        double zadd = this.zAdd.getScaledValue(poz) / 100.0;
        gl.glColor4d(r, g, b, a);
        gl.glPushMatrix();
        double i = -maxi;
        while (i < maxi) {
            double zx = zadd * i / maxi;
            double zy = zx * 9.0 / 16.0;
            gl.glBegin(7);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex3d(-1.0 - zx, -1.0 - zy, 0.0);
            gl.glTexCoord2f(0.0f, 1.0f);
            gl.glVertex3d(-1.0 - zx, 1.0 + zy, 0.0);
            gl.glTexCoord2f(1.0f, 1.0f);
            gl.glVertex3d(1.0 + zx, 1.0 + zy, 0.0);
            gl.glTexCoord2f(1.0f, 0.0f);
            gl.glVertex3d(1.0 + zx, -1.0 - zy, 0.0);
            gl.glEnd();
            i += 1.0;
        }
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
    }

    @Override
    public ArrayList<Variable> getAttributes() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.red);
        var.add(this.green);
        var.add(this.blue);
        var.add(this.alpha);
        var.add(this.max);
        var.add(this.zAdd);
        var.add(this.srcBlendType);
        var.add(this.dstBlendType);
        var.add(this.toTex);
        return var;
    }
}

