/*
 * Decompiled with CFR 0.152.
 */
package scene;

import interfaces.OpenGLDrawable;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import opengl.Renderer;
import scene.Camera;
import scene.Entity;
import scene.EntityModel;
import scene.Group;
import scene.Light;
import util.newId;

public class Scene
implements OpenGLDrawable,
Serializable {
    private static final long serialVersionUID = -1886502741530317686L;
    private String name;
    public ArrayList<Entity> entities = new ArrayList();
    transient GLU glu = null;
    private int numberLight = 0;
    private int id = newId.getNextId();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return this.name;
    }

    public Scene() {
        EntityModel em = new EntityModel();
        em.setPosition(new Point2D.Double(40.0, 40.0));
        Camera cam = new Camera();
        cam.setPosition(new Point2D.Double(40.0, 80.0));
        Light light = new Light();
        light.setPosition(new Point2D.Double(40.0, 120.0));
        this.entities.add(em);
        this.entities.add(cam);
        this.entities.add(light);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Light getLight(int i) {
        int j = 0;
        for (Entity e : this.entities) {
            if (!e.getClass().equals(Light.class)) continue;
            if (i == j) {
                return (Light)e;
            }
            ++j;
        }
        return null;
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        if (this.glu == null) {
            this.glu = Renderer.getInstance().getGlu();
        }
        this.glDrawNoShadow(gl, poz);
    }

    public void enableLights(GL2 gl, float poz) {
        this.numberLight = 0;
        for (Entity entity : this.entities) {
            if (entity.getClass().equals(Light.class)) {
                ((Light)entity).glLight(gl, poz, this.numberLight);
                ++this.numberLight;
            }
            if (this.numberLight > 7) break;
        }
    }

    public void disableLights(GL2 gl) {
        int i = 0;
        while (i < 8) {
            int light = 0;
            switch (i) {
                case 0: {
                    light = 16384;
                    break;
                }
                case 1: {
                    light = 16385;
                    break;
                }
                case 2: {
                    light = 16386;
                    break;
                }
                case 3: {
                    light = 16387;
                    break;
                }
                case 4: {
                    light = 16388;
                    break;
                }
                case 5: {
                    light = 16389;
                    break;
                }
                case 6: {
                    light = 16390;
                    break;
                }
                case 7: {
                    light = 16391;
                }
            }
            gl.glDisable(light);
            ++i;
        }
    }

    public void glDrawNoShadow(GL2 gl, float poz) {
        ArrayList<Integer> notdraw = new ArrayList<Integer>();
        for (Entity entity : this.entities) {
            if (!entity.getClass().equals(Group.class)) continue;
            for (Integer i : ((Group)entity).entities) {
                notdraw.add(i);
            }
        }
        gl.glPushMatrix();
        for (Entity entity : this.entities) {
            if (entity.getClass().equals(Light.class) || entity.getClass().equals(Camera.class) || notdraw.contains(entity.getId())) continue;
            entity.glDraw(gl, poz);
        }
        gl.glPopMatrix();
    }

    public Camera getCamera(int i) {
        int u = 0;
        for (Entity e : this.entities) {
            if (!e.getClass().equals(Camera.class)) continue;
            if (u == i) {
                return (Camera)e;
            }
            ++u;
        }
        return null;
    }

    @Override
    public void glDraw(GL2 gl) {
    }

    public Entity getEntityByID(int id) {
        for (Entity e : this.entities) {
            if (e.getId() != id) continue;
            return e;
        }
        return null;
    }
}

