/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;
import javax.media.opengl.GL2;
import model.MyShaderProgram;
import model.Resources;
import obj3d.ObjModel;
import obj3d.Point3D;
import opengl.Renderer;
import scene.Entity;
import util.newId;
import variables.BlendType;
import variables.MyInteger;
import variables.MyLine;
import variables.MyShaderVariable;
import variables.TextureID;
import variables.Toggle;
import variables.Uniform;
import variables.Variable;

public class ParticleSystem
implements Entity {
    private static final long serialVersionUID = 8243984656121185381L;
    private String name = "Paricle System";
    public MyInteger numParticled = new MyInteger("NO of paricles: ", 16000);
    public Point2D position = new Point2D.Double(100.0, 100.0);
    public MyLine pSize = new MyLine("Particle size", 8.0, 64.0);
    public MyLine scale = new MyLine("Scale", 0.3, 10.0);
    public MyLine x = new MyLine("emitter X", 0.0, 10.0);
    public MyLine y = new MyLine("emitter Y", 0.0, 10.0);
    public MyLine z = new MyLine("emitter Z", 0.0, 10.0);
    public MyLine xeS = new MyLine("emit.scale.X", 1.0, 10.0);
    public MyLine yeS = new MyLine("emit.scale.Y", 1.0, 10.0);
    public MyLine zeS = new MyLine("emit.scale.Z", 1.0, 10.0);
    public MyLine gravX = new MyLine("gravity.X", 0.0, 0.1);
    public MyLine gravY = new MyLine("gravity.Y", 0.01, 0.1);
    public MyLine gravZ = new MyLine("gravity.Z", 0.0, 0.1);
    public MyLine speed = new MyLine("speed", 0.05, 0.2);
    public MyLine life = new MyLine("particle life", 10.0, 50.0);
    public MyLine waveAmp = new MyLine("wave amlpitude", 1.0, 10.0);
    public MyLine waveFreq = new MyLine("wave frequency", 1.0, 10.0);
    public MyLine r = new MyLine("Red", 0.8, 1.0);
    public MyLine g = new MyLine("Green", 0.8, 1.0);
    public MyLine b = new MyLine("Blue", 0.8, 1.0);
    public MyLine rAdd = new MyLine("Red add", 0.0, 0.1);
    public MyLine gAdd = new MyLine("Green add", 0.0, 0.1);
    public MyLine bAdd = new MyLine("Blue add", 0.0, 0.1);
    public MyLine alpha = new MyLine("Alpha", 1.0);
    public TextureID textureID = new TextureID();
    public BlendType srcBlendType = new BlendType("Src. blend");
    public BlendType dstBlendType = new BlendType("Dst. blend");
    public Toggle lighting = new Toggle("Lighting");
    public Toggle depthTest = new Toggle("Depth test");
    public MyShaderVariable shader = new MyShaderVariable();
    private MyShaderProgram shaderprogram = null;
    public Toggle SSAOdepthFromShader = new Toggle("SSAO depth from shader");
    public Toggle SSAOnormalFromShader = new Toggle("SSAO normal from shader");
    private int NUM_PARTS = 32768;
    private int NUM_PARTS_PREV = 32768;
    private float[] xp = new float[this.NUM_PARTS];
    private float[] yp = new float[this.NUM_PARTS];
    private float[] zp = new float[this.NUM_PARTS];
    private float[] rcol = new float[this.NUM_PARTS];
    private float[] gcol = new float[this.NUM_PARTS];
    private float[] bcol = new float[this.NUM_PARTS];
    private float[] lifep = new float[this.NUM_PARTS];
    private float ms = 0.0f;
    Calendar cal = Calendar.getInstance();
    private float lastMS = this.cal.getTimeInMillis();
    Random rand = new Random();
    private int id = newId.getNextId();

    public ParticleSystem() {
        int i = 0;
        while (i < this.NUM_PARTS) {
            this.lifep[i] = 0.0f;
            ++i;
        }
    }

    @Override
    public ArrayList<Variable> GetVariables() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.numParticled);
        var.add(this.pSize);
        var.add(this.scale);
        var.add(this.x);
        var.add(this.y);
        var.add(this.z);
        var.add(this.xeS);
        var.add(this.yeS);
        var.add(this.zeS);
        var.add(this.gravX);
        var.add(this.gravY);
        var.add(this.gravZ);
        var.add(this.speed);
        var.add(this.life);
        var.add(this.waveAmp);
        var.add(this.waveFreq);
        var.add(this.r);
        var.add(this.g);
        var.add(this.b);
        var.add(this.rAdd);
        var.add(this.gAdd);
        var.add(this.bAdd);
        var.add(this.alpha);
        var.add(this.textureID);
        var.add(this.srcBlendType);
        var.add(this.dstBlendType);
        var.add(this.lighting);
        var.add(this.depthTest);
        var.add(this.shader);
        return var;
    }

    @Override
    public MyShaderVariable getShader() {
        return this.shader;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D position) {
        this.position = position;
    }

    @Override
    public void glDraw(GL2 gl) {
    }

    private void setUniforms(GL2 gl, float poz, MyShaderProgram shaderprogram) {
        int sampler2DNum = 0;
        for (Uniform uni : this.shader.getUniforms()) {
            if (uni.type.equals("float")) {
                int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                gl.glUniform1f(uloc, (float)(-uni.line.getScaledValue(poz)));
                continue;
            }
            if (uni.type.equals("int")) {
                int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                gl.glUniform1i(uloc, (int)(-uni.line.getScaledValue(poz)));
                continue;
            }
            if (uni.type.equals("sampler2D")) {
                try {
                    int uniformvalue = (int)(-uni.line.getScaledValue(poz));
                    Resources.getInstance().bindNthTexture(uniformvalue);
                    gl.glActiveTexture(33984 + sampler2DNum);
                    gl.glTexParameteri(3553, 10242, 10497);
                    gl.glTexParameteri(3553, 10243, 10497);
                    int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                    gl.glUniform1i(uloc, sampler2DNum);
                }
                catch (Exception uniformvalue) {
                    // empty catch block
                }
                ++sampler2DNum;
                continue;
            }
            if (!uni.type.equals("bool")) continue;
            int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
            gl.glUniform1i(uloc, (int)(-uni.line.getScaledValue(poz)));
        }
    }

    private void doShaderStuff(GL2 gl, float poz) {
        if (this.shader.getID() != 0 && Renderer.getInstance().isUseShaders()) {
            this.shaderprogram = this.shader.getShaderprogram();
            this.shaderprogram.bind(true);
            this.setUniforms(gl, poz, this.shaderprogram);
        }
        if (!Renderer.getInstance().isUseShaders()) {
            Renderer.getInstance().currentShader.bind(true);
        }
        if (!(this.shader.getID() == 0 || Renderer.getInstance().isUseShaders() || Renderer.getInstance().currentShader == null || Renderer.getInstance().renderLayer != Renderer.RENDER_LAYER.DEPTH && Renderer.getInstance().renderLayer != Renderer.RENDER_LAYER.NORMAL)) {
            int uloc;
            this.shaderprogram = this.shader.getShaderprogram();
            this.shaderprogram.bind(true);
            this.setUniforms(gl, poz, this.shaderprogram);
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.NORMAL && this.SSAOnormalFromShader.getBool()) {
                uloc = gl.glGetUniformLocation(this.shaderprogram.getProgramID(), "drawOnlyNormal");
                gl.glUniform1i(uloc, 1);
                uloc = gl.glGetUniformLocation(this.shaderprogram.getProgramID(), "drawOnlyDepth");
                gl.glUniform1i(uloc, 0);
            }
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.NORMAL && !this.SSAOnormalFromShader.getBool()) {
                Renderer.getInstance().currentShader.bind(true);
            }
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.DEPTH && this.SSAOdepthFromShader.getBool()) {
                uloc = gl.glGetUniformLocation(this.shaderprogram.getProgramID(), "drawOnlyNormal");
                gl.glUniform1i(uloc, 0);
                uloc = gl.glGetUniformLocation(this.shaderprogram.getProgramID(), "drawOnlyDepth");
                gl.glUniform1i(uloc, 1);
            }
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.DEPTH && !this.SSAOdepthFromShader.getBool()) {
                Renderer.getInstance().currentShader.bind(true);
            }
        }
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        gl.glColorMaterial(1032, 4609);
        gl.glEnable(2903);
        this.NUM_PARTS = this.numParticled.getInteger();
        if (this.NUM_PARTS_PREV != this.NUM_PARTS) {
            this.xp = new float[this.NUM_PARTS];
            this.yp = new float[this.NUM_PARTS];
            this.zp = new float[this.NUM_PARTS];
            this.rcol = new float[this.NUM_PARTS];
            this.gcol = new float[this.NUM_PARTS];
            this.bcol = new float[this.NUM_PARTS];
            this.lifep = new float[this.NUM_PARTS];
        }
        this.NUM_PARTS_PREV = this.NUM_PARTS;
        try {
            Resources.getInstance().getByID(this.textureID.ID).getTexture().bind(gl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int srcblend = this.srcBlendType.getGLBlendtype();
        int dstblend = this.dstBlendType.getGLBlendtype();
        if (srcblend == -1 || dstblend == -1) {
            gl.glDisable(3042);
        } else {
            if (Renderer.getInstance().isUseShaders()) {
                gl.glEnable(3042);
            }
            gl.glBlendFunc(this.srcBlendType.getGLBlendtype(), this.dstBlendType.getGLBlendtype());
        }
        if (this.lighting.getBool()) {
            gl.glEnable(2896);
        } else {
            gl.glDisable(2896);
        }
        if (this.depthTest.getBool()) {
            gl.glEnable(2929);
        } else {
            gl.glDisable(2929);
        }
        gl.glEnable(3553);
        gl.glEnable(34913);
        gl.glTexEnvi(34913, 34914, 1);
        this.ms += (float)(-this.speed.getScaledValue(poz));
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        float m = (float)Math.sin(this.ms) / 5.0f;
        float wf = (float)this.waveFreq.getScaledValue(poz);
        float wa = (float)this.waveAmp.getScaledValue(poz);
        float lf = (float)(-this.life.getScaledValue(poz));
        float millispassed = this.lastMS - this.ms;
        float gx = (float)(-this.gravX.getScaledValue(poz));
        float gy = (float)(-this.gravY.getScaledValue(poz));
        float gz = (float)(-this.gravZ.getScaledValue(poz));
        float ra = (float)(-this.rAdd.getScaledValue(poz));
        float ga = (float)(-this.gAdd.getScaledValue(poz));
        float ba = (float)(-this.bAdd.getScaledValue(poz));
        float a = (float)(-this.alpha.getScaledValue(poz));
        float size = (float)(-this.pSize.getScaledValue(poz));
        this.doShaderStuff(gl, poz);
        gl.glPushMatrix();
        double scaleValue = -this.scale.getScaledValue(poz);
        gl.glScaled(scaleValue, scaleValue, scaleValue);
        gl.glPointSize(size);
        gl.glBegin(0);
        Point3D nor = new Point3D(0.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < this.NUM_PARTS) {
            if (this.lifep[i] > 0.0f) {
                float xs = (float)Math.sin(this.xp[i] * wf + this.ms) * wa;
                float ys = (float)Math.sin(this.yp[i] * wf + this.ms) * wa;
                float zs = (float)Math.sin(this.zp[i] * wf + this.ms) * wa;
                float xpn = this.xp[i] + (m + ys + zs) / 100.0f;
                float ypn = this.yp[i] + (m + xs + zs) / 100.0f;
                float zpn = this.zp[i] + (m + xs + ys) / 100.0f;
                nor.setX((xpn += gx) - this.xp[i]);
                nor.setY((ypn += gy) - this.yp[i]);
                nor.setZ((zpn += gz) - this.zp[i]);
                ObjModel.normalizeVector(nor);
                int n = i;
                this.rcol[n] = this.rcol[n] + ra;
                int n2 = i;
                this.gcol[n2] = this.gcol[n2] + ga;
                int n3 = i;
                this.bcol[n3] = this.bcol[n3] + ba;
                this.xp[i] = xpn;
                this.yp[i] = ypn;
                this.zp[i] = zpn;
                gl.glNormal3f(nor.getX(), nor.getY(), nor.getZ());
                gl.glColor4f(this.rcol[i], this.gcol[i], this.bcol[i], a);
                gl.glVertex3f(this.xp[i], this.yp[i], this.zp[i]);
                int n4 = i;
                this.lifep[n4] = (float)((double)this.lifep[n4] - 0.1);
            } else {
                this.lifep[i] = lf * this.rand.nextFloat();
                this.xp[i] = (float)(-this.x.getScaledValue(poz) + ((double)this.rand.nextFloat() - 0.5) * this.xeS.getScaledValue(poz));
                this.yp[i] = (float)(-this.y.getScaledValue(poz) + ((double)this.rand.nextFloat() - 0.5) * this.yeS.getScaledValue(poz));
                this.zp[i] = (float)(-this.z.getScaledValue(poz) + ((double)this.rand.nextFloat() - 0.5) * this.zeS.getScaledValue(poz));
                this.rcol[i] = (float)(-this.r.getScaledValue(poz));
                this.gcol[i] = (float)(-this.g.getScaledValue(poz));
                this.bcol[i] = (float)(-this.b.getScaledValue(poz));
            }
            ++i;
        }
        gl.glEnd();
        gl.glPopMatrix();
        gl.glTexEnvi(34913, 34914, 0);
        gl.glDisable(34913);
        if (this.shader.getID() != 0 && Renderer.getInstance().isUseShaders()) {
            this.shaderprogram.bind(false);
        }
        if (this.shader.getID() != 0 && !Renderer.getInstance().isUseShaders() && Renderer.getInstance().currentShader != null) {
            Renderer.getInstance().currentShader.bind(true);
        }
        this.lastMS = this.ms;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setShader(MyShaderVariable var) {
        this.shader = var;
    }
}

