/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import scene.Entity;
import util.newId;
import variables.MyLine;
import variables.MyShaderVariable;
import variables.Variable;

public class Light
implements Entity {
    private static final long serialVersionUID = 8466610302779345663L;
    public Point2D position = new Point2D.Double(100.0, 100.0);
    private String name = "light";
    private int id;
    public MyLine x = new MyLine("X", 0.0, 50.0);
    public MyLine y = new MyLine("Y", 0.0, 50.0);
    public MyLine z = new MyLine("Z", 0.0, 50.0);
    public MyLine ambR = new MyLine("Amb.Red", 0.1, 1.0);
    public MyLine ambG = new MyLine("Amb.Green", 0.1, 1.0);
    public MyLine ambB = new MyLine("Amb.Blue", 0.1, 1.0);
    public MyLine diffR = new MyLine("Diff.Red", 0.8, 1.0);
    public MyLine diffG = new MyLine("Diff.Green", 0.8, 1.0);
    public MyLine diffB = new MyLine("Diff.Blue", 0.8, 1.0);
    public MyLine lightConstAtt = new MyLine("Const attenuation", 1.5, 10.0);
    public MyLine lightLinAtt = new MyLine("Linear attenuation", 1.0, 10.0);
    public MyLine lightQuadAtt = new MyLine("Quadratic attenuation", 0.8, 10.0);

    public Light() {
        this.id = newId.getNextId();
    }

    @Override
    public MyShaderVariable getShader() {
        return null;
    }

    @Override
    public void glDraw(GL2 gl) {
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
    }

    @Override
    public ArrayList<Variable> GetVariables() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.x);
        var.add(this.y);
        var.add(this.z);
        var.add(this.ambR);
        var.add(this.ambG);
        var.add(this.ambB);
        var.add(this.diffR);
        var.add(this.diffG);
        var.add(this.diffB);
        var.add(this.lightConstAtt);
        var.add(this.lightLinAtt);
        var.add(this.lightQuadAtt);
        return var;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void glLight(GL2 gl, float poz, int numberLight) {
        int light = 0;
        switch (numberLight) {
            case 0: {
                light = 16384;
                break;
            }
            case 1: {
                light = 16385;
                break;
            }
            case 2: {
                light = 16386;
                break;
            }
            case 3: {
                light = 16387;
                break;
            }
            case 4: {
                light = 16388;
                break;
            }
            case 5: {
                light = 16389;
                break;
            }
            case 6: {
                light = 16390;
                break;
            }
            case 7: {
                light = 16391;
            }
        }
        float[] lightColor = new float[4];
        float[] lightColorAmb = new float[4];
        float[] lightPos = new float[4];
        float[] spec = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] colorBlack = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        lightColor[0] = -((float)this.diffR.getScaledValue(poz));
        lightColor[1] = -((float)this.diffG.getScaledValue(poz));
        lightColor[2] = -((float)this.diffB.getScaledValue(poz));
        lightColor[3] = 1.0f;
        lightColorAmb[0] = -((float)this.ambR.getScaledValue(poz));
        lightColorAmb[1] = -((float)this.ambG.getScaledValue(poz));
        lightColorAmb[2] = -((float)this.ambB.getScaledValue(poz));
        lightColorAmb[3] = 1.0f;
        lightPos[0] = -((float)this.x.getScaledValue(poz));
        lightPos[1] = -((float)this.y.getScaledValue(poz));
        lightPos[2] = -((float)this.z.getScaledValue(poz));
        lightPos[3] = 1.0f;
        gl.glEnable(light);
        gl.glLightModeli(2897, 1);
        gl.glLightfv(light, 4609, lightColor, 0);
        gl.glLightfv(light, 4608, lightColorAmb, 0);
        gl.glLightfv(light, 4611, lightPos, 0);
        gl.glLightfv(light, 4610, spec, 0);
        gl.glLightf(light, 4615, -((float)this.lightConstAtt.getScaledValue(poz)));
        gl.glLightf(light, 4616, -((float)this.lightLinAtt.getScaledValue(poz)));
        gl.glLightf(light, 4617, -((float)this.lightQuadAtt.getScaledValue(poz)));
    }

    public void glLightDisable(GL2 gl, int numberLight) {
        int light = 0;
        switch (numberLight) {
            case 0: {
                light = 16384;
            }
            case 1: {
                light = 16385;
            }
            case 2: {
                light = 16386;
            }
            case 3: {
                light = 16387;
            }
            case 4: {
                light = 16388;
            }
            case 5: {
                light = 16389;
            }
            case 6: {
                light = 16390;
            }
            case 7: {
                light = 16391;
            }
        }
        gl.glDisable(light);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setShader(MyShaderVariable var) {
    }
}

