/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;
import javax.media.opengl.GL2;
import scene.Entity;
import scene.Scene;
import util.newId;
import variables.ModelID;
import variables.MyLine;
import variables.MyShaderVariable;
import variables.Variable;

public class EntityMultiply
implements Entity {
    private static final long serialVersionUID = 1666750955985193290L;
    private String name = "Multiply";
    public Point2D position = new Point2D.Double(100.0, 100.0);
    private ModelID modelIDFromScene = new ModelID(1);
    public MyLine count = new MyLine("Count", 5.0, 10.0);
    public MyLine countstart = new MyLine("Star count", 0.0, 10.0);
    public MyLine xAdd = new MyLine("X add", 1.0, 10.0);
    public MyLine yAdd = new MyLine("Y add", 0.0, 10.0);
    public MyLine zAdd = new MyLine("Z add", 0.0, 10.0);
    public MyLine xAddRand = new MyLine("X random", 0.0, 10.0);
    public MyLine yAddRand = new MyLine("Y random", 0.0, 10.0);
    public MyLine zAddRand = new MyLine("Z random", 0.0, 10.0);
    public MyLine xRot = new MyLine("X rot", 1.0, 10.0);
    public MyLine yRot = new MyLine("Y rot", 0.0, 10.0);
    public MyLine zRot = new MyLine("Z rot", 0.0, 10.0);
    public MyLine xRotRand = new MyLine("X rot.rnd", 0.0, 10.0);
    public MyLine yRotRand = new MyLine("Y rot.rnd", 0.0, 10.0);
    public MyLine zRotRand = new MyLine("Z rot.rnd", 0.0, 10.0);
    public MyLine xScale = new MyLine("X scale", 1.0, 10.0);
    public MyLine yScale = new MyLine("Y scale", 1.0, 10.0);
    public MyLine zScale = new MyLine("Z scale", 1.0, 10.0);
    public MyLine xScaleRand = new MyLine("X scale.rnd", 0.0, 10.0);
    public MyLine yScaleRand = new MyLine("Y scale.rnd", 0.0, 10.0);
    public MyLine zScaleRand = new MyLine("Z scale.rnd", 0.0, 10.0);
    Random rand;
    private Scene scene = null;
    private Entity model = null;
    private int id;

    public ModelID getModelIDFromScene() {
        return this.modelIDFromScene;
    }

    @Override
    public MyShaderVariable getShader() {
        return null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public EntityMultiply() {
        this.id = newId.getNextId();
    }

    public EntityMultiply(Scene scene) {
        this.scene = scene;
        this.id = newId.getNextId();
    }

    @Override
    public ArrayList<Variable> GetVariables() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.modelIDFromScene);
        var.add(this.count);
        var.add(this.countstart);
        var.add(this.xAdd);
        var.add(this.yAdd);
        var.add(this.zAdd);
        var.add(this.xAddRand);
        var.add(this.yAddRand);
        var.add(this.zAddRand);
        var.add(this.xRot);
        var.add(this.yRot);
        var.add(this.zRot);
        var.add(this.xRotRand);
        var.add(this.yRotRand);
        var.add(this.zRotRand);
        var.add(this.xScale);
        var.add(this.yScale);
        var.add(this.zScale);
        var.add(this.xScaleRand);
        var.add(this.yScaleRand);
        var.add(this.zScaleRand);
        return var;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D position) {
        this.position = position;
    }

    @Override
    public void glDraw(GL2 gl) {
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        if (this.model == null && this.scene != null) {
            for (Entity e : this.scene.entities) {
                if (e.getId() != this.modelIDFromScene.ID) continue;
                this.model = e;
                break;
            }
        }
        float max = (int)(-this.count.getScaledValue(poz));
        float min = (int)(-this.countstart.getScaledValue(poz));
        gl.glPushMatrix();
        double xa = -this.xAdd.getScaledValue(poz);
        double ya = -this.yAdd.getScaledValue(poz);
        double za = -this.zAdd.getScaledValue(poz);
        double xr = -this.xAddRand.getScaledValue(poz);
        double yr = -this.yAddRand.getScaledValue(poz);
        double zr = -this.zAddRand.getScaledValue(poz);
        double xrot = -this.xRot.getScaledValue(poz);
        double yrot = -this.yRot.getScaledValue(poz);
        double zrot = -this.zRot.getScaledValue(poz);
        double xrotR = -this.xRotRand.getScaledValue(poz);
        double yrotR = -this.yRotRand.getScaledValue(poz);
        double zrotR = -this.zRotRand.getScaledValue(poz);
        double xscale = -this.xScale.getScaledValue(poz);
        double yscale = -this.yScale.getScaledValue(poz);
        double zscale = -this.zScale.getScaledValue(poz);
        double xscaleR = -this.xScaleRand.getScaledValue(poz);
        double yscaleR = -this.yScaleRand.getScaledValue(poz);
        double zscaleR = -this.zScaleRand.getScaledValue(poz);
        this.rand = new Random(55L);
        if (this.model != null) {
            float i = 0.0f;
            while (i < max) {
                gl.glTranslated(xa, ya, za);
                gl.glRotated(xrot, 1.0, 0.0, 0.0);
                gl.glRotated(yrot, 0.0, 1.0, 0.0);
                gl.glRotated(zrot, 0.0, 0.0, 1.0);
                gl.glScaled(xscale, yscale, zscale);
                gl.glPushMatrix();
                gl.glRotated(xrotR * this.rand.nextDouble() - xrotR / 2.0, 1.0, 0.0, 0.0);
                gl.glRotated(yrotR * this.rand.nextDouble() - yrotR / 2.0, 0.0, 1.0, 0.0);
                gl.glRotated(zrotR * this.rand.nextDouble() - zrotR / 2.0, 0.0, 0.0, 1.0);
                gl.glScaled(1.0 + xscaleR * (double)this.rand.nextFloat() - xscaleR / 2.0, 1.0 + yscaleR * (double)this.rand.nextFloat() - yscaleR / 2.0, 1.0 + zscaleR * (double)this.rand.nextFloat() - zscaleR / 2.0);
                gl.glTranslated(xr * this.rand.nextDouble() - xr / 2.0, yr * this.rand.nextDouble() - yr / 2.0, zr * this.rand.nextDouble() - zr / 2.0);
                if (i >= min) {
                    this.model.glDraw(gl, poz);
                }
                gl.glPopMatrix();
                i += 1.0f;
            }
        }
        gl.glPopMatrix();
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setShader(MyShaderVariable var) {
    }
}

