/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import model.MyShaderProgram;
import model.Resources;
import opengl.Renderer;
import scene.Entity;
import util.newId;
import variables.BlendType;
import variables.ModelID;
import variables.MyLine;
import variables.MyShaderVariable;
import variables.TexGenMode;
import variables.TextureID;
import variables.Toggle;
import variables.Uniform;
import variables.Variable;

public class EntityModel
implements Entity {
    private static final long serialVersionUID = -9060231092792822603L;
    private int id;
    private ModelID modelNumId = new ModelID(0);
    private String name = "entity";
    public Point2D position = new Point2D.Double(100.0, 100.0);
    public MyLine x = new MyLine("X", 0.0, 10.0);
    public MyLine y = new MyLine("Y", 0.0, 10.0);
    public MyLine z = new MyLine("Z", 0.0, 10.0);
    public MyLine rotx = new MyLine("rot.X", 0.0, 180.0);
    public MyLine roty = new MyLine("rot.Y", 0.0, 180.0);
    public MyLine rotz = new MyLine("rot.Z", 0.0, 180.0);
    public MyLine sx = new MyLine("scale.X", 1.0, 5.0);
    public MyLine sy = new MyLine("scale.Y", 1.0, 5.0);
    public MyLine sz = new MyLine("scale.Z", 1.0, 5.0);
    public MyLine colR = new MyLine("Red", 1.0);
    public MyLine colG = new MyLine("Green", 1.0);
    public MyLine colB = new MyLine("Blue", 1.0);
    public MyLine colA = new MyLine("Alpha", 1.0);
    public MyLine specular = new MyLine("Specular", 1.0);
    public MyLine shine = new MyLine("Shininess", 55.0, 128.0);
    public BlendType srcBlendType = new BlendType("Src. blend");
    public BlendType dstBlendType = new BlendType("Dst. blend", BlendType.TYPE.SRC_ALPHA);
    public Toggle depthTest = new Toggle("Depth test");
    public Toggle cullface = new Toggle("Cull face");
    public Toggle lighting = new Toggle("Lighting");
    public Toggle texturemapping = new Toggle("Texturemapping");
    public Toggle smoothshading = new Toggle("Smooth");
    public TextureID textureID = new TextureID();
    public TexGenMode texGenMode = new TexGenMode();
    public MyLine textureTX = new MyLine("Tex.transl.X", 0.0, 1.0);
    public MyLine textureTY = new MyLine("Tex.transl.Y", 0.0, 1.0);
    public MyLine textureSX = new MyLine("Tex.scale.X", 1.0);
    public MyLine textureSY = new MyLine("Tex.scale.Y", 1.0);
    public MyShaderVariable shader = new MyShaderVariable();
    public Toggle SSAOdepthFromShader = new Toggle("SSAO depth from shader");
    public Toggle SSAOnormalFromShader = new Toggle("SSAO normal from shader");
    public int modelID = 0;

    @Override
    public int getId() {
        return this.id;
    }

    public EntityModel() {
        this.id = newId.getNextId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D position) {
        this.position = position;
    }

    private void setUniforms(GL2 gl, float poz, MyShaderProgram shaderprogram) {
        int sampler2DNum = 0;
        for (Uniform uni : this.shader.getUniforms()) {
            if (uni.type.equals("float")) {
                int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                gl.glUniform1f(uloc, (float)(-uni.line.getScaledValue(poz)));
                continue;
            }
            if (uni.type.equals("int")) {
                int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                gl.glUniform1i(uloc, (int)(-uni.line.getScaledValue(poz)));
                continue;
            }
            if (uni.type.equals("sampler2D")) {
                try {
                    int uniformvalue = (int)(-uni.line.getScaledValue(poz));
                    Object tex = null;
                    gl.glActiveTexture(33984 + sampler2DNum);
                    Resources.getInstance().bindNthTexture(uniformvalue);
                    gl.glTexParameteri(3553, 10242, 10497);
                    gl.glTexParameteri(3553, 10243, 10497);
                    int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
                    gl.glUniform1i(uloc, sampler2DNum);
                }
                catch (Exception uniformvalue) {
                    // empty catch block
                }
                ++sampler2DNum;
                continue;
            }
            if (!uni.type.equals("bool")) continue;
            int uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), uni.name.trim());
            gl.glUniform1i(uloc, (int)(-uni.line.getScaledValue(poz)));
        }
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        gl.glPushAttrib(1048575);
        gl.glColorMaterial(1032, 4609);
        gl.glEnable(2903);
        float s = -((float)this.specular.getScaledValue(poz));
        float[] whiteSpecularMaterial = new float[]{s, s, s, s};
        gl.glMaterialfv(1028, 4610, whiteSpecularMaterial, 1);
        gl.glMaterialf(1032, 5633, -((float)this.shine.getScaledValue(poz)));
        gl.glPushMatrix();
        double alpha = 0.0;
        double xp = -this.x.getScaledValue(poz);
        double yp = -this.y.getScaledValue(poz);
        double zp = -this.z.getScaledValue(poz);
        gl.glTranslated(xp, yp, zp);
        xp = -this.rotx.getScaledValue(poz);
        yp = -this.roty.getScaledValue(poz);
        zp = -this.rotz.getScaledValue(poz);
        gl.glRotated(xp, 1.0, 0.0, 0.0);
        gl.glRotated(yp, 0.0, 1.0, 0.0);
        gl.glRotated(zp, 0.0, 0.0, 1.0);
        xp = -this.sx.getScaledValue(poz);
        yp = -this.sy.getScaledValue(poz);
        zp = -this.sz.getScaledValue(poz);
        gl.glScaled(xp, yp, zp);
        double r = -this.colR.getScaledValue(poz);
        double g = -this.colG.getScaledValue(poz);
        double b = -this.colB.getScaledValue(poz);
        alpha = -this.colA.getScaledValue(poz);
        gl.glColor4d(r, g, b, alpha);
        int srcblend = this.srcBlendType.getGLBlendtype();
        int dstblend = this.dstBlendType.getGLBlendtype();
        if (srcblend == -1 || dstblend == -1) {
            gl.glDisable(3042);
        } else {
            if (Renderer.getInstance().isUseShaders()) {
                gl.glEnable(3042);
            }
            gl.glBlendFunc(this.srcBlendType.getGLBlendtype(), this.dstBlendType.getGLBlendtype());
        }
        if (this.depthTest.getBool()) {
            gl.glEnable(2929);
        } else {
            gl.glDisable(2929);
        }
        if (this.cullface.getBool()) {
            gl.glEnable(2884);
        } else {
            gl.glDisable(2884);
        }
        if (this.texturemapping.getBool()) {
            gl.glEnable(3553);
        } else {
            gl.glDisable(3553);
        }
        if (this.lighting.getBool()) {
            gl.glEnable(2896);
        } else {
            gl.glDisable(2896);
        }
        if (this.smoothshading.getBool()) {
            gl.glShadeModel(7425);
        } else {
            gl.glShadeModel(7424);
        }
        MyShaderProgram shaderprogram = null;
        if (this.shader.getID() != 0 && Renderer.getInstance().isUseShaders()) {
            shaderprogram = this.shader.getShaderprogram();
            shaderprogram.bind(true);
            this.setUniforms(gl, poz, shaderprogram);
        }
        if (!Renderer.getInstance().isUseShaders()) {
            Renderer.getInstance().currentShader.bind(true);
        }
        if (!(this.shader.getID() == 0 || Renderer.getInstance().isUseShaders() || Renderer.getInstance().currentShader == null || Renderer.getInstance().renderLayer != Renderer.RENDER_LAYER.DEPTH && Renderer.getInstance().renderLayer != Renderer.RENDER_LAYER.NORMAL)) {
            int uloc;
            shaderprogram = this.shader.getShaderprogram();
            shaderprogram.bind(true);
            this.setUniforms(gl, poz, shaderprogram);
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.NORMAL && this.SSAOnormalFromShader.getBool()) {
                uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), "drawOnlyNormal");
                gl.glUniform1i(uloc, 1);
                uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), "drawOnlyDepth");
                gl.glUniform1i(uloc, 0);
            }
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.NORMAL && !this.SSAOnormalFromShader.getBool()) {
                Renderer.getInstance().currentShader.bind(true);
            }
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.DEPTH && this.SSAOdepthFromShader.getBool()) {
                uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), "drawOnlyNormal");
                gl.glUniform1i(uloc, 0);
                uloc = gl.glGetUniformLocation(shaderprogram.getProgramID(), "drawOnlyDepth");
                gl.glUniform1i(uloc, 1);
            }
            if (Renderer.getInstance().renderLayer == Renderer.RENDER_LAYER.DEPTH && !this.SSAOdepthFromShader.getBool()) {
                Renderer.getInstance().currentShader.bind(true);
            }
        }
        gl.glMatrixMode(5890);
        gl.glPushMatrix();
        gl.glTranslated(-this.textureTX.getScaledValue(poz), -this.textureTY.getScaledValue(poz), 0.0);
        gl.glScaled(-this.textureSX.getScaledValue(poz), -this.textureSY.getScaledValue(poz), 0.0);
        gl.glMatrixMode(5888);
        try {
            Resources.getInstance().getByID(this.textureID.ID).getTexture().bind(gl);
            if (this.texGenMode.mode == 1) {
                gl.glTexGeni(8192, 9472, 9218);
                gl.glTexGeni(8193, 9472, 9218);
            }
            if (this.texGenMode.mode == 2) {
                gl.glTexGeni(8192, 9472, 9217);
                gl.glTexGeni(8193, 9472, 9217);
            }
            if (this.texGenMode.mode == 3) {
                gl.glTexGeni(8192, 9472, 9217);
                gl.glTexGeni(8193, 9472, 9217);
            }
            if (this.texGenMode.mode == 4) {
                gl.glTexGeni(8192, 9472, 9217);
                gl.glTexGeni(8193, 9472, 9217);
            }
            if (this.texGenMode.mode >= 1 && this.texGenMode.mode <= 4) {
                gl.glEnable(3168);
                gl.glEnable(3169);
            }
            if (this.texGenMode.mode == 0) {
                gl.glDisable(3168);
                gl.glDisable(3169);
            }
        }
        catch (NullPointerException e) {
            gl.glDisable(3553);
        }
        gl.glPushMatrix();
        try {
            Resources.getInstance().getByID(this.modelNumId.ID).getModel().glDraw(gl);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.shader.getID() != 0 && Renderer.getInstance().isUseShaders()) {
            shaderprogram.bind(false);
        }
        if (this.shader.getID() != 0 && !Renderer.getInstance().isUseShaders() && Renderer.getInstance().currentShader != null) {
            Renderer.getInstance().currentShader.bind(true);
        }
        gl.glPopMatrix();
        gl.glMatrixMode(5890);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glPopAttrib();
    }

    @Override
    public void glDraw(GL2 gl) {
    }

    @Override
    public ArrayList<Variable> GetVariables() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.modelNumId);
        var.add(this.x);
        var.add(this.y);
        var.add(this.z);
        var.add(this.rotx);
        var.add(this.roty);
        var.add(this.rotz);
        var.add(this.sx);
        var.add(this.sy);
        var.add(this.sz);
        var.add(this.colR);
        var.add(this.colG);
        var.add(this.colB);
        var.add(this.colA);
        var.add(this.specular);
        var.add(this.shine);
        var.add(this.srcBlendType);
        var.add(this.dstBlendType);
        var.add(this.depthTest);
        var.add(this.cullface);
        var.add(this.lighting);
        var.add(this.texturemapping);
        var.add(this.textureID);
        var.add(this.texGenMode);
        var.add(this.textureTX);
        var.add(this.textureTY);
        var.add(this.textureSX);
        var.add(this.textureSY);
        var.add(this.smoothshading);
        var.add(this.shader);
        var.add(this.SSAOdepthFromShader);
        var.add(this.SSAOnormalFromShader);
        return var;
    }

    @Override
    public MyShaderVariable getShader() {
        return this.shader;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setShader(MyShaderVariable var) {
        if (var != null) {
            this.shader = var;
        }
    }
}

