/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import scene.Entity;
import scene.EntityModel;
import scene.Scene;
import util.newId;
import variables.ModelID;
import variables.MyLine;
import variables.MyShaderVariable;
import variables.Variable;

public class CameraLookat
implements Entity {
    private static final long serialVersionUID = -2602404789167319287L;
    transient GLU glu = null;
    private int id;
    private String name = "Camera-Lookat";
    private ModelID modelIDFromScene = new ModelID(1);
    private MyLine x = new MyLine("X", 0.0, 10.0);
    private MyLine y = new MyLine("Y", 0.0, 10.0);
    private MyLine z = new MyLine("Z", -5.0, 10.0);
    private MyLine rotx = new MyLine("eye.up.X", 0.0, 1.0);
    private MyLine roty = new MyLine("eye.up.Y", 1.0, 1.0);
    private MyLine rotz = new MyLine("eye.up.Z", 0.0, 1.0);
    private MyLine fov = new MyLine("FOV", 45.0, 120.0);
    public Point2D position = new Point2D.Double(100.0, 100.0);
    private Scene scene = null;
    private EntityModel model = null;

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public MyShaderVariable getShader() {
        return null;
    }

    public CameraLookat(Scene scene) {
        this.id = newId.getNextId();
        this.scene = scene;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public ArrayList<Variable> GetVariables() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.modelIDFromScene);
        var.add(this.x);
        var.add(this.y);
        var.add(this.z);
        var.add(this.rotx);
        var.add(this.roty);
        var.add(this.rotz);
        var.add(this.fov);
        return var;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D position) {
        this.position = position;
    }

    @Override
    public void glDraw(GL2 gl) {
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
    }

    public void Push(GL2 gl, float poz) {
        if (this.model == null && this.scene != null) {
            for (Entity e : this.scene.entities) {
                if (!e.getClass().equals(EntityModel.class) || ((EntityModel)e).getId() != this.modelIDFromScene.ID) continue;
                this.model = (EntityModel)e;
                break;
            }
        }
        if (this.glu == null) {
            this.glu = GLU.createGLU((GL)gl);
        }
        double xrot = -this.rotx.getScaledValue(poz);
        double yrot = -this.roty.getScaledValue(poz);
        double zrot = -this.rotz.getScaledValue(poz);
        double xt = -this.x.getScaledValue(poz);
        double yt = -this.y.getScaledValue(poz);
        double zt = -this.z.getScaledValue(poz);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(-this.fov.getScaledValue(poz), 1.7777777910232544, (double)0.01f, 1000.0);
        gl.glMatrixMode(5888);
        if (this.model != null) {
            this.glu.gluLookAt(xt, yt, zt, -this.model.x.getScaledValue(poz), -this.model.y.getScaledValue(poz), -this.model.z.getScaledValue(poz), xrot, yrot, zrot);
        } else {
            this.glu.gluLookAt(xt, yt, zt, 0.0, 0.0, 0.0, xrot, yrot, zrot);
        }
        gl.glPushMatrix();
    }

    public void Pop(GL2 gl) {
        gl.glPopMatrix();
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setShader(MyShaderVariable var) {
    }
}

