/*
 * Decompiled with CFR 0.152.
 */
package obj3d;

import interfaces.OpenGLDrawable;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.media.opengl.GL2;
import javax.swing.JOptionPane;
import obj3d.Point3D;
import obj3d.Triangle;

public class ObjModel
implements OpenGLDrawable,
Serializable {
    private static final long serialVersionUID = -4385683998142701111L;
    transient int displayList = 0;
    boolean hasnormals = false;
    boolean hastexcoords = false;
    ArrayList<Point3D> verts = new ArrayList();
    ArrayList<Point2D> texcoords = new ArrayList();
    ArrayList<Point3D> normals = new ArrayList();
    ArrayList<Point3D> smoothnormals = new ArrayList();
    ArrayList<Triangle> triangles = new ArrayList();

    public ObjModel(String fileName) {
        try {
            this.load(fileName);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error occured. Note: models should contain normals.", "Load error", 0);
        }
    }

    public static Point3D normalizeVector(Point3D vec) {
        float dist = vec.getX() * vec.getX() + vec.getY() * vec.getY() + vec.getZ() * vec.getZ();
        vec.setX(vec.getX() / dist);
        vec.setY(vec.getY() / dist);
        vec.setZ(vec.getZ() / dist);
        return vec;
    }

    private void calcflatnormals() {
        System.out.println("calculating flat normals");
        for (Triangle tri : this.triangles) {
            try {
                Point3D n = new Point3D(0.0f, 0.0f, 0.0f);
                float[] a1 = new float[3];
                float[] a2 = new float[3];
                Point3D v1 = this.verts.get(tri.vertIndexes[0]);
                Point3D v2 = this.verts.get(tri.vertIndexes[1]);
                Point3D v3 = this.verts.get(tri.vertIndexes[2]);
                a1[0] = v1.getX() - v2.getX();
                a1[1] = v1.getY() - v2.getY();
                a1[2] = v1.getZ() - v2.getZ();
                a2[0] = v2.getX() - v3.getX();
                a2[1] = v2.getY() - v3.getY();
                a2[2] = v2.getZ() - v3.getZ();
                float x = a1[1] * a2[2] - a1[2] * a2[1];
                float y = a1[2] * a2[0] - a1[0] * a2[2];
                float z = a1[0] * a2[1] - a1[1] * a2[0];
                n.setX(x);
                n.setY(y);
                n.setZ(z);
                tri.norIndexes[0] = this.normals.size() + 1;
                tri.norIndexes[1] = this.normals.size() + 1;
                tri.norIndexes[2] = this.normals.size() + 1;
                this.normals.add(ObjModel.normalizeVector(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void normalize() {
        float max = -999.0f;
        for (Point3D v : this.verts) {
            float x = Math.abs(v.getX());
            float y = Math.abs(v.getY());
            float z = Math.abs(v.getZ());
            if (x > max) {
                max = x;
            }
            if (y > max) {
                max = y;
            }
            if (!(z > max)) continue;
            max = z;
        }
        for (Point3D v : this.verts) {
            v.setX(v.getX() / max);
            v.setY(v.getY() / max);
            v.setZ(v.getZ() / max);
        }
    }

    @Override
    public void glDraw(GL2 gl) {
        if (this.displayList == 0) {
            System.out.println("aaaaaaaaaaaaaaaaaaaa");
            gl.getContext().makeCurrent();
            this.displayList = gl.glGenLists(1);
            System.out.println("bbbbbbbbbbbbbbbbbbbb");
            gl.glNewList(this.displayList, 4864);
            gl.glBegin(4);
            for (Triangle tri : this.triangles) {
                int i = 0;
                while (i < 3) {
                    int a = tri.vertIndexes[i];
                    int n = tri.norIndexes[i];
                    int t = tri.texIndexes[i];
                    try {
                        Point2D texc = this.texcoords.get(t - 1);
                        gl.glTexCoord2d((double)((float)texc.getX()), (double)((float)texc.getY()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Point3D nor = this.normals.get(n - 1);
                        gl.glNormal3f(nor.getX(), nor.getY(), nor.getZ());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Point3D ap = this.verts.get(a);
                        gl.glVertex3f(ap.getX(), ap.getY(), ap.getZ());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            gl.glEnd();
            gl.glEndList();
        } else {
            gl.glCallList(this.displayList);
        }
    }

    public void glDrawSmoothNormals(GL2 gl) {
        boolean yyy = false;
        gl.glBegin(4);
        int j = 0;
        for (Triangle tri : this.triangles) {
            int i = 0;
            while (i < 3) {
                int a = tri.vertIndexes[i];
                try {
                    Point3D nor = this.smoothnormals.get(j);
                    gl.glNormal3f(nor.getX(), nor.getY(), nor.getZ());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Point3D ap = this.verts.get(a);
                    gl.glVertex3f(ap.getX(), ap.getY(), ap.getZ());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
                ++i;
            }
        }
        gl.glEnd();
    }

    private int[] getPoint(String str) {
        int[] res;
        int b = 0;
        Integer c = null;
        StringTokenizer st = new StringTokenizer(str);
        str = st.nextToken("/");
        int a = Integer.parseInt(str);
        try {
            str = st.nextToken("/");
            b = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            str = st.nextToken("/");
            c = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            res = new int[]{a, b};
            return res;
        }
        res = new int[]{a, b, c};
        return res;
    }

    protected static int parseInt(String val) {
        if (val.length() == 0) {
            return -1;
        }
        return Integer.parseInt(val);
    }

    protected static int[] parseIntTriple(String face) {
        int ix = face.indexOf("/");
        if (ix == -1) {
            return new int[]{Integer.parseInt(face)};
        }
        int ix2 = face.indexOf("/", ix + 1);
        if (ix2 == -1) {
            return new int[]{Integer.parseInt(face.substring(0, ix)), Integer.parseInt(face.substring(ix + 1))};
        }
        return new int[]{ObjModel.parseInt(face.substring(0, ix)), ObjModel.parseInt(face.substring(ix + 1, ix2)), ObjModel.parseInt(face.substring(ix2 + 1))};
    }

    public void load(String filename) throws NumberFormatException, IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String line = "";
        boolean mode = false;
        while ((line = reader.readLine()) != null) {
            Point3D point;
            float z;
            float y;
            float x;
            StringTokenizer st;
            char c;
            if ((line = line.trim()).length() <= 2 || (c = line.charAt(0)) == '#') continue;
            if (c == 'v' && line.charAt(1) == ' ') {
                st = new StringTokenizer(line);
                line = st.nextToken();
                line = st.nextToken();
                x = Float.parseFloat(line);
                line = st.nextToken();
                y = Float.parseFloat(line);
                line = st.nextToken();
                z = Float.parseFloat(line);
                point = new Point3D(x, y, z);
                this.verts.add(point);
            }
            if (line.length() > 2 && c == 'v' && line.charAt(1) == 't') {
                st = new StringTokenizer(line);
                line = st.nextToken();
                line = st.nextToken();
                float u = Float.parseFloat(line);
                line = st.nextToken();
                float v = Float.parseFloat(line);
                Point2D.Float point2 = new Point2D.Float(u, 1.0f - v);
                this.texcoords.add(point2);
            }
            if (line.length() > 2 && c == 'v' && line.charAt(1) == 'n') {
                this.hasnormals = true;
                st = new StringTokenizer(line);
                line = st.nextToken();
                line = st.nextToken();
                x = Float.parseFloat(line);
                line = st.nextToken();
                y = Float.parseFloat(line);
                line = st.nextToken();
                z = Float.parseFloat(line);
                point = new Point3D(x, y, z);
                this.normals.add(ObjModel.normalizeVector(point));
            }
            if (c != 'f') continue;
            StringTokenizer tok = new StringTokenizer(line);
            tok.nextToken();
            Triangle tri = new Triangle();
            int[] fpoints = ObjModel.parseIntTriple(tok.nextToken());
            if (fpoints.length > 0 && fpoints[0] > -2) {
                tri.vertIndexes[0] = fpoints[0] - 1;
            }
            if (fpoints.length > 2 && fpoints[2] > -2) {
                tri.norIndexes[0] = fpoints[2];
            }
            if (fpoints.length > 1) {
                tri.texIndexes[0] = fpoints[1];
            }
            if ((fpoints = ObjModel.parseIntTriple(tok.nextToken())).length > 0 && fpoints[0] > -2) {
                tri.vertIndexes[1] = fpoints[0] - 1;
            }
            if (fpoints.length > 2 && fpoints[2] > -2) {
                tri.norIndexes[1] = fpoints[2];
            }
            if (fpoints.length > 1) {
                tri.texIndexes[1] = fpoints[1];
            }
            if (tok.hasMoreTokens()) {
                fpoints = ObjModel.parseIntTriple(tok.nextToken());
                if (fpoints.length > 2 && fpoints[0] > -2) {
                    tri.vertIndexes[2] = fpoints[0] - 1;
                }
                if (fpoints.length > 2 && fpoints[2] > -2) {
                    tri.norIndexes[2] = fpoints[2];
                }
                if (fpoints.length > 2) {
                    tri.texIndexes[2] = fpoints[1];
                }
            }
            this.triangles.add(tri);
            if (!tok.hasMoreTokens()) continue;
            Triangle tri2 = new Triangle();
            fpoints = ObjModel.parseIntTriple(tok.nextToken());
            if (fpoints.length > 2 && fpoints[0] > -2) {
                tri2.vertIndexes[2] = fpoints[0] - 1;
            }
            if (fpoints.length > 2 && fpoints[2] > -2) {
                tri2.norIndexes[2] = fpoints[2];
            }
            if (fpoints.length > 2) {
                tri2.texIndexes[2] = fpoints[1];
            }
            tri2.vertIndexes[0] = tri.vertIndexes[0];
            tri2.norIndexes[0] = tri.norIndexes[0];
            tri2.texIndexes[0] = tri.texIndexes[0];
            tri2.vertIndexes[1] = tri.vertIndexes[2];
            tri2.norIndexes[1] = tri.norIndexes[2];
            tri2.texIndexes[1] = tri.texIndexes[2];
            this.triangles.add(tri2);
        }
        this.normalize();
        if (!this.hasnormals) {
            this.calcflatnormals();
        }
    }

    private void getFacesFromLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        int numpoints = 0;
        boolean cont = false;
        Triangle tri = new Triangle();
        while (st.hasMoreTokens()) {
            int n;
            int t;
            int v;
            StringTokenizer st2;
            String s = st.nextToken();
            cont = true;
            if (s.contains("// ")) {
                st2 = new StringTokenizer(s);
                v = Integer.parseInt(st2.nextToken("//"));
                t = Integer.parseInt(st2.nextToken("//"));
                n = Integer.parseInt(st2.nextToken("//"));
                tri.vertIndexes[numpoints] = v;
                tri.texIndexes[numpoints] = t;
                tri.norIndexes[numpoints] = n;
                ++numpoints;
                if (!this.hasnormals) {
                    this.hasnormals = true;
                }
                cont = false;
                continue;
            }
            if (s.contains("//")) {
                st2 = new StringTokenizer(s);
                v = Integer.parseInt(st.nextToken("//").trim());
                int n2 = Integer.parseInt(st.nextToken("//").trim());
                tri.vertIndexes[numpoints] = v;
                tri.norIndexes[numpoints] = n2;
                ++numpoints;
                if (this.hasnormals) continue;
                this.hasnormals = true;
                continue;
            }
            if (s.contains("/")) {
                st2 = new StringTokenizer(s);
                v = Integer.parseInt(st2.nextToken("/"));
                t = Integer.parseInt(st2.nextToken("/"));
                n = 0;
                try {
                    n = Integer.parseInt(st2.nextToken("/"));
                }
                catch (NoSuchElementException e) {
                    this.hasnormals = false;
                }
                tri.vertIndexes[numpoints] = v;
                tri.texIndexes[numpoints] = t;
                tri.norIndexes[numpoints] = n;
                if (!this.hasnormals) {
                    this.hasnormals = true;
                }
                if (!this.hastexcoords) {
                    this.hastexcoords = true;
                }
                ++numpoints;
                continue;
            }
            if (numpoints > 3 || s.contains("f")) continue;
            tri.vertIndexes[numpoints] = Integer.parseInt(s.trim());
            ++numpoints;
        }
        this.triangles.add(tri);
        if (numpoints == 4) {
            Triangle tri2 = new Triangle();
            tri2.vertIndexes[0] = tri.vertIndexes[0];
            tri2.vertIndexes[1] = tri.vertIndexes[2];
            tri2.vertIndexes[2] = tri.vertIndexes[3];
            if (this.hasnormals) {
                tri2.norIndexes[0] = tri.norIndexes[0];
                tri2.norIndexes[1] = tri.norIndexes[2];
                tri2.norIndexes[2] = tri.norIndexes[3];
            }
            if (this.hastexcoords) {
                tri2.texIndexes[0] = tri.texIndexes[0];
                tri2.texIndexes[1] = tri.texIndexes[2];
                tri2.texIndexes[2] = tri.texIndexes[3];
            }
            this.triangles.add(tri2);
        }
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        this.glDraw(gl);
    }
}

