/*
 * Decompiled with CFR 0.152.
 */
package model;

import gui.App;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.media.opengl.GL2;
import model.MyShaderProgram;
import model.Resource;
import model.Resources;
import opengl.Renderer;
import scene.Scene;
import timeline.TimeEntity;
import timeline.TimeEntityMasterAudio;
import timeline.TimeLine;

public class Project {
    public int tool = 1;
    private static Project instance = null;
    ArrayList<Scene> scenes = new ArrayList();

    public static Project getInstance() {
        if (instance == null) {
            instance = new Project();
        }
        return instance;
    }

    public Scene getSceneByID(int id) {
        for (Scene s : this.scenes) {
            if (s.getId() != id) continue;
            return s;
        }
        return null;
    }

    public ArrayList<Scene> getScenes() {
        return this.scenes;
    }

    public void LoadProject(String filename) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(filename);
        ObjectInputStream in = new ObjectInputStream(fis);
        ArrayList r = new ArrayList();
        r = (ArrayList)in.readObject();
        Resources.getInstance().setResources(r);
        this.scenes = (ArrayList)in.readObject();
        Renderer.getInstance().setShaders((ArrayList)in.readObject());
        ArrayList te = (ArrayList)in.readObject();
        TimeLine.getInstance().setEntities(te);
        in.close();
        this.initAfterLoading();
        for (TimeEntity tt : TimeLine.getInstance().getEntities()) {
            if (!tt.getClass().equals(TimeEntityMasterAudio.class)) continue;
            TimeEntityMasterAudio ma = (TimeEntityMasterAudio)tt;
            ma.reloadMusic();
            TimeLine.getInstance().setMasterAudio(ma);
            String str = null;
            System.out.println("MASTER AUDIO");
            try {
                File f = new File(ma.filename.getFilename());
                if (!f.exists()) {
                    System.out.println("not exists");
                    StringTokenizer st = new StringTokenizer(ma.filename.getFilename(), "\\");
                    while (st.hasMoreTokens()) {
                        str = st.nextToken();
                    }
                    String parent = new File(filename).getParent();
                    if (parent != null) {
                        str = String.valueOf(parent) + "\\" + str;
                    }
                    System.out.println(str);
                    ma.filename.setFilename(str);
                }
                ma.reloadMusic();
                if (App.frame == null) {
                    ma.playMusic();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(ma.filename.getFilename());
        }
    }

    public void SaveProject(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(Resources.getInstance().getResources());
        out.writeObject(Project.getInstance().scenes);
        out.writeObject(Renderer.getInstance().getShaders());
        out.writeObject(TimeLine.getInstance().getEntities());
        out.writeObject(TimeLine.getInstance().getMasterAudio());
        out.close();
    }

    public void initAfterLoading() {
        System.out.println("initAfterLoading");
        Renderer.getInstance().CreateShaders();
        System.out.println("shaders created. compiling...");
        for (MyShaderProgram sp : Renderer.getInstance().getShaders()) {
            System.out.println("compiling " + sp.getId() + " " + sp.getName());
            if (!sp.enabled) continue;
            sp.compile();
        }
        System.out.println("shaders  compiled");
        for (Resource r : Resources.getInstance().getResources()) {
            System.out.println(r.getName());
            if (r.getTexture() != null) {
                try {
                    r.getTexture().initIfNull();
                }
                catch (IOException e) {
                    System.out.println("Error initializing resource " + r.getName());
                }
            }
            if (r.getModel() == null) continue;
            r.getModel().glDraw((GL2)Renderer.getInstance().gLAutoDrawable.getGL());
        }
    }
}

