/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.media.opengl.GL2;
import model.Resource;
import opengl.Renderer;
import variables.MyLine;
import variables.Uniform;

public class MyShaderProgram
extends Resource {
    private static final long serialVersionUID = -5758964977933249901L;
    public boolean enabled;
    private int vertSH = 0;
    private int fragSH = 0;
    private int shaderprogram = 0;
    transient GL2 gl = null;
    private String infoLog = "";
    private ArrayList<Uniform> uniforms = new ArrayList();
    private String vertString;
    private String fragString;

    public int getProgramID() {
        return this.shaderprogram;
    }

    public String toString() {
        return this.getName();
    }

    public ArrayList<Uniform> getUniforms() {
        for (Uniform u : this.uniforms) {
            Uniform uuu = new Uniform();
            uuu.line = new MyLine();
            uuu.name = u.name;
            uuu.type = u.type;
        }
        return this.uniforms;
    }

    public void setUniforms(ArrayList<Uniform> uniforms) {
        this.uniforms = uniforms;
    }

    public String getInfoLog() {
        return this.infoLog;
    }

    private void readUniforms(String str) {
        StringTokenizer mainSt = new StringTokenizer(str, ";");
        while (mainSt.hasMoreTokens()) {
            String line = mainSt.nextToken();
            StringTokenizer st = new StringTokenizer(line);
            String first = st.nextToken(" ");
            if (first.trim().equals("void")) {
                return;
            }
            if (!first.trim().equals("uniform")) continue;
            String type = st.nextToken(" ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken(",");
                Uniform uni = new Uniform();
                uni.type = type.trim();
                uni.name = token.trim();
                this.uniforms.add(uni);
            }
        }
    }

    public MyShaderProgram() {
        this.gl = Renderer.getInstance().getGL2();
        this.vertSH = this.gl.glCreateShader(35633);
        this.fragSH = this.gl.glCreateShader(35632);
        this.shaderprogram = this.gl.glCreateProgram();
        this.gl.glAttachShader(this.shaderprogram, this.vertSH);
        this.gl.glAttachShader(this.shaderprogram, this.fragSH);
        this.vertString = this.loadShader("shaders/simple.vert");
        this.fragString = this.loadShader("shaders/simple.frag");
    }

    public MyShaderProgram(String vs, String fs) {
        this.gl = Renderer.getInstance().getGL2();
        this.vertSH = this.gl.glCreateShader(35633);
        this.fragSH = this.gl.glCreateShader(35632);
        this.shaderprogram = this.gl.glCreateProgram();
        this.gl.glAttachShader(this.shaderprogram, this.vertSH);
        this.gl.glAttachShader(this.shaderprogram, this.fragSH);
        this.vertString = this.loadShader(vs);
        this.fragString = this.loadShader(fs);
    }

    private String loadShader(String name) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(name));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void bind(boolean use) {
        if (this.gl == null) {
            this.gl = Renderer.getInstance().getGL2();
        }
        if (use) {
            this.gl.glUseProgram(this.shaderprogram);
        } else {
            this.gl.glUseProgram(0);
        }
    }

    public int compile() {
        this.infoLog = "";
        this.infoLog = String.valueOf(this.infoLog) + "Compiling...\t";
        this.gl = Renderer.getInstance().getGL2();
        this.gl.glShaderSource(this.vertSH, 1, new String[]{this.vertString}, new int[]{this.vertString.length()}, 0);
        this.gl.glCompileShader(this.vertSH);
        this.gl.glShaderSource(this.fragSH, 1, new String[]{this.fragString}, new int[]{this.fragString.length()}, 0);
        this.gl.glCompileShader(this.fragSH);
        this.infoLog = String.valueOf(this.infoLog) + "Done!\n";
        this.infoLog = String.valueOf(this.infoLog) + "Linking...\t";
        this.gl.glLinkProgram(this.shaderprogram);
        this.gl.glValidateProgram(this.shaderprogram);
        IntBuffer intBuffer = IntBuffer.allocate(1);
        this.gl.glGetProgramiv(this.shaderprogram, 35714, intBuffer);
        if (intBuffer.get(0) != 1) {
            byte c;
            int n;
            int n2;
            byte[] byArray;
            String s;
            ByteBuffer log;
            IntBuffer charswritten;
            this.gl.glGetShaderiv(this.vertSH, 35716, intBuffer);
            int len = intBuffer.get(0);
            if (len > 1) {
                this.infoLog = String.valueOf(this.infoLog) + "\n\nError occured in vertex shader:\n";
                charswritten = IntBuffer.allocate(1);
                log = ByteBuffer.allocate(len);
                intBuffer = IntBuffer.allocate(len);
                this.gl.glGetShaderInfoLog(this.vertSH, len, charswritten, log);
                s = "";
                byArray = log.array();
                n2 = byArray.length;
                n = 0;
                while (n < n2) {
                    c = byArray[n];
                    if (c != 0) {
                        s = String.valueOf(s) + (char)c;
                    }
                    ++n;
                }
                this.infoLog = String.valueOf(this.infoLog) + s;
            }
            this.gl.glGetShaderiv(this.fragSH, 35716, intBuffer);
            len = intBuffer.get(0);
            if (len > 1) {
                this.infoLog = String.valueOf(this.infoLog) + "\n\nError occured in fragment shader:\n";
                charswritten = IntBuffer.allocate(1);
                log = ByteBuffer.allocate(len);
                intBuffer = IntBuffer.allocate(len);
                this.gl.glGetShaderInfoLog(this.fragSH, len, charswritten, log);
                s = "";
                byArray = log.array();
                n2 = byArray.length;
                n = 0;
                while (n < n2) {
                    c = byArray[n];
                    if (c != 0) {
                        s = String.valueOf(s) + (char)c;
                    }
                    ++n;
                }
                this.infoLog = String.valueOf(this.infoLog) + s;
            }
        } else {
            this.infoLog = String.valueOf(this.infoLog) + "Done!\n";
            this.infoLog = String.valueOf(this.infoLog) + "Shader is ready for use.\n\n";
        }
        this.uniforms.clear();
        this.readUniforms(this.vertString);
        this.readUniforms(this.fragString);
        return 1;
    }

    @Override
    public void load() {
        StringTokenizer st = new StringTokenizer(this.filename, ".");
        String str = "";
        while (st.hasMoreTokens()) {
            str = st.nextToken();
        }
        str.equals("vert");
    }

    public String getVertString() {
        return this.vertString;
    }

    public void setVertString(String vertString) {
        this.vertString = vertString;
    }

    public String getFragString() {
        return this.fragString;
    }

    public void setFragString(String fragString) {
        this.fragString = fragString;
    }
}

