/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.App;
import gui.MyFileSelector;
import gui.ViewResources;
import gui.ViewScene;
import gui.ViewShaders;
import gui.time.ViewTimeline;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.Project;
import model.Resources;
import opengl.Renderer;
import timeline.TimeLine;

public class MainFrame
extends JFrame {
    JFrame view = this;
    JTabbedPane tabbedpane = new JTabbedPane();
    Resources resources = new Resources();
    ViewResources panResources = new ViewResources(this.resources);
    ViewScene panScenes = new ViewScene();
    ViewShaders panShaders;
    ViewTimeline panDemo = new ViewTimeline();
    private static MainFrame instance = null;

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    public MainFrame() {
        this.panShaders = new ViewShaders();
        this.setSize(800, 600);
        JMenuBar menubar = new JMenuBar();
        JMenu mnu = new JMenu("Project");
        JMenuItem mniLoad = new JMenuItem("Load");
        JMenuItem mniSave = new JMenuItem("Save");
        mnu.add(mniLoad);
        mnu.add(mniSave);
        menubar.add(mnu);
        this.setJMenuBar(menubar);
        mniLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String str = MyFileSelector.getInstance().open("project", "eXtrait project");
                    if (str != null) {
                        Project.getInstance().LoadProject(str);
                        MainFrame.this.panScenes.setScenes(Project.getInstance().getScenes());
                        MainFrame.this.panScenes.selected = Project.getInstance().getScenes().get(0);
                        MainFrame.this.panScenes.init();
                        MainFrame.this.panScenes.updateUI();
                        MainFrame.this.panResources.updateUI();
                        MainFrame.this.panShaders.refreshList();
                        MainFrame.this.panDemo.updateUI();
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        mniSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String str = MyFileSelector.getInstance().open("project", "eXtrait project");
                    boolean overwrite = true;
                    if (str != null) {
                        int answer;
                        boolean exists;
                        if (!str.endsWith(".project")) {
                            str = String.valueOf(str) + ".project";
                        }
                        overwrite = (exists = new File(str).exists()) ? (answer = JOptionPane.showConfirmDialog(MainFrame.this.view, "File exists. Overwrite?", "Save project.", 0)) == 0 : true;
                        if (overwrite) {
                            Project.getInstance().SaveProject(str);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tabbedpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Component c = MainFrame.this.tabbedpane.getSelectedComponent();
                if (c.getClass().equals(ViewTimeline.class)) {
                    Renderer.getInstance().setGLobjectToDraw(TimeLine.getInstance());
                }
                App.frame.paintAll(App.frame.getGraphics());
            }
        });
        this.tabbedpane.addTab("Resources", this.panResources);
        this.tabbedpane.addTab("Shaders", this.panShaders);
        this.tabbedpane.addTab("Scenes", (Component)this.panScenes);
        this.tabbedpane.addTab("Timeline", this.panDemo);
        this.add(this.tabbedpane);
        this.panShaders.refreshList();
    }
}

