/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import scene.Entity;
import scene.EntityModel;
import scene.EntityMultiply;
import scene.Scene;

public class FrameSelectModelFromScene
extends JDialog {
    JButton btnOK = new JButton("OK");
    JList listModels = null;
    Scene scene;

    public FrameSelectModelFromScene(int currentID, Scene scene) {
        this.scene = scene;
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.listModels = new JList(model);
        ArrayList data = new ArrayList();
        this.listModels.setSelectionMode(1);
        this.listModels.setLayoutOrientation(1);
        this.listModels.setVisibleRowCount(-1);
        for (Entity e : scene.entities) {
            if (e.getClass().equals(EntityModel.class)) {
                model.add(model.getSize(), String.valueOf(e.getName()) + " - " + e.getId());
                if (e.getId() == currentID) {
                    this.listModels.setSelectedIndex(model.getSize() - 1);
                }
            }
            if (!e.getClass().equals(EntityMultiply.class)) continue;
            model.add(model.getSize(), String.valueOf(e.getName()) + " - " + e.getId());
            if (e.getId() != currentID) continue;
            this.listModels.setSelectedIndex(model.getSize() - 1);
        }
        JScrollPane listScroller = new JScrollPane(this.listModels);
        listScroller.setPreferredSize(new Dimension(180, 220));
        this.add((Component)listScroller, "North");
        this.add((Component)this.btnOK, "South");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FrameSelectModelFromScene.this.show(false);
            }
        });
        this.pack();
    }

    public int getSelected() {
        for (Entity e : this.scene.entities) {
            if (!this.listModels.getSelectedValue().toString().equals(String.valueOf(e.getName()) + " - " + e.getId())) continue;
            return e.getId();
        }
        return 0;
    }
}

