// 2011-12 - rascy@dilemma.ws

$(document).ready(function() {

    $.extend(demo, {

        atmosphere : {

            title : function(scene) {

                scene.fog = new THREE.Fog(0x000000, 100, 4000);

                aL1 = new THREE.AmbientLight(0x303030);
                aL1.name = 'aL1';
                scene.add(aL1);

                L1 = new THREE.PointLight(0xf1f1f1, 1, 6000);
                L1.name = 'L1';

                L1.position.x = 100;
                L1.position.y = -1000;
                L1.position.z = 0;
                scene.add(L1);

                light = new THREE.SpotLight(0xccddee, 3, 0, Math.PI, 1);
                light.position.set(0, 2500, -2500);
                light.target.position.set(0, 0, 0);

                light.castShadow = true;
                light.shadowCameraNear = 100;
                light.shadowCameraFar = 10000;
                light.shadowCameraFov = 130;
                light.shadowCameraVisible = demo.params.shadow_cam;
                light.shadowBias = 0.0011;
                light.shadowDarkness = 0.9;
                light.shadowMapWidth = demo.params.shadow_map_size_multiplier * 512;
                light.shadowMapHeight = demo.params.shadow_map_size_multiplier * 512;

                scene.add(light);

            },

            bright : function(scene) {

                scene.fog = new THREE.FogExp2(0xfafafa, 0.0002);

                aL1 = new THREE.AmbientLight(0x303030);
                aL1.name = 'aL1';
                scene.add(aL1);

                L1 = new THREE.PointLight(0xfefefe, 3, 7000);
                L1.name = 'L1';
                L1.position.x = 1000;
                L1.position.y = 1000;
                L1.position.z = 0;
                scene.add(L1);

                L2 = new THREE.PointLight(0xfefefe, 2, 5000);
                L2.name = 'L2';
                L2.position.x = 2000;
                L2.position.y = 0;
                L2.position.z = 2000;
                scene.add(L2);

                L3 = new THREE.PointLight(0xfefefe, 2, 5000);
                L3.name = 'L3';
                L3.position.x = 0;
                L3.position.y = 2000;
                L3.position.z = 2000;
                scene.add(L3);

            },

            basic : function(scene) {

                scene.fog = new THREE.FogExp2(0x000000, 0.0003);

                aL1 = new THREE.AmbientLight(0x999999);
                aL1.name = 'aL1';
                scene.add(aL1);

                dL1 = new THREE.DirectionalLight(0x999999);
                dL1.name = 'dL1';
                dL1.position.x = 10;
                dL1.position.y = 10;
                dL1.position.z = 20;
                //dL1.position.normalize();
                scene.add(dL1);

                dL2 = new THREE.DirectionalLight(0xffffff);
                dL2.name = 'dL2';
                dL2.position.x = -20;
                dL2.position.y = -10;
                dL2.position.z = -10;
                //dL2.position.normalize();
                scene.add(dL2);

            },

            white : function(scene) {

                scene.fog = new THREE.FogExp2(0xfefefe, 0.0002);

                L1 = new THREE.PointLight(0xfefefe, 4, 5000);
                L1.name = 'L1';
                L1.position.x = 1000;
                L1.position.y = 1000;
                L1.position.z = 200;
                scene.add(L1);

            },

            sindots : function(scene) {

                scene.fog = new THREE.FogExp2(0xfefefe, 0.0001);

                L1 = new THREE.PointLight(0xfefefe, 4, 2000);
                L1.name = 'L1';
                L1.position.x = 1000;
                L1.position.y = 1000;
                L1.position.z = 200;
                scene.add(L1);

            },

            foggy : function(scene) {

                //scene.fog = new THREE.FogExp2(0xf9f9f9, 0.0002);

                L0 = new THREE.AmbientLight(0x000000);
                L0.name = 'L0';
                scene.add(L0);

                L1 = new THREE.PointLight(0xf1f1f1, 3, 6000);
                L1.name = 'L1';
                L1.position.x = 100;
                L1.position.y = 100;
                L1.position.z = 220;
                scene.add(L1);

                L2 = new THREE.PointLight(0xB2E7F0, 4, 6000);
                // color, intensity, distance
                L2.name = 'L2';
                L2.position.x = -1120;
                L2.position.y = -1110;
                L2.position.z = -1110;
                //dL2.position.normalize();
                scene.add(L2);

            },

            random : function(scene) {

                scene.fog = new THREE.FogExp2(0x000000, 0.0005);

                var aL1 = new THREE.AmbientLight(0x777777);
                aL1.name = 'aL1';
                scene.add(aL1);

                var pL = [];
                var lights_count = 3;
                for ( i = 0; i < lights_count; i++) {
                    pL[i] = new THREE.PointLight(0x999999, 0.4);
                    pL[i].position.x = Math.random() * 1500;
                    pL[i].position.y = Math.random() * 1500;
                    pL[i].position.z = Math.random() * 1500;
                    pL[i].name = 'pL' + i;
                    scene.add(pL[i]);
                }
            },

            dark : function(scene) {

                scene.fog = new THREE.FogExp2(0x000000, 0.001);

                aL1 = new THREE.AmbientLight(0x000000);
                aL1.name = 'aL1';
                scene.add(aL1);

                dL1 = new THREE.DirectionalLight(0x999999);
                dL1.name = 'dL1';
                dL1.position.x = 10;
                dL1.position.y = 10;
                dL1.position.z = 20;
                //dL1.position.normalize();
                scene.add(dL1);

                dL2 = new THREE.DirectionalLight(0x777777);
                dL2.name = 'dL2';
                dL2.position.x = -20;
                dL2.position.y = -10;
                dL2.position.z = -10;
                //dL2.position.normalize();
                scene.add(dL2);

            },

            polip : function(scene) {

                scene.fog = new THREE.Fog(0x303030, 1000, 7500);
                THREE.ColorUtils.adjustHSV(scene.fog.color, 0.02, -0.15, -0.65);

                var ambient = new THREE.AmbientLight(0x444444);
                //scene.add(ambient);

                L1 = new THREE.PointLight(0x11aaf1, 2, 8000);
                L1.name = 'L1';
                L1.position.x = 1000;
                L1.position.y = 1000;
                L1.position.z = 2200;
                scene.add(L1);

                L2 = new THREE.PointLight(0xf1f1f1, 2, 6000);
                L2.name = 'L2';
                L2.position.x = 1000;
                L2.position.y = 1000;
                L2.position.z = 2200;
                scene.add(L2);

                light = new THREE.SpotLight(0xffffff, 2, 0, Math.PI, 1);
                light.position.set(1200, 4550, 0);
                light.target.position.set(200, 200, 0);
                light.name = 'L3';

                light.castShadow = true;

                light.shadowCameraNear = 100;
                light.shadowCameraFar = 10000;
                light.shadowCameraFov = 175;

                light.shadowCameraVisible = demo.params.shadow_cam;

                light.shadowBias = 0.0011;
                light.shadowDarkness = 0.9;

                light.shadowMapWidth = demo.params.shadow_map_size_multiplier * 512;
                light.shadowMapHeight = demo.params.shadow_map_size_multiplier * 512;

                scene.add(light);

            },

            shadow : function(scene) {

                scene.fog = new THREE.Fog(0x303030, 1000, 8500);
                THREE.ColorUtils.adjustHSV(scene.fog.color, 0.02, -0.15, -0.65);

                var ambient = new THREE.AmbientLight(0x444444);
                //scene.add(ambient);

                L1 = new THREE.PointLight(0xf1f1f1, 1, 7000);
                L1.name = 'L1';
                L1.position.x = 1000;
                L1.position.y = 1000;
                L1.position.z = 2200;
                scene.add(L1);

                L2 = new THREE.PointLight(0xf1f1f1, 3, 7000);
                L2.name = 'L2';
                L2.position.x = 1000;
                L2.position.y = 1000;
                L2.position.z = 2200;
                scene.add(L2);

                light = new THREE.SpotLight(0xffffff, 2, 0, Math.PI, 1);
                light.position.set(1200, 4550, 0);
                light.target.position.set(200, 200, 0);

                light.castShadow = true;

                light.shadowCameraNear = 100;
                light.shadowCameraFar = 10000;
                light.shadowCameraFov = 175;

                light.shadowCameraVisible = demo.params.shadow_cam;

                light.shadowBias = 0.0011;
                light.shadowDarkness = 0.9;

                light.shadowMapWidth = demo.params.shadow_map_size_multiplier * 512;
                light.shadowMapHeight = demo.params.shadow_map_size_multiplier * 512;

                scene.add(light);

            },
            shadow2 : function(scene) {

                scene.fog = new THREE.Fog(0x303030, 100, 5500);
                THREE.ColorUtils.adjustHSV(scene.fog.color, 0.02, -0.15, -0.65);

                var ambient = new THREE.AmbientLight(0x444444);
                //scene.add(ambient);

                L1 = new THREE.PointLight(0xddeeff, 1, 6000);
                L1.name = 'L1';

                L1.position.x = 1000;
                L1.position.y = 1000;
                L1.position.z = 2200;
                scene.add(L1);

                light = new THREE.SpotLight(0xccddee, 2, 0, Math.PI, 1);
                light.position.set(0, 2000, -2000);
                light.target.position.set(0, 0, 0);

                light.castShadow = true;

                light.shadowCameraNear = 100;
                light.shadowCameraFar = 10000;
                light.shadowCameraFov = 130;

                light.shadowCameraVisible = demo.params.shadow_cam;

                light.shadowBias = 0.0011;
                light.shadowDarkness = 0.9;

                light.shadowMapWidth = demo.params.shadow_map_size_multiplier * 512;
                light.shadowMapHeight = demo.params.shadow_map_size_multiplier * 512;

                scene.add(light);

            },

            intube : function(scene) {

                scene.fog = new THREE.Fog(0xf1f1f1, 100, 2500);
                //THREE.ColorUtils.adjustHSV(scene.fog.color, 0.02, -0.15,
                // -0.65);

                var ambient = new THREE.AmbientLight(0x444444);
                //scene.add(ambient);

                L1 = new THREE.PointLight(0xf1f1f1, 1, 6000);
                L1.name = 'L1';

                L1.position.x = 0;
                L1.position.y = 0;
                L1.position.z = 0;
                scene.add(L1);

                light = new THREE.SpotLight(0xf1f1f1, 2, 0, Math.PI, 1);
                light.position.set(0, 0, 2000);
                light.target.position.set(0, 0, 0);

                light.castShadow = true;

                light.shadowCameraNear = 1;
                light.shadowCameraFar = 10000;
                light.shadowCameraFov = 130;

                light.shadowCameraVisible = demo.params.shadow_cam;

                light.shadowBias = 0.0011;
                light.shadowDarkness = 0.9;

                light.shadowMapWidth = demo.params.shadow_map_size_multiplier * 512;
                light.shadowMapHeight = demo.params.shadow_map_size_multiplier * 512;

                scene.add(light);

            }
        }

    });

});
