//tunnel1.frag
#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

uniform vec2 resolution;
uniform float time;
uniform sampler2D tex0;

const float PI=3.14159;

float checker(vec2 p){ return mod(floor(p.x)+floor(p.y), 2.);}

vec3 getTexture(vec2 p) {
	float t = time;
	vec3 color = vec3(0.,0.,0.);
	
	float a0 = (fract(0.+ p.x * .1) < .7)?0.:1.;
	float b0 = (fract(t + p.y * .1) < .7)?0.:1.;
	
	float a1 = (fract(.2 + p.x * .5) < .3 )?0.:1.;
	float b1 = (fract( t -  p.y * .2) < .25)?0.:1.;
	
	color = (a1*b1) + a0*b0 * vec3 (1,1,1);
	
	return color * .5;
}

vec3 getTexture_texCoord (vec2 p) {
	return fract(vec3(p.x, p.y, 0));
}

void main()
{		
	vec2 p = gl_TexCoord[0].st;
	
	vec4 color;
	
	color.rgb = getTexture(p.yx * vec2(.1, PI));
	color.a = 1;
	
	gl_FragData[0] = color;
	
	gl_FragData[1].rgb = vec3(.5, .5, .5);
	gl_FragData[1].a = 1.;
	
	gl_FragData[2].rgb = vec3(1, 1, 1);
	gl_FragData[2].a = 1.;
	
	gl_FragData[3].rgb = 1. - exp(-vec3(1,1,1));
	gl_FragData[3].a = 1.;
}