//tunnel1.frag
#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

uniform float fade;

uniform vec2 resolution;
uniform float time;
uniform sampler2D tex0;

const float PI=3.14159;

// ezt a kodot ugy loptam, bizony :(
float hexDistance(vec2 ip) {
	const float SQRT3 = 1.732050807568877;
	const vec2 TRIG30 = vec2(0.5, 0.866025403784439); //x:sine, y:cos
	
	vec2 p = abs(ip * vec2(SQRT3 * 0.5, 0.75));
	float d = dot(p, vec2(-TRIG30.x, TRIG30.y)) - SQRT3 * 0.25;
	
	return (d > 0.0)? min(d, (SQRT3 * 0.5 - p.x)) : min(-d, p.x);
}

float smoothEdge(float edge, float margin, float x) {
	return smoothstep(edge - margin, edge + margin, x);
}

vec2 repeat(vec2 p, float n) {
	vec2 np = p * n;
	vec2 npfrct = fract(np);
	vec2 npreal = np - npfrct;
	np.x += fract(npreal.y * 0.5);
	
	return fract(np) * 2.0 - 1.0;
}
vec4 getTexture(vec2 p) {
	float t = time;
	vec4 color = vec4(0.,0.,0., 0.);
	
	float d = hexDistance(repeat(p * vec2(1.0, 0.5) , 3.04));
	
	float atmenet = abs(1.-2*fade);
	
	float a1 = mix(.5, .7, atmenet);
	float a2 = mix(.3, .5, atmenet);
	
	color  = mix(vec4(.62, .83, .46, 1.0)*fade, vec4(0.0), smoothEdge(0.03, 0.01,d));
	color += mix(vec4(.62, .83, .46, 0.5)*fade, vec4(0.0), smoothEdge(0.03, 0.5, d));
	color += mix(vec4(.62, .83, .46, 0.3)*fade, vec4(0.0), smoothEdge(0.03, 1.0, d));
	
	color.a *= clamp((p.x + 2.)*.75, 0., 1.);
	
	return color;
}

vec3 getTexture_texCoord (vec2 p) {
	return fract(vec3(p.x, p.y, 0));
}

void main()
{		
	vec2 p = gl_TexCoord[0].st;
	
	vec4 color;
	
	color = getTexture(p.yx * vec2(.1, PI));
	
	gl_FragData[0] = color;
	
	gl_FragData[1].rgb = vec3(.5, .5, .5);
	gl_FragData[1].a = 1.;
	
	gl_FragData[2].rgb = vec3(1, 1, 1);
	gl_FragData[2].a = 1.;
	
	gl_FragData[3].rgb = 1. - exp(-vec3(1,1,1));
	gl_FragData[3].a = 1.;
}