//pointlight.vert.c
varying vec3 normal, lightDir, eyeVec;
varying float ZValue;

//uniform float near;
//uniform float far;

const float near = 3.0;
const float far = 800.;

void main()
{	
	normal = gl_NormalMatrix * gl_Normal;

	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
	lightDir = gl_LightSource[0].position.xyz - vVertex;
	eyeVec = -vVertex;
	
	ZValue = vVertex.z/far;
	
	gl_Position = ftransform();
	
		gl_FrontColor = gl_Color;
	
	gl_TexCoord[0]  = gl_TextureMatrix[0] * gl_MultiTexCoord0;
	gl_TexCoord[1]  = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	gl_TexCoord[2]  = gl_TextureMatrix[2] * gl_MultiTexCoord2;
	gl_TexCoord[3]  = gl_TextureMatrix[3] * gl_MultiTexCoord3;
	gl_TexCoord[4]  = gl_TextureMatrix[4] * gl_MultiTexCoord4;
	gl_TexCoord[5]  = gl_TextureMatrix[5] * gl_MultiTexCoord5;
	gl_TexCoord[6]  = gl_TextureMatrix[6] * gl_MultiTexCoord6;
}