//pointlight.frag

#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

varying vec3 normal, lightDir, eyeVec;
uniform sampler2D tex0;

varying float ZValue;

uniform float joreggelt;
uniform vec3 color;

//#define CSAK_PERVERTEX_RENDER_

//from http://spidergl.org/example.php?id=6
vec4 packDepth(const in float depth) {
	const vec4 bit_shift = vec4(256.0*256.0*256.0, 256.0*256.0, 256.0, 1.0);
	const vec4 bit_mask  = vec4(0.0, 1.0/256.0, 1.0/256.0, 1.0/256.0);
	vec4 res = fract(depth * bit_shift);
	res -= res.xxyz * bit_mask;
	return res;    		
}

void main (void)
{
	vec4 final_color = (gl_FrontLightModelProduct.sceneColor * gl_FrontMaterial.ambient) + 
	(gl_LightSource[0].ambient * gl_FrontMaterial.ambient);
							
	vec3 N = normalize(normal);
	vec3 L = normalize(lightDir);
	
	float lambertTerm = dot(N,L);
	
	vec4 diffuse = mix(gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse, vec4(color,1.), joreggelt);
	
	//vec4 asdfgh = vec4(color, 1);
	//vec4 diffuse = mix(gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse, asdfgh, joreggelt);
	
	if(lambertTerm > 0.0)
	{
		final_color += diffuse * lambertTerm;	
		
		// TODO: A 3ds szabvany szerinti specular ertek mast jelent mint a phong szerinti !!! 
		//vec3 E = normalize(eyeVec);
		//vec3 R = reflect(-L, N);
		//float specular = pow( max(dot(R, E), 0.0), gl_FrontMaterial.shininess );
		//final_color += gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;	
	}

	//gl_FragColor = final_color;
	vec4 texture_color = texture2D(tex0, gl_TexCoord[0].st);

#ifndef CSAK_PERVERTEX_RENDER_
	// color 
	// a kurva eletbe, a faszom kivan mar
	vec3 tint = mix(color, vec3(1), 1.-joreggelt);
	gl_FragData[0].rgb = tint * texture_color.rgb;
	//gl_FragData[0].rgb = texture_color.rgb;
	//gl_FragData[0].a = texture_color.a;
	
	// normal
	gl_FragData[1].rgb = (1.+N)/2.;
	gl_FragData[1].a = 1.;
	
	// Z
	gl_FragData[2] = packDepth(-ZValue);
	gl_FragData[2].r = -ZValue;
	
	// HDR
	gl_FragData[3].rgb = 1. - exp(-final_color.rgb);
	gl_FragData[3].a = 1.;
	
#else 
	gl_FragData[0].rgb = (final_color * texture_color).rgb;
	gl_FragData[0].a = 1.;
#endif
}