// particle1.frag

#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

// The following uniforms are comes from the shader API
uniform vec2 resolution;
uniform float time;
uniform sampler2D tex0;
uniform sampler2D zmap;

varying vec2 uv_treshold;
varying vec2 uv_clamp;

varying float ZDepth;

//uniform float near;
//uniform float far;

const float near = 3.0;
const float far = 800.;

vec2 getTexcoord(vec2 uv){
	vec2 uv_ = uv * (resolution / vec2(2048.f));
	return uv_;
}

void main()
{	
	vec4 color;
	
	vec2 p = gl_FragCoord.xy / resolution;
	p = getTexcoord(p);
	float z = float(texture2D(zmap, p));
	
	//color.rgb = vec3(1,1,0);
	//color.a = 1.;
	
	if (ZDepth >= z ){
		color = vec4(0,0,0,0);
	} else {
		vec4 sample = texture2D(tex0, gl_TexCoord[0].st);
		float mask = sample.r + sample.g + sample.b;
		mask /= 3.;
		
		color.rgb = vec3(0,0,0); 
		color.a = mask;
		
		color.a *= gl_Color.a;
	}
	
	gl_FragData[0] = color;
}
