//hdrbloom.frag

#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif


// http://renderingwonders.wordpress.com/2011/01/25/chapter-09-%E2%80%93-advanced-buffers-beyond-the-basics-%E2%80%93-hdr-bloom-effect/

uniform sampler2D tex0;

#define BLOOM_PASSES 15

uniform float bias;
uniform float bloomLevel;
uniform float exposure;

out vec4 outColor;

void main(){
	vec2 p = gl_TexCoord[0].st;
	vec4 baseImage = vec4(textureLod(tex0, p.xy, 0).rgb, 1);
	
	vec4 blurColor[BLOOM_PASSES], bloom = vec4(0);
    for (int i=0; i<BLOOM_PASSES; i++){
		blurColor[i] = textureLod(tex0, p, i);
		blurColor[i].rgb = blurColor[i].rgb * (1.-blurColor[i].a);
		blurColor[i].a = 1.;
		
		bloom += blurColor[i];
	}
	
	bloom /= float(BLOOM_PASSES);
    vec4 color = baseImage + bloomLevel * (bias+bloom);

    // Apply the exposure to this texel
    outColor = 1.0 - exp2(-color * exposure);
    outColor.a = 1.0;
}