
#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

uniform vec2 resolution;

uniform float SSAORadius;
uniform float blurRadius;

//uniform float textureSize;
const float textureSize = 2048.;

uniform sampler2D tex0;
uniform sampler2D illumMapPhong;
uniform sampler2D illumMapSSAO;

uniform float bias;
uniform float bloomLevel;
uniform float exposure;

#define USE_INVERTED_OCCLUSION

float selectMipLevel(float radius){
	//float r = radius * resolution.y;
	float r = .5*radius * textureSize;
	return log2(r);
}

vec4 blurByLOD(float radius, sampler2D source, vec2 pos, int lod){
	vec2 newCoord;
	vec4 sum;
	
	vec2 samples00 = vec2(-0.326212, -0.405805);
	vec2 samples01 = vec2(-0.840144, -0.073580);
	vec2 samples02 = vec2(-0.695914,  0.457137);
	vec2 samples03 = vec2(-0.203345,  0.620716);
	vec2 samples04 = vec2( 0.962340, -0.194983);
	vec2 samples05 = vec2( 0.473434, -0.480026);
	vec2 samples06 = vec2( 0.519456,  0.767022);
	vec2 samples07 = vec2( 0.185461, -0.893124);
	vec2 samples08 = vec2( 0.507431,  0.064425);
	vec2 samples09 = vec2( 0.896420,  0.412458);
	vec2 samples10 = vec2(-0.321940, -0.932615);
	vec2 samples11 = vec2(-0.791559, -0.597705);
	
	sum = textureLod(source, pos, lod);

	newCoord = pos + radius * samples00; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples01; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples02; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples03; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples04; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples05; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples06; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples07; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples08; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples09; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples10; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples11; sum += textureLod(source, newCoord, lod);

	sum /= 13.0;

	return sum;
}

vec4 fastBlur(float radius, sampler2D source, vec2 pos){
		int lod = int(floor(selectMipLevel(radius)));
		return blurByLOD(radius, source, pos, lod);
}

vec4 preciseBlur(float radius, sampler2D source, vec2 pos){
	int lod = int(floor(selectMipLevel(radius)));
	float interpol = fract(lod);
	vec4 sample1 = blurByLOD(radius, source, pos, lod);
	vec4 sample2 = blurByLOD(radius, source, pos, lod+1);
	return mix(sample1, sample2, interpol);
}

////////////////////////////////////////////////////////////////

void main(){
	vec3 ao; //occlusion value
	ao = preciseBlur(SSAORadius + blurRadius, illumMapSSAO, gl_TexCoord[0].xy).rgb;
	//ao = texture2D(illumMapSSAO, gl_TexCoord[0].xy).rgb;
	
	// when ssao turned off, the result image won't black in this case
#ifdef USE_INVERTED_OCCLUSION
	ao = vec3(1.) - ao;
#endif /*USE_INVERTED_OCCLUSION*/
	
	
	vec3 color, illum, illum2;
	if (blurRadius>0.){
		color = preciseBlur(blurRadius, tex0, gl_TexCoord[0].xy).rgb;
		illum = preciseBlur(blurRadius, illumMapPhong, gl_TexCoord[0].xy).rgb;
	}else {
		color = texture2D(tex0, gl_TexCoord[0].xy).rgb;
		illum = texture2D(illumMapPhong, gl_TexCoord[0].xy).rgb;
	}
	
	illum2 = -log(1.-illum);
	
	// a kurva eletbe, a faszom kivan mar
	
	gl_FragColor.rgb = ao * color * illum2;
	//gl_FragColor.rgb = ao;
	
	//gl_FragColor.rgb = texture2D(illumMapPhong, gl_TexCoord[0].xy).rgb;
	//gl_FragColor.rgb = ao * clamp(illum2,0.,1.) * color;
	
	gl_FragColor.a = 1.;
}