/**
 * Purpose: Takes text and font, outputs only those parts of the font that are used.
 * Text is packed, six characters per four bytes.
 */

#include <stdio.h>

static const char lines[][14] = {
    //an @ in [12] marks new paragraphs
   //012345678901
    "            ",
    "GOOD EVENING",
    "   EVOKE!   ",
    "TJOPPEN^DSS ",
    "ON THE KEYS ",
    "WISHING YOU ",
    " ALL A GOOD ",
    "EVENING AND ",
    "GOOD LUCK IN",
    " ALL COMPOS ",
    "            ",
    "            ",
    "   PROST!   ",
    "            ",
    "GREETINGS TO",
    "3LB 3LN PWP ",
    " JAC CTRIX  ",
    "AND ANYONE I",
    "   FORGOT   ",
    "            ",
    "            ",
    "            ",
    "            ",
    "            ",
    "            ",
};

static const num_lines = sizeof(lines)/sizeof(*lines);

int main(int argc, char **argv) {
    FILE *f;
    char font[256][8][8];
    int counts[256] = {0}, codes[256], used = 0, code = 0;
    int x, y, x2, y2;
    unsigned char header[54];
    int charh = 8;
    unsigned char bytes[num_lines][4];
    int paragraphs[100] = {0}, num_paragraps = 1;

    f = fopen(argv[1], "rb");
    fread(header, 54, 1, f);

    if (header[18] != 128 || header[22] != 128 || header[28] != 24) {
        fprintf(stderr, "BMP not 128x128, 24-bit\n");
        return 1;
    }

    /* upside-down */
    for (y2 = 15; y2 >= 0; y2--) {
        for (y = charh-1; y >= 0; y--) {
            for (x2 = 0; x2 < 16; x2++) {
                for (x = 0; x < 8; x++) {
                    int c = getc(f) + getc(f) + getc(f);
                    font[y2*16+x2][y][x] = c < 384;
                }
            }
        }
    }

    for (x = 0; x < num_lines; x++) {
        if (lines[x][12] == '@')
            paragraphs[num_paragraps++] = x;

        for (y = 0; y < 12; y++)
            if (!counts[lines[x][y]]++)
                used++;
    }
    paragraphs[num_paragraps++] = num_lines;

    if (used > 32) {
        fprintf(stderr, "hrmph, can't pack 12x%i unique characters into 64 bits\n", used);
        fprintf(stderr, "here are the symbol counts:\n");

        for (x = 0; x < 256; x++)
            if (counts[x])
                fprintf(stderr, "%c: %i\n", x, counts[x]);

        return 1;
    }

    printf("NUM_LINES equ %i\n", num_lines);
    printf("CHARH equ %i\n", charh);

    for (x = 0; x < num_paragraps; x++)
        printf("PARAGRAPH%i equ %i\n", x, paragraphs[x]);

    printf("\tMAC PARAGRAPHS\n");
    for (x = 0; x < num_paragraps; x++)
        printf("\t.byte PARAGRAPH%i\n", x);
    printf("\tENDM\n");

    /* assign codes, output font macro */
    printf("\tMAC FONT\n");
    for (x = 0; x < 256; x++) {
        if (!counts[x])
            continue;

        printf("Glyph%i\n", code);
        /* upside-down as is typical for sprites */
        for (y = charh-1; y >= 0; y--)
            printf("\t.byte %%%i%i%i%i%i%i%i%i\n",
                   font[x][y][0], font[x][y][1], font[x][y][2], font[x][y][3],
                   font[x][y][4], font[x][y][5], font[x][y][6], font[x][y][7]);

        //fprintf(stderr, "%c = %i\n", x, code);
        codes[x] = code++;
    }
    printf("\tENDM\n");

    printf("\tMAC TEXT\n");
/*    for (x = 0; x < num_lines; x++) {
        int code4, code5;

        bytes[x][0] = codes[lines[x][0]];
        bytes[x][1] = codes[lines[x][1]];
        bytes[x][2] = codes[lines[x][2]];
        bytes[x][3] = codes[lines[x][3]];
        code4 = codes[lines[x][4]];
        code5 = codes[lines[x][5]];
        bytes[x][0] |= (code4 & 7) << 5;
        bytes[x][1] |= (code4 & 24) << 3;
        bytes[x][2] |= (code5 & 7) << 5;
        bytes[x][3] |= (code5 & 24) << 3;
    }

    for (y = 0; y < 4; y++) {
        printf("Bytes%i\n", y);
        for (x = 0; x < num_lines; x++)
            printf("\t.byte $%02x ;%s\n", bytes[x][y], lines[x]);
    }
*/
    for (x = 0; x < 12; x++) {
        printf("Text%i\n", x);
        for (y = 0; y < num_lines; y++)
            printf("\tbyte $%02X ;%c\n", codes[lines[y][x]] << 3, lines[y][x]);
    }

    printf("\tENDM\n");

    return 0;
}
