// mog
/*jslint devel: true, browser: true */
var Looping = (function () {
    "use strict";

    var _duration = 0,
        _holder,
        _ctx,
        _ctxBack,
        _mayRender = false,
        _images,
        _particle;

    function init(duration) {

        //console.log("Greetings - init()");

        _duration = duration;

        loadResources();

        _holder = document.createElement('div');
        document.getElementById('root').appendChild(_holder);

        var canvas = document.createElement('canvas');
        _ctx = canvas.getContext('2d');
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
        canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(canvas);

        //--

        canvas = document.createElement('canvas');
        _ctxBack = canvas.getContext('2d');
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
        canvas.style.cssText = 'position:absolute;z-index:-1;';

        _holder.appendChild(canvas);

        _ctxBack.fillStyle = '0x000000';//Random.color();
        _ctxBack.fillRect(0, 0, canvas.width, canvas.height);

        _ctx.fillStyle = '0xfffff';//Random.color();
        _ctx.fillRect(0, 0, canvas.width, canvas.height);

        genParticle();
    }

    function loadResources() {

        var _imgLoader,
            resourceURL = [

                {"a0":'data/01_puter.jpg'},
                {"a1":'data/02_from_werk_1.jpg'},
                {"a2":'data/02_from_werk_2.jpg'},
                {"a3":'data/02_from_werk_3.jpg'},
                {"a4":'data/02_from_werk_4.jpg'},
                {"a5":'data/02_from_werk_5.jpg'},
                {"a6":'data/02_from_werk_6.jpg'},
                {"a7":'data/03_feld.jpg'},
                {"a8":'data/03_a_gurt.jpg'},
                {"a9":'data/03_b_jetpack.jpg'},
                {"a10":'data/023.jpg'},
                {"a11":'data/024.jpg'}
            ];

        _imgLoader = ImgLoader();
        _imgLoader.load(resourceURL, resourcesLoaded);
    }

    function resourcesLoaded(images) {

        _images = images;

        _mayRender = true;

        onBeat();
    }

    function genParticle() {

        var AMOUNT = 20,
            MAX_SIZE = 90,
            p = [],
            x, y, r,
            dX, dY, dist,
            w = _ctx.canvas.width,
            h = _ctx.canvas.height,
            maxDistance = Math.sqrt(Math.pow(w / 2, 2) + Math.pow(h / 2, 2));

        for (var i = 0; i < AMOUNT; i++) {

            x = Random.float() * w;
            y = Random.float() * h;

            dX = (x - w / 2);
            dY = (y - h / 2);
            dist = Math.sqrt(Math.pow(dX, 2) + Math.pow(dY, 2));

            r = 24 + Math.abs(MAX_SIZE - (MAX_SIZE / maxDistance * dist));

            p.push({'x':x,
                    'y':y,
                    'r':r});
        }

        _particle = p;
    }

    function reveal() {

        _ctx.save();

        _ctx.globalCompositeOperation = 'destination-out';

        for (var i = 0; i < _particle.length; i++) {

            var gradient = _ctx.createRadialGradient(_particle[i].x, _particle[i].y, _particle[i].r -
                _particle[i].r / 3, _particle[i].x, _particle[i].y, _particle[i].r);
            gradient.addColorStop(0, 'rgba(0,0,0,.3)');
            gradient.addColorStop(1, 'rgba(0,0,0,0)');
            _ctx.fillStyle = gradient;
            _ctx.fillRect(_particle[i].x - _particle[i].r, _particle[i].y - _particle[i].r, _particle[i].x + (_particle[i].r * 2),  _particle[i].y + (_particle[i].r * 2));
        }

        genParticle();

        _ctx.restore();
    }

    function render(msT, beat, floatBeat) {

        if (_mayRender) {
            reveal();
        }
    }

    var _imageIndex = 0;
    function switchBGwithFG() {

        if (_mayRender) {

            //add grain from top
            _ctxBack.drawImage(_ctx.canvas, 0, 0, _ctx.canvas.width, _ctx.canvas.height);

            //write as new front
            _ctx.drawImage(_ctxBack.canvas, 0, 0, _ctx.canvas.width, _ctx.canvas.height);

            //FIX Hardcoded
            if(_imageIndex <= 11) {


                var index = 'a' + _imageIndex;

                _imageIndex++;

                //new pic to reveal
                _ctxBack.drawImage(_images[index], 0, 0);
            }
        }
    }

    function onBeat(beat) {

        if((_imageIndex > 0) && (_imageIndex < 7)) {
            if (beat % 5 === 0) {

                switchBGwithFG();
            }
        } else {

            if ((beat % 8 === 0) || (beat === undefined)) {

                switchBGwithFG();
            }
        }
    }

    function clear() {
        document.getElementById('root').removeChild(_holder);
    }

    function resize(w, h) {

    }

    return {
        init:init,
        render:render,
        onBeat:onBeat,
        clear:clear,
        resize:resize
    };

}());