// mog
/*jslint devel: true, browser: true */
var Intro = (function () {
    "use strict";
    var _duration = 0,
        _holder,
        _ctx,
        _mayRender,
        _images;

    function init(duration) {

        //console.log("CHANGE_ME - init()");

        _duration = duration;

        _holder = document.createElement('div');
        document.getElementById('root').appendChild(_holder);

        var canvas = document.createElement('canvas');
        _ctx = canvas.getContext('2d');
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
        canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(canvas);

        _ctx.globalAlpha = 0;

        var vignette = document.createElement('div');
        vignette.style.cssText = "position:absolute; width:100%;height:100%;z-index:5;box-shadow:inset 0 0 250px #1a0600;"
        _holder.appendChild(vignette);

        loadResources();
    }

    function loadResources() {

        var _imgLoader,
            resourceURL = [
                {"jp":'data/intro_notext.png'},
                {"dreams":'data/intro_text.png'}
            ];

        _imgLoader = ImgLoader();
        _imgLoader.load(resourceURL, resourcesLoaded);
    }

    function resourcesLoaded(images) {

        _images = images;

        _mayRender = true;
    }

    function render(msT, beat, floatBeat) {

        if (!_mayRender) {
            return;
        }

        _ctx.globalAlpha = 1;
        _ctx.fillRect(0, 0, _ctx.canvas.width, _ctx.canvas.height);

        _ctx.globalAlpha = msT / 8000;
        _ctx.drawImage(_images['jp'], 0, 0);

        if (msT >= 7000) {
            _ctx.globalAlpha = (msT - 7000) / 7000;
            _ctx.drawImage(_images['dreams'], 0, 0);
        }
    }

    function onBeat(beat) {

    }

    function clear() {
        document.getElementById('root').removeChild(_holder);
    }

    function resize(w, h) {

    }

    return {
        init:init,
        render:render,
        onBeat:onBeat,
        clear:clear,
        resize:resize
    };
}());