// mog
/*jslint devel: true, browser: true */
var IntoSpace = (function () {
    "use strict";
    var _duration = 0,
        _holder,
        _ctx,
        _ctxSF,
        particle = [],
        MAX_SEGMENT = 53,
        MAX_Z = 424,
        _images,
        _mayRender,
        _starfield = Starfield,
        _cloudCanvas,
        _whiteFlash;

    function init(duration) {

        _duration = duration;

        _holder = document.createElement('div');
        document.getElementById('root').appendChild(_holder);

        _cloudCanvas = document.createElement('canvas');
        _ctx = _cloudCanvas.getContext('2d');
        _cloudCanvas.width = window.innerWidth;
        _cloudCanvas.height = window.innerHeight;
        _cloudCanvas.style.cssText = 'position:absolute;';
        _holder.appendChild(_cloudCanvas);

        var canvasSF = document.createElement('canvas');
        _ctxSF = canvasSF.getContext('2d');
        canvasSF.width = window.innerWidth;
        canvasSF.height = window.innerHeight;
        canvasSF.style.cssText = 'position:absolute;';
        _holder.appendChild(canvasSF);

        _ctxSF.canvas.style.opacity = .01;
        _starfield.setContext(_ctxSF);

        _whiteFlash = document.createElement('div');
        _whiteFlash.style.cssText = "position:absolute; width:100%;height:100%;background:#ff3700;z-index:10;"
        _holder.appendChild(_whiteFlash);

        var vignette = document.createElement('div');
        vignette.style.cssText = "position:absolute; width:100%;height:100%;z-index:5;inset 0 0 100px #001869;"
        _holder.appendChild(vignette);

        document.body.style.backgroundColor = '#00071c';

        initFlyThrough();

        loadResources();
    }

    function loadResources() {

        var _imgLoader,
            resourceURL = [
                {"circle":'data/circlecloud.png'}
            ];

        _imgLoader = ImgLoader();
        _imgLoader.load(resourceURL, resourcesLoaded);
    }

    function resourcesLoaded(images) {

        _images = images;

        _mayRender = true;
    }

    function initFlyThrough(){
        var zDistance = 0;

        for(var i = 0; i < MAX_SEGMENT; i += 1) {

            particle.push({
                "x" : _ctx.canvas.width / 2,
                "y" : _ctx.canvas.height / 2,
                "z" : MAX_Z - zDistance
            });

            zDistance += 8;
        }
    }

    var cloudClearStyle = 'rgba(89, 120, 219, .5)';
    function render(msT, beat, floatBeat) {

        if(msT <= 2000) {
            _whiteFlash.style.opacity = 1 - (1 / 2000 * msT);
        }

        if (!_mayRender)
            return;

        if(msT >= (_duration - 18000)){

            var opacity = 1 / 18000 * (_duration - msT);
            _ctxSF.canvas.style.opacity = 1 - opacity;

        }

        if(msT >= (_duration - 24000)){
            cloudClearStyle = 'rgba(0, 24, 105, .9)';
            var opacity = 1 / 24000 * (_duration - msT);
            _cloudCanvas.style.opacity = opacity;
            _ctx.globalAlpha = opacity;
        }

        _ctxSF.clearRect(0,0,_ctxSF.canvas.width, _ctxSF.canvas.height);
        _starfield.render();

        var speed = 2 / _duration * msT +.1;

        _starfield.setSpeed(speed);

        //if(_ctx.globalAlpha >= 0)
            flyThrough(speed);
    }

    function flyThrough(speed){
        //clear
        _ctx.fillStyle = cloudClearStyle;
        _ctx.fillRect(0, 0, _ctx.canvas.width, _ctx.canvas.height);


        var freshParticle = [],
            shadowParticle = [],
            halfWidth = _ctx.canvas.height / 2,//_ctx.canvas.width / 2,
            halfHeight = _ctx.canvas.height / 2,
            vpY = Math.sin((new Date()).getTime() / 2000) * 23;

        for(var i = 0; i < MAX_SEGMENT; i += 1) {

            var drawX = halfWidth - (particle[i].x / particle[i].z * 8),
                drawY = halfHeight - (particle[i].y / particle[i].z * 8),
                drawWidth = (halfWidth - drawX) * 2,
                drawHeight = (halfHeight - drawY) * 2;

            particle[i].z -= speed;

            if( (particle[i].z > -110) && (drawX > -2100) && (drawY > -2100) ) {

                shadowParticle.push(particle[i]);

                _ctx.save();
                _ctx.translate(vpY, 0);
                _ctx.rotate(vpY * Math.PI / 180);
                plot(drawX, drawY, drawWidth, drawHeight);
                _ctx.restore();

            } else {

                shadowParticle.push({"x" : _ctx.canvas.width / 2,
                                     "y" : _ctx.canvas.height / 2,
                                     "z" : MAX_Z});
            }
        }

        _starfield.setCenter(_ctx.canvas.width / 2, _ctx.canvas.height - ( vpY * 10));

        particle = shadowParticle;
    }

    function plot(x, y, width, height) {

        _ctx.globalAlpha = (100 / _ctx.canvas.width * width) / 100;
        _ctx.drawImage(_images['circle'], x, y, width, height);
        _ctx.globalAlpha = 1;
    }

    function onBeat(beat) {

        if (beat % 8 === 0) {

        }
    }

    function clear() {
        document.getElementById('root').removeChild(_holder);
    }

    function resize(w, h) {

    }

    return {
        init:init,
        render:render,
        onBeat:onBeat,
        clear:clear,
        resize:resize
    };
}());