#version 330 core

#define NUMBER_OF_SAMPLES 128

// Input
in vec2 ex_TexCoord;

// Output
out vec4 out_FragColor;

// Uniforms
uniform sampler2D depthSampler;
uniform samplerCube visSampler;

uniform mat4 invViewMatrix;
uniform vec3 cameraPosInWorld;
uniform vec3 lightPosInWorld;
uniform vec2 viewport;
uniform vec3 lightColor;

uniform float time;

bool intersectBox(vec3 ro, vec3 rd, vec3 bbmin, vec3 bbmax, out float t0, out float t1)
{
    vec3 invR = 1.0 / rd;
    vec3 tbot = invR * (bbmin - ro);
    vec3 ttop = invR * (bbmax - ro);
    vec3 tmin = min(ttop, tbot);
    vec3 tmax = max(ttop, tbot);
    vec2 t = max(tmin.xx, tmin.yz);
    t0 = max(t.x, t.y);
    t = min(tmax.xx, tmax.yz);
    t1 = min(t.x, t.y);
    return t0 <= t1;
}

#if 0
void main()
{
	out_FragColor = texture(colorSampler, ex_TexCoord);
	//out_FragColor = vec4(texture(depthSampler, ex_TexCoord).rrr / 50., 1.0);
	//out_FragColor = vec4(texture(visSampler, vec3(-1., -1. + 2. * ex_TexCoord)).rrr / 50., 1.0);
	//out_FragColor = vec4(texture(visSampler, vec3(-1., vec2(-1. + 2. * ex_TexCoord.y, 1. - 2. * ex_TexCoord.x))).rrr / 20., 1.0);
}

#else
float myExp(float x)
{
	return 1 + x;
}

void main()
{
	float aspectRatio = viewport.x / viewport.y;

	vec3 rayDirInView = normalize(vec3(vec2(-1. + 2. * ex_TexCoord) * vec2(aspectRatio, 1.), -1.73 /* 1. / tan(0.5 * fov) */));

	vec3 rayStartInWorld = cameraPosInWorld;
	vec3 rayDirInWorld = normalize(vec3(invViewMatrix * vec4(rayDirInView, 0.0)));

	float tmin, tmax;

	// fetch the current radiance and depth
	float depth = textureLod(depthSampler, ex_TexCoord, 0).r;

	// intersect with the light's frustum. it's a point light, so we use a cube.
	if (intersectBox(rayStartInWorld, rayDirInWorld, vec3(-6., -3., -10.), vec3(6., 5., 10.), tmin, tmax) && tmin < depth)
	//if (intersectBox(rayStartInWorld, rayDirInWorld, vec3(-60., -20., -60.), vec3(0., 20., 40.), tmin, tmax) && tmin < depth)
	{
		tmin = max(0., tmin);
		tmax = min(depth, tmax);

		vec3 rayPos = rayStartInWorld + tmin * rayDirInWorld;

		// precompute the step
		float rayStep = (tmax - tmin) / float(NUMBER_OF_SAMPLES);

		// homogeneous opacity
		float opacity = .05;
		float opacityPerStep = opacity * rayStep;

		// scattering contribution
		vec4 scat = vec4(0.);

		for (int i = 0; i < NUMBER_OF_SAMPLES; ++i)
		{
			// (light is centered at 0,0,0)
			vec3 lightRay = rayPos - lightPosInWorld;

			// distance from light
			float dist = length(lightRay);

			// lookup the shadow map 
			float smpDepth = textureLod(visSampler, lightRay, 0).r;

			// if the current point isn't occluded add the contribution
			if (dist < smpDepth)
			{
				// sample the noise in the light direction
				//float noise = texture(noiseSampler, vec3(0.5, time / 10., 0.5) + 0.4 * normalize(-lightRay)).r;

				// reduced light intensity
				//vec3 Lri = lightColor;
				vec3 Lri = 2. * lightColor * exp(-opacity * dist);
				//vec3 Lri = vec3(1., 0., 0.) * exp(-opacity * dist);

				// attenuation
				float att = 1.;// / (1. + dist * dist);

				// add contribution
				scat.rgb = scat.rgb + (1. - scat.a) * Lri * att * opacityPerStep;
				//scat.rgb = mix(scat.rgb, Lri * att * opacityPerStep, scat.a);
				//scat.rgb = scat.rgb + (1. - scat.a) * Lri * att * opacityPerStep;
				//scat.a = scat.a + (1. - scat.a) * opacityPerStep;
			}

			//scat = scat + (1. - scat.a) * vec4(smpColor * opacityPerStep, opacityPerStep);
			scat.a = scat.a + (1. - scat.a) * opacityPerStep;

			//if (scat.a > 0.99)
			//{
			//	scat /= scat.a;
			//	break;
			//}

			rayPos += rayStep * rayDirInWorld;
		}

		//scat.rgb /= scat.a;

		// final contribution
		//out_FragColor = vec4(scat.rgb + color * exp(-opacity * (tmax - tmin)), 1.);
		out_FragColor = vec4(scat.rgb, exp(-opacity * (tmax - tmin)));
	}
	else
	{
		//vec3 p = rayStartInWorld + depth * rayDirInWorld;
		//out_FragColor = vec4(color * (1. - exp(-.2 * length(p))), 1.);
		//out_FragColor = vec4(color * 0.5 * (1. - exp(-.2 * depth)), 1.);
		//out_FragColor = vec4(color, 1.);
		out_FragColor = vec4(0., 0., 0., 1.);
	}
}
#endif
