#version 330 core

// Input
layout (location = 0) in vec4 in_Position;
layout (location = 1) in vec4 in_Color;
layout (location = 2) in vec3 in_Velocity;
layout (location = 3) in float in_Life;

// Output
out vec4 gm_Color;
out float gm_Life;

// Uniforms
uniform mat4 worldViewMatrix;

void main()
{
	gl_Position = worldViewMatrix * in_Position;
	gm_Color = in_Color;
	gm_Life = in_Life;
}
