#version 330 core

// Input
in vec3 ex_PositionInView;
in vec2 ex_TexCoord;
flat in float ex_Life;
in vec4 ex_Color;

// Output
out vec4 out_FragColor;

// Uniforms
uniform sampler2D colorSampler;
uniform vec4 color;

uniform vec3 lightPosInView;
uniform bool useLighting;

void main()
{
	float alpha = texture(colorSampler, ex_TexCoord).r;

	float Ka = 0.;
	float Kd = 1.;

	if (useLighting)
	{
		vec3 N = vec3(0., 0., 1.);
		vec3 L = normalize(lightPosInView - ex_PositionInView);

		Ka = 0.2;
		Kd = max(0., dot(N, L));
	}

	out_FragColor = vec4(ex_Color.rgb * (Ka + Kd), ex_Color.a * alpha * ex_Life);
}
