#version 330 core

// Input
layout (location = 0) in vec3 in_Position;
layout (location = 1) in vec3 in_Normal;
layout (location = 2) in vec3 in_Color;
layout (location = 3) in float in_Life;

// Output
out vec3 out_Position;
out vec3 out_Normal;
out vec3 out_Color;
out float out_Life;

// Uniforms
uniform float dt;

void main()
{
	float life = in_Life - .7 * dt;
	float speed = 1.f - life;

	vec3 normal = in_Normal;
	vec3 position = in_Position + normal / 100.f * (speed * speed);

	if (life < 0.)
	{
		life = 1.;
		position = in_Normal;
	}

	out_Position = position;
	out_Normal = normal;
	out_Color = in_Color;
	out_Life = life;
}
