#version 330 core

// Input
in vec2 ex_TexCoord;

// Output
out vec4 out_FragColor;

// Uniforms
uniform sampler2D colorSampler;

uniform vec2 scale;
uniform float offset[5] = float[](0.0, 1.0, 2.0, 3.0, 4.0);
uniform float weight[5] = float[](0.2270270270, 0.1945945946, 0.1216216216, 0.0540540541, 0.0162162162);

void main()
{
	vec4 color = texture(colorSampler, ex_TexCoord) * weight[0];

	for (int i = 1; i < 5; i++)
	{
		color += texture(colorSampler, ex_TexCoord + scale * offset[i]) * weight[i];
		color += texture(colorSampler, ex_TexCoord - scale * offset[i]) * weight[i];
	}

	out_FragColor = color;
}
